# 帳票設計書 28-wlanstat - 802.11無線ネットワーク統計レポート

## 概要

本ドキュメントは、FreeBSDのwlanstatコマンドが出力する802.11無線ネットワーク統計レポートの帳票設計書である。wlanstatはIEEE 802.11無線LANインターフェースの統計情報を表示する。

### 本帳票の処理概要

wlanstatコマンドは、ioctl経由で802.11ドライバから無線LAN統計情報を取得し、定期的に更新しながら表示する。入力パケット数、出力パケット数、管理フレーム数、信号強度（RSSI）、ノイズレベル、転送レートなど多数の統計カウンタをサポートする。

**業務上の目的・背景**：無線ネットワークの品質監視と障害解析において、リアルタイムの統計情報は重要である。電波状況、パケットエラー率、A-MPDU/A-MSDU集約の動作状況などを把握することで、無線LAN環境の最適化や障害原因の特定が可能になる。

**帳票の利用シーン**：無線LAN接続品質の監視、パケットロスの原因調査、電波干渉の検出、802.11nのA-MPDU集約の動作確認、ローミング問題の調査などで使用される。

**主要な出力内容**：
1. input: 受信パケット数
2. output: 送信パケット数
3. rx_mgmt: 受信管理フレーム数
4. scan_active/scan_bg: スキャン回数
5. bmiss: ビーコンミス回数
6. rssi: 受信信号強度
7. noise: ノイズレベル
8. rate: 転送レート

**帳票の出力タイミング**：コマンドラインからwlanstatコマンドを実行した時点で出力。intervalを指定すると定期更新。

**帳票の利用者**：ネットワーク管理者、無線LAN運用担当者

## 帳票種別

統計表（テキスト形式、定期更新可能）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | コマンドライン | ターミナル | `wlanstat [-i ifname] [-o fmt] [interval]` 実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ASCII |

## 帳票レイアウト

### レイアウト概要

2つのモードがある: interval指定時は定期更新テーブル、未指定時は詳細テキスト出力。

```
┌─────────────────────────────────────────────┐
│ ヘッダー行（カラム名）                         │
├─────────────────────────────────────────────┤
│ 累計値行（初回）                              │
│ 差分値行（2回目以降）                          │
│           ...                               │
│ (21行ごとにヘッダー再表示)                     │
└─────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | input | 受信パケット数 | ieee80211_stats | 整数 |
| 2 | rx_mgmt | 受信管理フレーム数 | ieee80211_stats | 整数 |
| 3 | output | 送信パケット数 | ieee80211_stats | 整数 |
| 4 | rssi | 受信信号強度 | ieee80211_stats | 整数 |
| 5 | noise | ノイズレベル | ieee80211_stats | 整数 |
| 6 | rate | 転送レート | ieee80211_stats | 整数 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 統計値 | 各カウンタの累計/差分値 | ioctl経由 | 整数 | フォーマット依存 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | フッターは出力されない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| -i ifname | インターフェース名指定（デフォルト: wlan0） | No |
| -o fmt | 出力フォーマット（default, ampdu, amsdu等） | No |
| -l | 利用可能フィールド一覧表示 | No |
| -m MAC | 特定ステーションのMAC指定 | No |
| interval | 更新間隔（秒） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | フォーマット定義順 | 定義順 |

### 改ページ条件

interval指定時、21行ごとにヘッダーを再表示（行253: `if (line == 21)`）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| IEEE80211_IOC_STA_STATS（ioctl） | ステーション統計取得 | インターフェース名 |
| 802.11ドライバ | 無線LAN統計情報 | ioctl経由 |

### テーブル別参照項目詳細

#### IEEE80211統計

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| ns_rx_data | input | ioctl | 受信データパケット |
| ns_tx_data | output | ioctl | 送信データパケット |
| ns_rx_mgmt | rx_mgmt | ioctl | 受信管理フレーム |
| ns_rx_beacons | beacon | ioctl | 受信ビーコン |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 差分値 | 現在値 - 前回値 | N/A | interval指定時の増分 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コマンド実行] --> B[wlanstat_new - 初期化]
    B --> C[getopt - オプション解析]
    C --> D{interval指定?}
    D -->|Yes| E[定期更新ループ]
    D -->|No| F[詳細出力]
    E --> G[ヘッダー表示]
    G --> H[collect_tot - 累計値収集]
    H --> I[print_total - 累計値表示]
    I --> J[SIGALRM待ち]
    J --> K[collect_cur - 現在値収集]
    K --> L[print_current - 差分値表示]
    L --> M[update_tot - 累計更新]
    M --> J
    F --> N[collect_tot]
    N --> O[print_verbose - 詳細表示]
    O --> P[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| IF未検出 | 指定インターフェース不存在 | err()出力 | 正しいIF名を指定 |
| ioctl失敗 | 統計情報取得失敗 | err()出力 | ドライバ状態確認 |
| 無効なMAC | MACアドレス解析失敗 | errx()出力 | 正しいMAC形式を指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1インターフェースの統計（数十カウンタ） |
| 目標出力時間 | 即時 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 無線LAN統計情報へのアクセスにはインターフェースのioctl権限が必要
- 信号強度やノイズ情報から物理的な位置情報が推測される可能性

## 備考

- デフォルトインターフェースはWLAN環境変数またはwlan0
- 出力フォーマットはタグ名で選択可能（default, ampdu, amsdu）
- wlanstat_newでオブジェクト指向風のインターフェース（関数ポインタ）を使用
- SIGALRMシグナルでタイマー制御（interval指定時）
- 21行ごとにヘッダーを再表示する画面制御

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | wlanstat.h | `usr.sbin/wlanstat/wlanstat.h` | wlanstatfoo構造体の定義。関数ポインタでオブジェクト指向風インターフェースを提供 |
| 1-2 | main.c | `usr.sbin/wlanstat/main.c` | tags配列（行50-66）: 出力フォーマット定義。"default", "ampdu", "amsdu"の3プリセット |

**読解のコツ**: wlanstatfoo構造体の関数ポインタ（setifname, setfmt, print_header, collect_cur等）がコアインターフェース。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.c | `usr.sbin/wlanstat/main.c` | main()関数（行164-297）。wlanstat_new()で初期化後、オプション解析、interval有無で分岐 |

**主要処理フロー**:
1. **行176-179**: WLAN環境変数チェック、デフォルトwlan0
2. **行179**: wlanstat_new()でwlanstatfooオブジェクト生成
3. **行183-214**: getopt()によるオプション解析（-h, -i, -l, -m, -o）
4. **行218-219**: getopmode()でSTAモード判定、setstamac()でMAC設定
5. **行221-257**: interval指定時の定期更新ループ（SIGALRMベース）
6. **行227**: signal(SIGALRM, catchalarm)でタイマーシグナル設定
7. **行230-256**: banner表示 → collect/print → alarm待ち → ループ
8. **行253**: line==21でヘッダー再表示
9. **行292-295**: interval未指定時はcollect_tot → print_verbose

### プログラム呼び出し階層図

```
main() [main.c 行164]
    │
    ├─ wlanstat_new(ifname, fmt) - オブジェクト生成 [行179]
    ├─ getopt() - オプション解析 [行183]
    ├─ wf->getopmode() - 動作モード取得 [行218]
    ├─ wf->setstamac() - ステーションMAC設定 [行219]
    │
    ├─ [interval指定時]
    │      ├─ signal(SIGALRM, catchalarm) [行227]
    │      ├─ wf->print_header() - ヘッダー表示 [行231]
    │      ├─ wf->collect_tot() - 累計値収集 [行239]
    │      ├─ wf->print_total() - 累計値表示 [行240]
    │      └─ ループ:
    │             ├─ wf->collect_cur() - 現在値収集 [行235]
    │             ├─ wf->print_current() - 差分値表示 [行236]
    │             └─ wf->update_tot() - 累計更新 [行237]
    │
    └─ [interval未指定時]
           ├─ wf->collect_tot() [行293]
           └─ wf->print_verbose() [行294]
```

### データフロー図

```
[入力]               [処理]                    [出力]

WLAN環境変数     ───▶ IF名決定
コマンドライン

802.11ドライバ   ───▶ ioctl統計取得       ───▶ ieee80211_stats
                      │
                      ├─ collect_tot()     ───▶ 累計値
                      └─ collect_cur()     ───▶ 差分値
                                                │
                                                ▼
                                           標準出力
                                           (テーブル形式/詳細形式)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.c | `usr.sbin/wlanstat/main.c` | ソース | エントリーポイント、タグ定義、メインループ |
| wlanstat.h | `usr.sbin/wlanstat/wlanstat.h` | ヘッダー | wlanstatfoo構造体定義 |
| Makefile | `usr.sbin/wlanstat/Makefile` | ビルド | ビルド設定 |
