# 帳票設計書 31-rpcinfo

## 概要

本ドキュメントは、FreeBSDのrpcinfoコマンドが生成するRPC情報レポートの設計を記述する。rpcinfoは、RPCサーバーに関する情報をレポートし、登録済みRPCサービスの一覧を標準出力に出力するCLIユーティリティである。

### 本帳票の処理概要

rpcinfoコマンドは、rpcbind（ポートマッパー）に問い合わせることで、ホスト上に登録されたRPCプログラムの情報を取得し、レポートとして出力する。

**業務上の目的・背景**：分散コンピューティング環境においてRPC（Remote Procedure Call）サービスの可用性を確認することは、NFSやNISなどの重要なネットワークサービスの運用管理に不可欠である。rpcinfoはシステム管理者がRPCサービスの登録状態やバージョン情報を迅速に確認するためのツールとして利用される。

**帳票の利用シーン**：ネットワークサービスの障害調査時にRPCサービスの登録状況を確認する場合、NFSマウント失敗時のトラブルシューティング、新規RPCサービスのデプロイ後の疎通確認、rpcbindの統計情報収集による性能分析に利用される。

**主要な出力内容**：
1. 登録済みRPCプログラムの一覧（プログラム番号、バージョン、ネットワークID、アドレス、サービス名、オーナー）
2. ポートマッパー登録情報（プログラム番号、バージョン、プロトコル、ポート番号、サービス名）
3. rpcbind統計情報（PORTMAP/RPCBIND v3/v4の各プロシージャ呼び出し統計）
4. RPCプログラムのping結果（プログラムの応答確認）

**帳票の出力タイミング**：システム管理者がコマンドラインからrpcinfoコマンドを実行した際に即時出力される。

**帳票の利用者**：システム管理者、ネットワーク管理者、インフラエンジニア

## 帳票種別

一覧表 / 統計レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIターミナル | N/A | `rpcinfo [options] [host]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力、リダイレクトにより任意ファイルへ保存可能） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ロケール依存（通常ASCII） |

### PDF固有設定

該当なし（テキスト出力）

### Excel固有設定

該当なし（テキスト出力）

## 帳票レイアウト

### レイアウト概要

rpcinfoは動作モードによって異なるレイアウトで出力する。主要な出力形式は以下の通り。

```
┌──────────────────────────────────────────────────────────────────┐
│  ヘッダー行（カラム見出し）                                        │
├──────────────────────────────────────────────────────────────────┤
│  明細行（各RPCプログラムの情報）                                    │
│  ...                                                            │
└──────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

#### RPCBDUMP形式（デフォルト: `rpcinfo [host]`）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | program | RPCプログラム番号 | rpcbind RPCBPROC_DUMP | %10u |
| 2 | version | プログラムバージョン | rpcbind RPCBPROC_DUMP | %5u |
| 3 | netid | ネットワークトランスポートID | rpcbind RPCBPROC_DUMP | %-9s |
| 4 | address | ユニバーサルアドレス | rpcbind RPCBPROC_DUMP | %-22s |
| 5 | service | サービス名 | getrpcbynumber() | %-10s |
| 6 | owner | オーナー | rpcbind RPCBPROC_DUMP | %s |

#### PMAPDUMP形式（`rpcinfo -p [host]`）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | program | RPCプログラム番号 | portmapper PMAPPROC_DUMP | %10ld |
| 2 | vers | バージョン番号 | portmapper PMAPPROC_DUMP | %5ld |
| 3 | proto | プロトコル（udp/tcp/local） | portmapper PMAPPROC_DUMP | %6s |
| 4 | port | ポート番号 | portmapper PMAPPROC_DUMP | %7ld |
| 5 | service | サービス名 | getrpcbynumber() | %s |

### 明細部

明細部はヘッダー部と同一構造で、登録されている各RPCプログラムごとに1行出力される。

### フッター部

該当なし（データがない場合は "No remote programs registered." と出力）

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ホスト名 | 問い合わせ先ホスト（省略時はローカルホスト） | No |
| プログラム番号 | 特定プログラムの情報のみ表示（-l, -t, -u オプション時） | 条件による |
| バージョン番号 | 特定バージョンの情報のみ表示 | No |
| ネットワークID | 特定トランスポートでフィルタ（-T オプション） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | rpcbindからの返却順（登録順） | 該当なし（登録順） |

### 改ページ条件

改ページなし（連続出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| rpcbind登録情報 | RPC登録サービス一覧取得 | RPC呼び出しによる取得 |
| /etc/rpc | RPC番号からサービス名への変換 | getrpcbynumber()による参照 |

### テーブル別参照項目詳細

#### rpcbind登録情報

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| r_prog | program | RPCBPROC_DUMP呼び出し | RPCプログラム番号 |
| r_vers | version | RPCBPROC_DUMP呼び出し | バージョン番号 |
| r_netid | netid | RPCBPROC_DUMP呼び出し | tcp/udp/local等 |
| r_addr | address | RPCBPROC_DUMP呼び出し | ユニバーサルアドレス |
| r_owner | owner | RPCBPROC_DUMP呼び出し | サービスオーナー |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 統計情報（-m） | rpcb_stat構造体の各カウンタ値 | N/A | rpcbind内部統計 |
| success合計 | SUM(pa->success) for addrinfo chain | N/A | GETADDR/GETPORT成功回数 |
| rmtcall success合計 | SUM(pr->success) for rmtinfo chain | N/A | CALLIT成功回数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コマンド実行] --> B[オプション解析]
    B --> C{動作モード判定}
    C -->|RPCBDUMP| D[rpcbdump関数]
    C -->|PMAPDUMP| E[pmapdump関数]
    C -->|TCPPING/UDPPING| F[ip_ping関数]
    C -->|PROGPING| G[progping関数]
    C -->|RPCBGETSTAT| H[rpcbgetstat関数]
    C -->|RPCBADDRLIST| I[rpcbaddrlist関数]
    C -->|BROADCAST| J[brdcst関数]
    C -->|DELETES| K[deletereg関数]
    D --> L[RPCクライアント作成]
    L --> M[RPCBPROC_DUMP呼び出し]
    M --> N[結果をprintf出力]
    N --> O[終了]
    E --> L
    F --> L
    G --> L
    H --> L
    I --> L
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 接続失敗 | rpcbindに接続できない | "rpcinfo: can't contact rpcbind" | ホスト名・ネットワーク確認 |
| ポートマッパー未対応 | ホストがportmapperをサポートしない | "does not support portmapper" | rpcinfo（引数なし）を使用 |
| プログラム不在 | 指定プログラムが登録されていない | "program X is not available" | プログラム番号確認 |
| バージョン不一致 | 指定バージョンが存在しない | RPC_PROGVERSMISMATCH | 対応バージョン確認 |
| 不正ポート番号 | -nオプションに不正値 | "is illegal port number" | 正しいポート番号指定 |
| メモリ不足 | malloc失敗 | "no memory" | システムリソース確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百件（登録RPCサービス数） |
| 目標出力時間 | 数秒以内（ネットワーク遅延依存） |
| 同時出力数上限 | 制限なし（CLIツール） |

## セキュリティ考慮事項

- rpcbindへの問い合わせはネットワーク経由で行われるため、ファイアウォール設定により制限される場合がある
- deletereg（-d）オプションはRPCサービスの登録削除を行うため、適切な権限管理が必要
- リモートホストへの問い合わせにより、サービスの存在情報が漏洩する可能性がある

## 備考

- rpcinfoはSun Microsystems由来のRPCユーティリティであり、PortMapper（v2）とrpcbind（v3/v4）の両方に対応している
- PORTMAP定義が有効な場合、-p, -t, -u オプションが利用可能になる
- `rpcinfo -s` で短縮形式の出力が可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RPCの通信で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | 行100-116: netidlist, verslist, rpcbdump_short構造体の定義 |

**読解のコツ**: rpcbdump_short構造体は短縮表示（-sオプション）用のリンクリスト構造。RPC関連の型定義は`<rpc/rpc.h>`ヘッダに含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | 行151-301: main関数 - オプション解析と動作モード分岐 |

**主要処理フロー**:
1. **行167**: getoptによるオプション解析（-p, -t, -u, -a, -b, -d, -l, -m, -s, -T）
2. **行254-258**: デフォルト動作判定（引数数によりPROGPINGまたはRPCBDUMP）
3. **行261-299**: switch文による各動作モードへのディスパッチ

#### Step 3: RPC登録情報ダンプ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | 行668-866: rpcbdump関数 - RPCBDUMP/RPCBDUMP_SHORT処理 |

**主要処理フロー**:
- **行686-703**: RPCクライアントの作成（リモート/ローカル）
- **行712-714**: RPCBPROC_DUMP呼び出しによる登録情報取得
- **行791-805**: RPCBDUMP形式の出力フォーマット
- **行806-861**: RPCBDUMP_SHORT形式の出力フォーマット

#### Step 4: ポートマッパーダンプ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | 行458-545: pmapdump関数 |

**主要処理フロー**:
- **行477-480**: portmapperクライアントの作成
- **行499-501**: PMAPPROC_DUMP呼び出し
- **行524-544**: 結果のフォーマット出力（program/vers/proto/port/service）

#### Step 5: 統計情報取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | 行972-1194: rpcbgetstat関数 |

**主要処理フロー**:
- **行1015-1017**: RPCBPROC_GETSTAT呼び出し
- **行1021-1060**: PORTMAP v2統計出力
- **行1074-1125**: RPCBIND v3統計出力
- **行1127-1193**: RPCBIND v4統計出力

### プログラム呼び出し階層図

```
main()
    |
    +-- getopt() [オプション解析]
    |
    +-- rpcbdump() [デフォルト/短縮ダンプ]
    |       +-- clnt_rpcbind_create() / local_rpcb()
    |       +-- CLNT_CALL(RPCBPROC_DUMP)
    |       +-- getrpcbynumber() [サービス名解決]
    |
    +-- pmapdump() [ポートマッパーダンプ]
    |       +-- clnttcp_create() / local_rpcb()
    |       +-- CLNT_CALL(PMAPPROC_DUMP)
    |       +-- getrpcbynumber()
    |
    +-- ip_ping() [TCP/UDP ping]
    |       +-- clnt_com_create()
    |       +-- CLNT_CALL(NULLPROC)
    |       +-- pstatus()
    |
    +-- progping() [プログラムping]
    |       +-- clnt_tp_create() / clnt_create()
    |       +-- CLNT_CALL(NULLPROC)
    |       +-- pstatus()
    |
    +-- rpcbgetstat() [統計取得]
    |       +-- CLNT_CALL(RPCBPROC_GETSTAT)
    |       +-- print_rmtcallstat()
    |       +-- print_getaddrstat()
    |
    +-- rpcbaddrlist() [アドレスリスト]
    |       +-- CLNT_CALL(RPCBPROC_GETADDRLIST)
    |
    +-- brdcst() [ブロードキャスト]
    |       +-- rpc_broadcast()
    |       +-- reply_proc()
    |
    +-- deletereg() [登録削除]
            +-- rpcb_unset()
```

### データフロー図

```
[入力]                   [処理]                        [出力]

コマンドライン引数 ──> main()                       ──> 標準出力
                        |                                |
ホスト名/IP ──────> RPCクライアント作成              ──> RPCプログラム一覧
                        |                                |
rpcbind応答 ──────> RPCBPROC_DUMP/PMAPPROC_DUMP     ──> フォーマット済みテーブル
                        |                                |
/etc/rpc ─────────> getrpcbynumber()                ──> サービス名
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rpcinfo.c | `usr.bin/rpcinfo/rpcinfo.c` | ソース | メインプログラム（全機能を単一ファイルに実装） |
| Makefile | `usr.bin/rpcinfo/Makefile` | 設定 | ビルド設定 |
| rpc.h | `/usr/include/rpc/rpc.h` | ヘッダ | RPC関連の型定義・関数宣言 |
| rpcb_prot.h | `/usr/include/rpc/rpcb_prot.h` | ヘッダ | rpcbindプロトコル定義 |
| pmap_prot.h | `/usr/include/rpc/pmap_prot.h` | ヘッダ | portmapperプロトコル定義 |
