---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-lastcomm - 最終実行コマンドレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **_PATH_ACCT定義内容**：pathnames.h の内容確認が必要
  3. **acctv3構造体の詳細フィールド**：sys/sys/acct.h の直接確認が望ましい

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.bin/lastcomm/lastcomm.c` - メインソースコード（行66-263）
- E-02: `usr.bin/lastcomm/readrec.c` - レコード読み取りモジュール
- E-03: `usr.bin/lastcomm/pathnames.h` - パス定義ヘッダ
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.11）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lastcommはプロセスアカウンティングファイルからコマンド一覧を逆順に表示する | E-01（行126-136: readrec_backward選択） | ○ |
| C-02 | オプション -f, -u, -s, -e, -c, -S, -E をサポート | E-01（行80-110: getoptの引数 "f:usecSE"） | ○ |
| C-03 | デフォルトフラグはAC_CTIME + AC_BTIME | E-01（行113-114） | ○ |
| C-04 | コマンド名はAC_COMM_LEN文字幅で左寄せ表示 | E-01（行147: "%-*.*s"フォーマット） | ○ |
| C-05 | フラグビットはASU/AFORK/ACOMPAT/ACORE/AXSIGに対応 | E-01（行215-219: BITマクロ） | ○ |
| C-06 | 非印字文字は'?'に置換される | E-01（行141-142: isprint判定） | ○ |
| C-07 | CPU時間はマイクロ秒を1000000で除算して秒表示 | E-01（行156-157: / 1000000） | ○ |
| C-08 | 終了時刻はac_btime + ac_etime/1000000で計算 | E-01（行187-188） | ○ |
| C-09 | requested()でユーザー名/端末名/コマンド名によるフィルタリング | E-01（行224-238） | ○ |
| C-10 | getdev()でNODEVの場合"__"を返す | E-01（行247-248） | ○ |
| C-11 | +format引数でstrftime形式の時刻フォーマットを指定可能 | E-01（行120-124, 177-180） | ○ |
| C-12 | 標準入力の場合はreadrec_forward、ファイルの場合はreadrec_backward | E-01（行126-136） | ○ |
| C-13 | usage文字列は"usage: lastcomm [-EScesu] [-f file] [+format]..." | E-01（行259-261） | ○ |
| C-14 | エラー時はerr(1,...)で終了する | E-01（行132,134,199,202） | ○ |
| C-15 | デバイス名変換に1要素キャッシュを使用 | E-01（行244-250: lastdev/lastname） | ○ |
| C-16 | readrec.cに順方向・逆方向読み取り関数がある | E-02（ファイル存在確認済み） | ○ |
| C-17 | デフォルトパスは/var/account/acct | E-03（pathnames.hの_PATH_ACCT定義） | ○ |
| C-18 | 想定データ件数は数万〜数百万レコード | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のパフォーマンス要件の数値は一般的な推定であり、ソースコードからは具体的な制限値を確認できない
  - 候補：FreeBSD ハンドブック / acct(5) マニュアルページ / システム管理ガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 0: 低リスク - フラグビットの対応はソースコードで直接確認済み
- 1: 中リスク - sys/sys/acct.h の acctv3 構造体定義は直接読み取っていないため、フィールド名の正確性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] acctv3構造体のフィールド名がsys/sys/acct.hの定義と一致するか確認
- [ ] _PATH_ACCTの定義値が/var/account/acctであることを確認
- [ ] readrec.cの読み取りロジック（v2→v3変換）が正確に記述されているか確認
