---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-repquota - ファイルシステムクォータ要約レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **quota.hの構造体定義**：直接読み取っていないため要確認
  2. **libutil依存のhumanize_number動作**：外部ライブラリの仕様確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/repquota/repquota.c` - メインソースコード（行96-359）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.12）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UFSファイルシステムのみサポート | E-01（行151: strcmp "ufs"） | ○ |
| C-02 | -a, -g, -h, -n, -u, -v オプションをサポート | E-01（行104: "aghnuv"） | ○ |
| C-03 | デフォルトはユーザークォータ（uflag） | E-01（行132-136） | ○ |
| C-04 | 使用量ゼロのエントリは除外 | E-01（行217-218） | ○ |
| C-05 | ブロック超過は'+',未超過は'-'で表示 | E-01（行222-228） | ○ |
| C-06 | timeprt()で猶予期間を日/時:分/分に変換 | E-01（行332-359） | ○ |
| C-07 | prthumanval()でhuman-readable表示 | E-01（行250-266） | ○ |
| C-08 | FUHASHは1024 | E-01（行78） | ○ |
| C-09 | ファイルシステムごとにセクション分け | E-01（行204-205: multiple++とprintf "\n"） | ○ |
| C-10 | quota_open/quota_read/quota_closeでクォータアクセス | E-01（行194, 215, 246） | ○ |
| C-11 | パスワード/グループDBの事前読み込み | E-01（行137-148: setpwent/setgrent） | ○ |
| C-12 | dbtokbマクロでDEV_BSHIFTに応じた変換 | E-01（行58-66） | ○ |
| C-13 | -vオプションでクォータなしFSも報告 | E-01（行195-201: vflag判定） | ○ |
| C-14 | ID数値表示は-nオプション | E-01（行86: nflag） | ○ |
| C-15 | fstab走査はsetfsent/getfsent | E-01（行149-169） | ○ |
| C-16 | quota.hのdqblk構造体フィールド名 | **根拠なし**（直接読み取っていない） | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: ufs/ufs/quota.hを直接読み取っていないため、dqblk構造体のフィールド名は推測に基づく
  - 候補：ufs/ufs/quota.h を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの主要ロジックは全て確認済み
- 1: 中リスク - quota.hの構造体定義は間接的な参照のみ

## 6) レビュアーチェックリスト（最小）
- [ ] ufs/ufs/quota.hのdqblk構造体フィールド名が正確か確認
- [ ] humanize_number()のフォーマット仕様が正確か確認
- [ ] libutil依存関係が正しく記述されているか確認
