---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：13-quot - ディスク使用量ユーザー別レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **UFS iノード構造体のフィールド名**：dinode.h を直接読み取っていない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/quot/quot.c` - メインソースコード（行34-533）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.13）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つの動作モード（douser/dofsizes/donames）をサポート | E-01（行62, 481, 489, 504） | ○ |
| C-02 | デフォルトはdouserモード | E-01（行481） | ○ |
| C-03 | UFS1/UFS2両方をDIPマクロで対応 | E-01（行99-101） | ○ |
| C-04 | SIZEマクロで512バイトブロックをblocksize単位に変換 | E-01（行92） | ○ |
| C-05 | douserの出力はqsortで使用量降順ソート | E-01（行260-261, 374） | ○ |
| C-06 | 30/60/90日未使用量をuses()で集計 | E-01（行263-282） | ○ |
| C-07 | get_inode()にバッファキャッシュ機構がある | E-01（行106-151） | ○ |
| C-08 | isfree()でIFMTに基づきフリーiノードを判定 | E-01（行153-171） | ○ |
| C-09 | ユーザーハッシュテーブルは動的リハッシュ可能 | E-01（行202-220: usrrehash） | ○ |
| C-10 | -aオプションでgetmntinfo()を使用してUFS走査 | E-01（行519-523） | ○ |
| C-11 | sbget()でスーパーブロック読取り | E-01（行454） | ○ |
| C-12 | -kでblocksize=1024固定 | E-01（行498-499） | ○ |
| C-13 | -Nでnoname=true（UID数値表示） | E-01（行500-501） | ○ |
| C-14 | donamesモードはstdinからiノード番号を読み取る | E-01（行403: getline from stdin） | ○ |
| C-15 | dinode.hのdi_blocks/di_uid/di_atimeフィールド | **根拠なし**（直接未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: ufs/ufs/dinode.h を直接読み取っていないため、フィールド名はDIPマクロの使用箇所から推測
  - 候補：ufs/ufs/dinode.h を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの主要ロジック全て確認済み
- 1: 中リスク - UFS内部構造体の正確性は間接確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] ufs/ufs/dinode.h のフィールド名がDIPマクロ経由の参照と一致するか確認
- [ ] sbget()の引数UFS_STDSB/UFS_NOCSUMの意味を確認
- [ ] getmntpoint()のマウントポイント解決動作を確認
