---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：14-top - CPU使用率上位プロセスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **プロセス一覧のカラム名と表示形式**：machine.c のformat_next_process()を詳細確認必要
  2. **対話操作の詳細**：top.c の対話モードコマンド一覧
  3. **display.c の画面描画ロジック**：直接読み取っていない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/top/top.c` - メインプログラム（ソースコード確認済み）
- E-02: `usr.bin/top/machine.c` - FreeBSD固有データ取得（ソースコード確認済み、大規模ファイル）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.14）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | topはリアルタイムでCPU使用率上位プロセスを表示 | E-01, E-03 | ○ |
| C-02 | machine.cにFreeBSD固有のデータ取得ロジック | E-02（ファイル存在・構造確認済み） | ○ |
| C-03 | sysctlbyname("kern.cp_time")でCPU統計取得 | E-02（machine.c内で確認） | ○ |
| C-04 | kvm_getprocs()でプロセス情報取得 | E-02（machine.c内で確認） | ○ |
| C-05 | CPU使用率はcp_time差分から計算 | E-02（一般的なtop実装パターン） | ○ |
| C-06 | メモリ統計はvm.stats.vm sysctlから取得 | E-02（machine.c内で確認） | ○ |
| C-07 | kvm_getswapinfo()でスワップ情報取得 | E-02（machine.c内で確認） | ○ |
| C-08 | デフォルト更新間隔は2秒 | E-01（top.c で確認） | ○ |
| C-09 | -bオプションでバッチモード | E-01（top.c で確認） | ○ |
| C-10 | 明細部のカラム名（PID/USERNAME/THR/PRI等） | **根拠なし**（format_next_process詳細未確認） | △ |
| C-11 | display.cに画面描画ロジック | **根拠なし**（ファイル直接未確認） | △ |
| C-12 | -Uオプションでユーザーフィルタ | E-01（top.cで確認） | ○ |
| C-13 | -Iオプションでアイドルプロセス除外 | E-01（top.cで確認） | ○ |
| C-14 | 対話モードの操作コマンド詳細 | **根拠なし**（対話部分の詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: format_next_process()の出力フォーマットの詳細はmachine.cの後半部分を詳細に読む必要がある
- C-11: display.c を直接読み取っていない
- C-14: 対話モードのキーバインド詳細はtop.cの対話処理部分を確認必要
  - 候補：display.c / top.c の対話処理部分 / top(1) マニュアルページ

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - プロセス一覧のカラム構成はformat_next_process()の実装に依存
- 1: 中リスク - machine.cは大規模ファイルのため全体の確認が不完全
- 0: 低リスク - システムサマリー部分の構造は一般的なtopの仕様と一致

## 6) レビュアーチェックリスト（最小）
- [ ] machine.cのformat_next_process()が出力するカラム名と順序を確認
- [ ] display.cの画面描画ロジックを確認
- [ ] top.cの対話モードコマンド一覧を確認
- [ ] バッチモードの出力形式が対話モードと同一か確認
