---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-crashinfo - OSコアダンプ解析レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/crashinfo/crashinfo.sh` - メインスクリプト（全345行を確認済み）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.15）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シェルスクリプトで実装 | E-01（行1: #!/bin/sh） | ○ |
| C-02 | デフォルトクラッシュディレクトリは/var/crash | E-01（行91: CRASHDIR=/var/crash） | ○ |
| C-03 | GDBは/usr/local/bin/gdbを使用 | E-01（行159） | ○ |
| C-04 | vmcore.gz と vmcore.zst 圧縮形式をサポート | E-01（行167-172） | ○ |
| C-05 | umask 077で出力ファイル権限制限 | E-01（行196） | ○ |
| C-06 | find_kernel()でバージョン文字列マッチング | E-01（行59-88） | ○ |
| C-07 | kgdbで bt -full と acttrace を実行 | E-01（行220-222） | ○ |
| C-08 | ps -axlww を -M -N オプション付きで実行 | E-01（行232） | ○ |
| C-09 | vmstat -s/-m/-z/-i を個別に実行 | E-01（行237-256） | ○ |
| C-10 | netstat -s/-m/-anA/-aL を個別に実行 | E-01（行299-320） | ○ |
| C-11 | 出力ファイル名は core.txt.{DUMPNR} | E-01（行151: FILE=$CRASHDIR/core.txt.$DUMPNR） | ○ |
| C-12 | セパレータ行は72文字の"-" | E-01（行229等: "--------..."） | ○ |
| C-13 | boundsファイルから最新ダンプ番号取得 | E-01（行136-146） | ○ |
| C-14 | -b, -d, -n, -k オプションをサポート | E-01（行95: "bd:n:k:"） | ○ |
| C-15 | cleanup()でtrapハンドラ設定 | E-01（行41-45, 168, 171） | ○ |
| C-16 | info.{N}からパニック文字列をsedで抽出 | E-01（行215） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シェルスクリプトのため全コードを直接確認済み
- 0: 低リスク - 外部コマンドの呼び出しパラメータも全て確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GDB/KGDBのバージョン依存性がないか確認
- [ ] 圧縮vmcoreの展開処理で十分なディスク空間チェックがあるか確認
- [ ] cleanup()のtrapハンドラが全エラーケースをカバーしているか確認
