---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：16-praudit - 監査証跡レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **libbsmの内部動作**：トークン種別の完全なリストはlibbsm内部を確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/openbsm/bin/praudit/praudit.c` - メインソースコード（238行）
- E-02: `usr.sbin/praudit/Makefile` - ビルド設定
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.16）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BSM監査トレイルをパースして可読形式で出力 | E-01, E-03 | ○ |
| C-02 | -d, -l, -n, -p, -r, -s, -x オプション | E-01（行134: "d:lnprsx"） | ○ |
| C-03 | デフォルト区切り文字はカンマ | E-01（行65: del = ","） | ○ |
| C-04 | -rと-sは排他的 | E-01（行153-161） | ○ |
| C-05 | au_read_rec/au_fetch_tok/au_print_flags_tok使用 | E-01（行100, 104, 107） | ○ |
| C-06 | Capsicumサンドボックス対応 | E-01（行49-54, 174-225） | ○ |
| C-07 | 各ファイルをfork()で別プロセスにサンドボックス化 | E-01（行214-225） | ○ |
| C-08 | -pモードでヘッダートークンまでスキップ | E-01（行91-98: AUT_HEADER32検索） | ○ |
| C-09 | XMLモードでヘッダー/フッター出力 | E-01（行186-187, 233-234） | ○ |
| C-10 | OpenBSMプロジェクト由来 | E-02（Makefile: OPENBSMDIR=${SRCTOP}/contrib/openbsm） | ○ |
| C-11 | libbsm依存 | E-02（Makefile: LIBADD=bsm） | ○ |
| C-12 | ファイルオープン失敗時は次のファイルに進む | E-01（行201-204: perror + continue） | ○ |
| C-13 | Capsicum事前初期化でDB参照を準備 | E-01（行179-183） | ○ |
| C-14 | 監査トークン種別の完全なリスト | **根拠なし**（libbsm内部） | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: 監査トークンの種別と属性の完全なリストはlibbsmライブラリの実装に依存
  - 候補：contrib/openbsm/libbsm/ のソースコード / audit_token(3) マニュアルページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - praudit.cの全コードを確認済み
- 1: 中リスク - libbsmの内部実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] libbsmのtokenstr_t構造体と対応するトークン種別を確認
- [ ] au_print_flags_tokの出力フォーマットを確認
- [ ] Capsicumサンドボックス化がセキュリティ要件を満たすか確認
