---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：17-mailstats - メール統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **statistics構造体の完全なフィールドリスト**：mailstats.h直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/sendmail/mailstats/mailstats.c` - メインソースコード（373行）
- E-02: `usr.sbin/mailstats/Makefile` - ビルド設定
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.17）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sendmailの統計情報をレポート | E-01, E-03 | ○ |
| C-02 | -c, -C, -f, -o, -p, -P オプションをサポート | E-01（行71: MSOPTS "cC:f:opP"） | ○ |
| C-03 | 事前定義メーラーは prog, *file*, *include* | E-01（行133-135） | ○ |
| C-04 | sendmail.cfからM行でメーラー名を抽出 | E-01（行155-209） | ○ |
| C-05 | sendmail.cfからOSオプションで統計ファイルパスを取得 | E-01（行158-186） | ○ |
| C-06 | stat_magic/stat_versionで検証 | E-01（行251-268） | ○ |
| C-07 | ゼロのメーラーは非表示 | E-01（行296-298: stat_nf/nt/nq/nr/nd判定） | ○ |
| C-08 | -Pでプログラム可読形式（Kサフィックスなし） | E-01（行302-305: format分岐） | ○ |
| C-09 | -pで統計ファイルをtruncate | E-01（行344-349: O_TRUNC） | ○ |
| C-10 | MNAMELEN=20 | E-01（行43） | ○ |
| C-11 | 合計行は"T"接頭辞 | E-01（行331-337, 357-362） | ○ |
| C-12 | 接続行は"C"接頭辞 | E-01（行339-343, 364-367） | ○ |
| C-13 | MAXMAILERS定義のメーラー数上限 | E-01（行191-196） | ○ |
| C-14 | sm_io_*関数でI/O操作 | E-01（行111-112, 280等） | ○ |
| C-15 | statistics構造体の全フィールド | **根拠なし**（mailstats.h直接未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: sendmail/mailstats.hを直接読み取っていないため、statistics構造体の完全なフィールドリストは推測に基づく
  - 候補：contrib/sendmail/include/sendmail/mailstats.h を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - mailstats.cの全コードを確認済み
- 1: 中リスク - statistics構造体の定義は間接的確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] sendmail/mailstats.hのstatistics構造体が正確に記述されているか確認
- [ ] STAT_MAGIC/STAT_VERSIONの値を確認
- [ ] MAXMAILERSの値を確認
