---
generated_at: 2026-02-01 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-nfsstat - NFS統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **nfsstatsv1構造体の完全なフィールド定義**：カーネルヘッダ直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/nfsstat/nfsstat.c` - メインソースコード（全1259行を確認済み）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.18）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFSクライアント/サーバー統計をレポート | E-01, E-02 | ○ |
| C-02 | -c, -d, -E, -e, -s, -W, -m, -w, -z, -q オプション | E-01（行150: "cdEesWM:mN:w:zq"） | ○ |
| C-03 | nfssvc(NFSSVC_GETSTATS)で統計取得 | E-01（行256, 264） | ○ |
| C-04 | libxo対応でJSON/XML出力可能 | E-01（行87: #include <libxo/xo.h>, 行144: xo_parse_args） | ○ |
| C-05 | modfind("nfscommon")でモジュール確認 | E-01（行228-229） | ○ |
| C-06 | BioRキャッシュヒット = biocache_reads - read_bios | E-01（行357-358） | ○ |
| C-07 | exp_intprでNFSv4.1/4.2拡張統計出力 | E-01（行618-1093, 行696-785でnfsv41/nfsv42コンテナ） | ○ |
| C-08 | exp_sidewaysintprでインターバルモード | E-01（行1121-1258） | ○ |
| C-09 | compute_new_statsでMB/s, KB/t, tps計算 | E-01（行553-612） | ○ |
| C-10 | queue_len = srvstartcnt - srvdonecnt | E-01（行611） | ○ |
| C-11 | -zオプションでZEROCLTSTATS/ZEROSRVSTATS | E-01（行257-261） | ○ |
| C-12 | -mオプションでマウントオプション表示 | E-01（行155-175, NFSSVC_DUMPMNTOPTS） | ○ |
| C-13 | -eと-Eは排他的 | E-01（行204-206, 209-211） | ○ |
| C-14 | 13文字幅フォーマット（%13ju） | E-01（行276-320等: "%13.13s"/"/%13ju"） | ○ |
| C-15 | sperc1/sperc2でキャッシュヒット率計算 | E-01（行515-543） | ○ |
| C-16 | nfsstatsv1構造体の完全なフィールド定義 | **根拠なし**（カーネルヘッダ直接未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: nfsstatsv1構造体の定義はカーネルヘッダ（fs/nfs/nfsport.h等）に存在するが、直接確認していない
  - 候補：`sys/fs/nfs/nfsport.h` または `sys/fs/nfs/nfsstatsv1.h` を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - nfsstat.cの全1259行を確認済み
- 1: 中リスク - nfsstatsv1構造体のフィールドはソースコード内の参照から推測

## 6) レビュアーチェックリスト（最小）
- [ ] nfsstatsv1構造体の定義（sys/fs/nfs/nfsport.h）を直接確認
- [ ] NFSPROC_* / NFSV4OP_* 定数値を確認
- [ ] nfssvc()システムコールのフラグ定義を確認
- [ ] libxoの出力フォーマットが正確か確認
