---
generated_at: 2026-02-01 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-ctlstat - CAMターゲットレイヤー統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ctl_io_stats構造体の完全な定義**：カーネルヘッダ直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/ctlstat/ctlstat.c` - メインソースコード（全1012行を確認済み）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.19）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CAMターゲットレイヤーのI/O統計をレポート | E-01, E-02 | ○ |
| C-02 | 4つの出力モード: STANDARD, DUMP, JSON, PROMETHEUS | E-01（行93-98: ctlstat_mode_types） | ○ |
| C-03 | CTL_GET_LUN_STATS / CTL_GET_PORT_STATS ioctl使用 | E-01（行187-188） | ○ |
| C-04 | オプション "Cc:DPdhjl:n:p:tw:" | E-01（行81） | ○ |
| C-05 | CTL_STAT_NUM_ITEMS=256のデフォルトバッファ | E-01（行77） | ○ |
| C-06 | NEED_MORE_SPACE時に5/4倍でリトライ | E-01（行197-204） | ○ |
| C-07 | compute_stats()でMB/s, KB/t, tps, ms計算 | E-01（行245-319） | ○ |
| C-08 | sysctlbyname("kern.cp_time")でCPU統計取得 | E-01（行231） | ○ |
| C-09 | -l と -p は排他的 | E-01（行949-950） | ○ |
| C-10 | -P は -p, -c, -w, -t と排他的 | E-01（行952-962） | ○ |
| C-11 | PrometheusモードでHTTPヘッダー出力 | E-01（行980-983） | ○ |
| C-12 | PrometheusモードでLUN/PORT両方の統計出力 | E-01（行989-991） | ○ |
| C-13 | XMLパースでターゲット名を取得 | E-01（行576-588: XML_Parse, cctl_start_pelement, cctl_end_pelement） | ○ |
| C-14 | iotypes = {"NO IO", "READ", "WRITE"} | E-01（行329） | ○ |
| C-15 | デフォルトnumdevs=3 | E-01（行859） | ○ |
| C-16 | ヘッダー20行間隔 | E-01（行690） | ○ |
| C-17 | -tオプションでRead/Write/Total集計 | E-01（行696-767: cur_total_stats[0..2]） | ○ |
| C-18 | ctl_io_stats構造体の完全な定義 | **根拠なし**（ctl_ioctl.h直接未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: ctl_io_stats構造体の定義はsys/cam/ctl/ctl_ioctl.hに存在するが、直接確認していない
  - 候補：`sys/cam/ctl/ctl_ioctl.h` を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ctlstat.cの全1012行を確認済み
- 1: 中リスク - ctl_io_stats構造体のフィールドはソースコード内の参照から推測

## 6) レビュアーチェックリスト（最小）
- [ ] ctl_io_stats構造体の定義（sys/cam/ctl/ctl_ioctl.h）を直接確認
- [ ] CTL_STATS_NUM_TYPESの値（3）を確認
- [ ] CTL_DEFAULT_DEVのパスを確認
- [ ] Prometheusメトリクス名が規約に従っているか確認
