---
generated_at: 2026-02-01 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ministat - 統計比較レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/ministat/ministat.c` - メインソースコード（全692行を確認済み）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義（No.20）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数データセットの統計比較を行う | E-01, E-02 | ○ |
| C-02 | Student t検定で有意差判定 | E-01（行247-280: Relative()関数） | ○ |
| C-03 | NSTUDENT=100, NCONF=6の事前計算テーブル | E-01（行29-134） | ○ |
| C-04 | 信頼水準 80/90/95/98/99/99.5% | E-01（行31: studentpct[]） | ○ |
| C-05 | デフォルト信頼水準95% | E-01（行627-628: ci=2 → studentpct[2]=95） | ○ |
| C-06 | MAX_DS=8、最大7データセット | E-01（行136, 637-638） | ○ |
| C-07 | シンボル: ' ', 'x', '+', '*', '%', '#', '@', 'O' | E-01（行137） | ○ |
| C-08 | 最低3データポイント必要 | E-01（行517-521） | ○ |
| C-09 | qsortで昇順ソート | E-01（行522: qsort(s->points, s->n, sizeof *s->points, dbl_cmp)） | ○ |
| C-10 | Capsicumサンドボックス対応 | E-01（行651-661: caph_limit_stdio, caph_enter） | ○ |
| C-11 | オプション "AC:c:d:snqw:" | E-01（行580） | ○ |
| C-12 | 初期100000ポイント、不足時4倍拡張 | E-01（行154: lpoints=100000, 行168: lpoints*=4） | ○ |
| C-13 | Var()の遅延計算（NAN初期値） | E-01（行157: syy=NAN, 行215: isnan(ds->syy)） | ○ |
| C-14 | 不偏分散（n-1で割る） | E-01（行221: ds->syy / (ds->n - 1.0)） | ○ |
| C-15 | プールド分散によるt検定 | E-01（行259-261） | ○ |
| C-16 | ターミナル幅自動検出 | E-01（行569-577: TIOCGWINSZ, COLUMNS環境変数, デフォルト74） | ○ |
| C-17 | ASCII プロットでA=平均、M=中央値マーカー | E-01（行414: 'M', 行416: 'A'） | ○ |
| C-18 | 標準偏差バーを"|___...___|"で表示 | E-01（行407-411） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ministat.cの全692行を確認済み（自己完結型プログラム、外部ライブラリ依存なし）
- 0: 低リスク - t分布テーブルもソース内に埋め込まれているため、全データを直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] t分布テーブルの値が統計学的に正確か確認
- [ ] Relative()関数の相対誤差（re）計算式が統計学的に正しいか確認
- [ ] プロット描画のエッジケース（span=0等）が適切に処理されているか確認
