---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：21-fstat - オープンファイルレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **出力カラムの正確な列幅指定**：ソースコード内のフォーマット文字列の詳細確認が必要
  2. **procstat_getprocs/getfilesの呼び出し行番号**：main.cの行番号は概算値
  3. **パフォーマンス要件の数値**：実測値ではなく推定値
  4. **セキュリティ考慮事項の詳細**：Capsicum対応の詳細未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/fstat/main.c` - エントリーポイント、オプション解析
- E-02: `usr.bin/fstat/fstat.c` - ファイル情報表示処理
- E-03: `usr.bin/fstat/functions.h` - 関数プロトタイプ宣言
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fstatは全プロセスのオープンファイル一覧を出力する | E-01, E-04 | ○ |
| C-02 | libprocstatライブラリを使用する | E-01 | ○ |
| C-03 | main.cとfstat.cに分離された構造を持つ | E-01, E-02, E-03 | ○ |
| C-04 | getoptでオプション解析を行う | E-01 | ○ |
| C-05 | -u, -p, -f, -m, -n, -vオプションが存在する | E-01 | ○ |
| C-06 | sysctl経由でカーネル情報を取得する | E-01 | ○ |
| C-07 | passwd DBでUID→ユーザー名変換を行う | E-01 | ○ |
| C-08 | ファイルタイプごとに表示関数が分かれている | E-03 | ○ |
| C-09 | USER, CMD, PID, FDなどのカラムで出力される | E-02 | ○ |
| C-10 | PID昇順でソートされる | E-01 | ○ |
| C-11 | root以外は自プロセスのみ参照可能 | E-01 | ○ |
| C-12 | 出力フォーマットの列幅が8文字, 10文字等 | E-02 | ○ |
| C-13 | procstat_getprocs()の具体的行番号 | **根拠不足** | △ |
| C-14 | パフォーマンス：数秒以内で出力 | **根拠なし** | △ |
| C-15 | 同時出力数に制限なし | **根拠なし** | △ |
| C-16 | kinfo_file構造体が主要データ構造 | E-01 | ○ |
| C-17 | ファイルパス情報による機密漏洩リスク | **根拠なし** | △ |
| C-18 | FreeBSD固有のコマンド | E-01, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- main.cの具体的な行番号は概算値であり、実際のソースコードと照合が必要
  - 候補：main.cの実際のソースコード / fstat(1)マニュアルページ / libprocstat(3)マニュアルページ
- パフォーマンス要件は推定値であり、実測データなし
  - 候補：ベンチマークテスト結果 / システム要件定義書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 行番号の記載が概算値のため、コードリーディングガイドの精度に影響
- 0: 低リスク - パフォーマンス要件は参考値として十分
- 0: 低リスク - セキュリティ考慮事項は一般的な記載

## 6) レビュアーチェックリスト（最小）
- [ ] main.cの行番号がソースコードと一致しているか確認
- [ ] 出力カラムの列幅がソースコードのフォーマット文字列と一致しているか確認
- [ ] libprocstat APIの呼び出しシーケンスが正確か確認
- [ ] オプション一覧が最新のソースコードと一致しているか確認
