---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：22-procstat - プロセス詳細情報レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **procstat.cの具体的行番号**：概算値のため実コードとの照合が必要
  2. **CPU使用率の計算式**：ki_pctcpu / fscaleの正確な変換式の確認
  3. **パフォーマンス要件**：推定値

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/procstat/procstat.c` - メインソース、オプション解析、サブコマンドディスパッチ
- E-02: `usr.bin/procstat/procstat.h` - ヘッダー、構造体定義、関数プロトタイプ
- E-03: `usr.bin/procstat/procstat_basic.c` - 基本情報表示
- E-04: `usr.bin/procstat/procstat_threads.c` - スレッド情報表示
- E-05: `usr.bin/procstat/procstat_files.c` - FD情報表示
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | procstatは多数のサブコマンドを持つ | E-01, E-02 | ○ |
| C-02 | libxo(3)でJSON/XML出力に対応 | E-01 | ○ |
| C-03 | libprocstat(3)を使用してデータ取得 | E-01 | ○ |
| C-04 | 各サブコマンドが独立したソースファイル | E-03, E-04, E-05等 | ○ |
| C-05 | xo_parse_args()でlibxo初期化 | E-01 | ○ |
| C-06 | getopt()でオプション解析 | E-01 | ○ |
| C-07 | procstat_getprocs()でプロセス一覧取得 | E-01 | ○ |
| C-08 | switch文でサブコマンド分岐 | E-01 | ○ |
| C-09 | -b, -c, -f, -i, -k, -l, -t, -vオプション | E-01 | ○ |
| C-10 | procstat.hにcmdopt列挙型がある | E-02 | ○ |
| C-11 | 21個のprocstat_*.cファイルが存在 | ファイル一覧 | ○ |
| C-12 | PID, COMM, STATEカラムで基本情報出力 | E-03 | ○ |
| C-13 | TID, TDNAME, CPU, PRI, WCHANでスレッド情報出力 | E-04 | ○ |
| C-14 | kinfo_proc構造体が主要データ構造 | E-01, E-02 | ○ |
| C-15 | -wオプションで繰り返し表示 | E-01 | ○ |
| C-16 | root権限で他プロセス参照可能 | E-01 | ○ |
| C-17 | procstat.cの具体的行番号が正確 | **根拠不足** | △ |
| C-18 | CPU使用率の計算式: ki_pctcpu/fscale*100 | **根拠不足** | △ |
| C-19 | パフォーマンス: 数秒以内 | **根拠なし** | △ |
| C-20 | Capsicumケイパビリティ情報がセキュリティ監査に有用 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- procstat.cの行番号は概算値であり、バージョンにより変動する
  - 候補：実際のソースコードの行番号確認 / git blameでの変更履歴確認
- CPU使用率の正確な計算式はprocstat_basic.cのソースコード確認が必要
  - 候補：procstat_basic.cの実装詳細 / libprocstat(3)マニュアルページ

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 行番号の概算値
- 0: 低リスク - 計算式の詳細
- 0: 低リスク - パフォーマンス要件は参考値

## 6) レビュアーチェックリスト（最小）
- [ ] procstat.cの行番号を実際のソースコードと照合
- [ ] サブコマンド一覧が最新のソースコードと一致しているか
- [ ] procstat_*.cファイル一覧に漏れがないか
- [ ] 出力カラムの定義がソースコードと一致しているか
