---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：23-sockstat - オープンソケットレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：推定値のため要実測
  2. **sockstat.hの内容**：ポートフィルタ関連の詳細未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/sockstat/sockstat.c` - メインソース（2060行、全ロジック含む）
- E-02: `usr.bin/sockstat/sockstat.h` - ヘッダーファイル
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sockstatはオープンソケット一覧を出力 | E-01, E-03 | ○ |
| C-02 | Capsicumサンドボックス内で動作 | E-01（行2004-2030） | ○ |
| C-03 | Casperサービス4つを使用 | E-01（行2009-2020） | ○ |
| C-04 | libxo対応でJSON/XML出力可能 | E-01（行1887-1894） | ○ |
| C-05 | SOCKSTAT_XO_VERSIONは"1" | E-01（行79） | ○ |
| C-06 | RBツリーでソケット管理 | E-01（行163-195） | ○ |
| C-07 | struct sockの定義が行139-161 | E-01 | ○ |
| C-08 | struct addrの定義が行125-137 | E-01 | ○ |
| C-09 | struct fileの定義が行181-187 | E-01 | ○ |
| C-10 | gather_inet()でTCP/UDP収集 | E-01（行620-785） | ○ |
| C-11 | gather_sctp()でSCTP収集 | E-01（行351-618） | ○ |
| C-12 | gather_unix()でUNIXソケット収集 | E-01（行787-877） | ○ |
| C-13 | getfiles()でファイルテーブル取得 | E-01（行879-923） | ○ |
| C-14 | display()で表示処理 | E-01（行1623-1777） | ○ |
| C-15 | main()が行1877-2060 | E-01 | ○ |
| C-16 | -4, -6, -u, -l, -c等のオプション | E-01（行1896-1981） | ○ |
| C-17 | cap_net_limit(CAPNET_ADDR2NAME) | E-01（行2022-2026） | ○ |
| C-18 | デフォルトプロトコル: sctp,tcp,udp,udplite,divert | E-01（行112-113） | ○ |
| C-19 | col_widths構造体でカラム幅管理 | E-01（行1213-1231） | ○ |
| C-20 | formataddr()でアドレス整形 | E-01（行925-976） | ○ |
| C-21 | パフォーマンス: 数秒以内 | **根拠なし** | △ |
| C-22 | sockstat.hにポートフィルタ宣言 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推定値
  - 候補：ベンチマークテスト / 大規模環境での実測
- sockstat.hの詳細な内容（ポートフィルタ関数の定義）
  - 候補：sockstat.hファイルの内容確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パフォーマンス要件は参考値
- 0: 低リスク - sockstat.hの詳細は補足情報

## 6) レビュアーチェックリスト（最小）
- [ ] 行番号が現在のソースコードバージョンと一致しているか確認
- [ ] オプション一覧に漏れがないか確認
- [ ] Capsicum/Casper関連の記述が正確か確認
- [ ] sysctl変数名が正確か確認
