---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：24-lsvfs - 仮想ファイルシステム一覧レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **行番号の精度**：lsvfs.cの行番号は概算値
  2. **フラグ値の完全な一覧**：VFCF_*フラグの全一覧未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/lsvfs/lsvfs.c` - メインソース
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lsvfsはVFS一覧を出力する | E-01, E-02 | ○ |
| C-02 | 単一ファイルで実装 | E-01 | ○ |
| C-03 | getvfsbyname()で特定VFS取得 | E-01 | ○ |
| C-04 | sysctlbyname("vfs.conflist")で全VFS取得 | E-01 | ○ |
| C-05 | Filesystem, Refs, Flagsカラムで出力 | E-01 | ○ |
| C-06 | xvfsconf構造体を使用 | E-01 | ○ |
| C-07 | フラグにVFCF_STATIC等がある | E-01 | ○ |
| C-08 | 件数サマリーを末尾に出力 | E-01 | ○ |
| C-09 | 一般ユーザーで参照可能 | E-01 | ○ |
| C-10 | 出力フォーマット: %-20s %5d | E-01 | ○ |
| C-11 | 行番号が概算値で正確でない可能性 | **根拠不足** | △ |
| C-12 | VFCF_*フラグの完全一覧 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- lsvfs.cの正確な行番号の確認
  - 候補：ソースコードの再確認
- sys/mount.hのVFCF_*定義の完全一覧
  - 候補：sys/mount.hヘッダーファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなコマンドのため全体的にリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] lsvfs.cの行番号が実際のソースコードと一致しているか
- [ ] VFSフラグの一覧が最新のsys/mount.hと一致しているか
