---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：25-du - ディスク使用量統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **du.cの行番号**：概算値のため実コード照合が必要
  2. **Capsicum対応の詳細**：cap_enter()の具体的使用箇所
  3. **パフォーマンス要件**：推定値

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/du/du.c` - メインソース
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | duはディスク使用量を再帰的に集計する | E-01, E-02 | ○ |
| C-02 | fts(3)ライブラリを使用 | E-01 | ○ |
| C-03 | ハードリンク重複カウント回避 | E-01（linkchk関数） | ○ |
| C-04 | -a, -s, -d, -h, -k, -m, -c等のオプション | E-01 | ○ |
| C-05 | st_blocksでブロック数取得 | E-01 | ○ |
| C-06 | humanize_number()で人間可読形式出力 | E-01 | ○ |
| C-07 | FTS_D, FTS_DP, FTS_Fで分岐処理 | E-01 | ○ |
| C-08 | -cオプションで合計行出力 | E-01 | ○ |
| C-09 | getbsize()でブロックサイズ決定 | E-01 | ○ |
| C-10 | POSIX標準コマンド | E-01 | ○ |
| C-11 | -tオプションで閾値フィルタ | E-01 | ○ |
| C-12 | -Iオプションで除外パターン | E-01 | ○ |
| C-13 | cap_enter()でCapsicumサンドボックス | E-01 | ○ |
| C-14 | du.cの具体的行番号 | **根拠不足** | △ |
| C-15 | パフォーマンス: ファイル数に比例 | **根拠なし** | △ |
| C-16 | -Aオプションでst_size使用 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- du.cの正確な行番号
  - 候補：ソースコードの再確認
- -Aオプションの正確な実装詳細
  - 候補：du.cの-Aオプション処理箇所の確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 行番号の概算値
- 0: 低リスク - パフォーマンスは一般的な記載

## 6) レビュアーチェックリスト（最小）
- [ ] du.cの行番号を実際のソースコードと照合
- [ ] オプション一覧が最新のソースコードと一致しているか
- [ ] Capsicum対応の詳細が正確か確認
