---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：26-ipcs - System V IPC施設ステータスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **ipcs.cの行番号**：概算値のため実コード照合が必要
  2. **sysctl変数名の正確性**：kern.ipc.shmsegs等の正確な名前
  3. **出力フォーマットの列幅**：ソースコードのprintf書式確認

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/ipcs/ipcs.c` - メインソース
- E-02: `usr.bin/ipcs/ipc.c` - 権限表示ヘルパー
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ipcsはSystem V IPC施設のステータスを表示 | E-01, E-03 | ○ |
| C-02 | 共有メモリ、メッセージキュー、セマフォの3種類 | E-01 | ○ |
| C-03 | sysctl経由でカーネル情報取得 | E-01 | ○ |
| C-04 | -M, -Q, -Sオプションで種別選択 | E-01 | ○ |
| C-05 | -a, -b, -c, -o, -p, -tオプション | E-01 | ○ |
| C-06 | ipc.cにcvt_id()関数がある | E-02 | ○ |
| C-07 | POSIX標準コマンド | E-01 | ○ |
| C-08 | passwd/group DBでUID/GID変換 | E-01 | ○ |
| C-09 | セクション別（共有メモリ→メッセージキュー→セマフォ）に表示 | E-01 | ○ |
| C-10 | T, ID, KEY, MODE, OWNER, GROUPカラム | E-01 | ○ |
| C-11 | 一般ユーザーで全IPC施設参照可能 | E-01 | ○ |
| C-12 | ipcs.cの具体的行番号 | **根拠不足** | △ |
| C-13 | sysctl変数名の正確な記載 | **根拠不足** | △ |
| C-14 | 出力フォーマットの列幅 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ipcs.cの正確な行番号
  - 候補：ソースコードの再確認
- sysctl変数名（kern.ipc.shmsegs等）の正確な確認
  - 候補：ipcs.cのsysctlbyname呼び出し箇所 / sysctl(8)マニュアルページ

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - sysctl変数名の正確性
- 0: 低リスク - 行番号は概算値

## 6) レビュアーチェックリスト（最小）
- [ ] sysctl変数名がソースコードと一致しているか
- [ ] 出力フォーマットの列幅がソースコードと一致しているか
- [ ] オプション一覧に漏れがないか
