---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-ifmcstat - マルチキャスト統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：推定値

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/ifmcstat/ifmcstat.c` - メインソース（1246行）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ifmcstatはマルチキャストグループ情報を表示 | E-01, E-02 | ○ |
| C-02 | getifmaddrs(3)でマルチキャスト情報取得 | E-01（行1007） | ○ |
| C-03 | getifaddrs()でIF情報取得 | E-01（行1002） | ○ |
| C-04 | sockunion_t共用体が行97-108 | E-01 | ○ |
| C-05 | main()が行190-276 | E-01 | ○ |
| C-06 | ifmcstat_getifmaddrs()が行981-1245 | E-01 | ○ |
| C-07 | in_ifinfo()が行281-306 | E-01 | ○ |
| C-08 | in6_ifinfo()が行738-763 | E-01 | ○ |
| C-09 | inm_print_sources_sysctl()が行791-873 | E-01 | ○ |
| C-10 | in6m_print_sources_sysctl()が行888-978 | E-01 | ○ |
| C-11 | -i, -f, -vオプション | E-01（行199-256） | ○ |
| C-12 | KVMモードが破損 | E-01（行80-85コメント） | ○ |
| C-13 | KAME由来のコード | E-01（行1コメント） | ○ |
| C-14 | IGMP v1/v2/v3対応 | E-01（行286-293） | ○ |
| C-15 | MLD v1/v2対応 | E-01（行743-751） | ○ |
| C-16 | sysctl("net.inet.igmp.ifinfo")使用 | E-01（行1148） | ○ |
| C-17 | sysctl("net.inet.ip.mcast.filters")使用 | E-01（行808） | ○ |
| C-18 | パフォーマンス: 即時 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスは推定値
  - 候補：大規模マルチキャスト環境での実測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接行番号を確認済みのため精度が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 行番号がソースコードバージョンと一致しているか
- [ ] sysctl変数名が正確か
- [ ] IGMP/MLDフラグの一覧に漏れがないか
