---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：28-wlanstat - 802.11無線ネットワーク統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **wlanstat.hの構造体詳細**：関数ポインタの完全な一覧
  2. **ieee80211_statsのフィールド一覧**：統計カウンタの完全な一覧

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/wlanstat/main.c` - エントリーポイント（297行）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wlanstatは802.11統計を表示 | E-01, E-02 | ○ |
| C-02 | main()が行164-297 | E-01 | ○ |
| C-03 | tags配列が行50-66 | E-01 | ○ |
| C-04 | default, ampdu, amsduの3プリセット | E-01（行53-66） | ○ |
| C-05 | WLAN環境変数でデフォルトIF取得 | E-01（行176-178） | ○ |
| C-06 | wlanstat_new()で初期化 | E-01（行179） | ○ |
| C-07 | -h, -i, -l, -m, -oオプション | E-01（行183-213） | ○ |
| C-08 | SIGALRMでタイマー制御 | E-01（行227-228） | ○ |
| C-09 | line==21でヘッダー再表示 | E-01（行253） | ○ |
| C-10 | collect_tot/cur, print_total/current関数ポインタ | E-01（行235-240） | ○ |
| C-11 | interval未指定時はprint_verbose | E-01（行294） | ○ |
| C-12 | getopmode()でSTAモード判定 | E-01（行218） | ○ |
| C-13 | sigblock/sigpause使用 | E-01（行243-245） | ○ |
| C-14 | catchalarm関数でsignalledフラグ設定 | E-01（行78-84） | ○ |
| C-15 | wlanstat.hの構造体詳細 | **根拠不足** | △ |
| C-16 | ieee80211_statsのフィールド完全一覧 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- wlanstat.hの内容詳細（wlanstatfoo構造体の完全な関数ポインタ一覧）
  - 候補：wlanstat.hファイルの読み込み
- ieee80211_stats構造体のフィールド一覧
  - 候補：net80211/ieee80211_var.hヘッダーファイル

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - wlanstat.hの構造体定義が未確認のため、インターフェース仕様に不足がある可能性
- 0: 低リスク - main.cの行番号は直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] wlanstat.hの構造体定義を確認
- [ ] 統計カウンタの一覧が最新のドライバと一致しているか
- [ ] 出力フォーマットプリセットの内容が正確か
