---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：30-last - ユーザーログイン履歴レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：推定値
  2. **出力フォーマット列幅**：デフォルト値の正確性

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/last/last.c` - 全ソースコード（591行の単一ファイル）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lastはutx.logからログイン履歴を表示 | E-01, E-02 | ○ |
| C-02 | ARG構造体が行59-67 | E-01 | ○ |
| C-03 | struct idtabが行72-76 | E-01 | ○ |
| C-04 | crmsg/currentout/maxrec等のグローバル変数（行78-90） | E-01 | ○ |
| C-05 | main()が行111-212 | E-01 | ○ |
| C-06 | xo_parse_args()でlibxo初期化（行120） | E-01 | ○ |
| C-07 | getopt()で-d, -f, -h, -n, -s, -t, -w, -yオプション解析（行126-178） | E-01 | ○ |
| C-08 | Capsicum初期化: caph_limit_stdio, caph_cache_*（行180-183） | E-01 | ○ |
| C-09 | setutxdb(UTXDB_LOG, file)でutx.logオープン（行187-188） | E-01 | ○ |
| C-10 | caph_enter()でサンドボックス突入（行190-191） | E-01 | ○ |
| C-11 | wtmp()関数が行218-258 | E-01 | ○ |
| C-12 | getutxent()で全エントリ読み込み後、逆順でdoentry()呼び出し | E-01 | ○ |
| C-13 | doentry()が行264-332 | E-01 | ○ |
| C-14 | BOOT_TIME/SHUTDOWN_TIMEで全セッション終了処理 | E-01（行264-332） | ○ |
| C-15 | USER_PROCESSでログインエントリ表示 | E-01（行264-332） | ○ |
| C-16 | DEAD_PROCESSでログアウト時刻記録 | E-01（行264-332） | ○ |
| C-17 | printentry()が行341-411 | E-01 | ○ |
| C-18 | want()フィルタ関数が行417-448 | E-01 | ○ |
| C-19 | idtab.logoutの符号: 正値→正常、負値→crash/shutdown | E-01 | ○ |
| C-20 | セッション長: logout_time - login_time | E-01 | ○ |
| C-21 | libxo(3)対応でJSON/XML出力可能 | E-01（xo_emit, xo_parse_args） | ○ |
| C-22 | "reboot"引数でリブートイベントのみ表示 | E-01（行195-207） | ○ |
| C-23 | パフォーマンス: 数秒以内 | **根拠なし** | △ |
| C-24 | 出力フォーマット列幅（%-10s, %-8s, %-22.22s） | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推定値
  - 候補：大規模utx.logでの実測
- 出力フォーマットの列幅はprintentry()関数のxo_emit書式を詳細確認が必要
  - 候補：printentry()内のxo_emit()フォーマット文字列の精査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 591行の単一ファイルで全ロジックが完結しており、行番号を直接確認済み
- 1: 低リスク - Capsicumサンドボックスの記述はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 行番号がソースコードバージョンと一致しているか
- [ ] printentry()のxo_emit()フォーマット文字列が帳票レイアウトの列幅と一致しているか
- [ ] utmpxイベント種別の処理が網羅されているか（LOGIN_PROCESS等の扱い）
- [ ] スナップショットモード（-d）の動作説明が正確か
