---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-rpcinfo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ考慮事項の詳細**：根拠不足
  2. **パフォーマンス要件の数値**：根拠不足

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/rpcinfo/rpcinfo.c` 行1-1666（メインソースコード）
- E-02: `usr.bin/rpcinfo/rpcinfo.c` 行100-116（データ構造定義）
- E-03: `usr.bin/rpcinfo/rpcinfo.c` 行151-301（main関数）
- E-04: `usr.bin/rpcinfo/rpcinfo.c` 行668-866（rpcbdump関数）
- E-05: `usr.bin/rpcinfo/rpcinfo.c` 行458-545（pmapdump関数）
- E-06: `usr.bin/rpcinfo/rpcinfo.c` 行972-1194（rpcbgetstat関数）
- E-07: `usr.bin/rpcinfo/rpcinfo.c` 行1455-1473（usage関数）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行32

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rpcinfoはRPCサーバーの情報をレポートする | E-01, E-08 | ○ |
| C-02 | RPCBDUMP形式の出力カラム構成（program/version/netid/address/service/owner） | E-04 (行792-804) | ○ |
| C-03 | PMAPDUMP形式の出力カラム構成（program/vers/proto/port/service） | E-05 (行524-544) | ○ |
| C-04 | main関数でgetoptによるオプション解析を実施 | E-03 (行167-249) | ○ |
| C-05 | 動作モードはNONE/PMAPDUMP/TCPPING/UDPPING/BROADCAST/DELETES/ADDRPING/PROGPING/RPCBDUMP/RPCBDUMP_SHORT/RPCBADDRLIST/RPCBGETSTAT | E-01 (行87-98) | ○ |
| C-06 | データなし時に"No remote programs registered."を出力 | E-04 (行789-790), E-05 (行521-522) | ○ |
| C-07 | rpcbdump関数でRPCBPROC_DUMPを呼び出す | E-04 (行712-714) | ○ |
| C-08 | pmapdump関数でPMAPPROC_DUMPを呼び出す | E-05 (行499-501) | ○ |
| C-09 | getrpcbynumber()でサービス名を解決する | E-04 (行799-803), E-05 (行538-541) | ○ |
| C-10 | rpcbgetstat関数でPORTMAP/RPCBIND v3/v4の統計を出力 | E-06 (行1021-1193) | ○ |
| C-11 | netidlist/verslist/rpcbdump_short構造体を使用 | E-02 (行100-116) | ○ |
| C-12 | 接続失敗時に"can't contact rpcbind"エラーメッセージ | E-04 (行705-707) | ○ |
| C-13 | portmapper未対応時のエラー処理 | E-05 (行502-517) | ○ |
| C-14 | usageで利用可能オプションを表示 | E-07 (行1455-1473) | ○ |
| C-15 | PORTMAP定義が有効な場合-p/-t/-uオプション利用可能 | E-03 (行167-170) | ○ |
| C-16 | ブロードキャスト機能でrpc_broadcast()を使用 | E-01 (行622-624) | ○ |
| C-17 | セキュリティ考慮事項（権限管理の詳細） | **根拠なし** | △ |
| C-18 | パフォーマンス要件（数秒以内の応答） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項：ソースコードにはアクセス制御に関する明示的な実装はなく、rpcbind側の設定に依存する。設計書の記述は推測に基づく。
  - 候補：rpcbindのセキュリティ設定 / FreeBSDセキュリティドキュメント / man rpcinfo
- パフォーマンス要件：ソースコードにはタイムアウト設定（10秒/60秒）は確認できるが、「数秒以内」という要件の根拠が不明。
  - 候補：ベンチマーク結果 / 運用要件定義 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 帳票レイアウトの正確性（ソースコードのprintf文から直接確認可能）
- 0: 処理フローの正確性（main関数のswitch文から直接確認可能）
- 1: セキュリティ考慮事項の妥当性（運用環境依存）

## 6) レビュアーチェックリスト（最小）
- [ ] RPCBDUMP形式の出力カラム幅がソースコードと一致しているか
- [ ] PMAPDUMP形式の出力フォーマットが正確か
- [ ] 各動作モードの説明が網羅されているか
- [ ] エラーメッセージがソースコードと一致しているか
