---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-stat

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：根拠不足

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/stat/stat.c` 行1-1186（メインソースコード）
- E-02: `usr.bin/stat/stat.c` 行97-118（フォーマット定義）
- E-03: `usr.bin/stat/stat.c` 行209-414（main関数）
- E-04: `usr.bin/stat/stat.c` 行445-632（output関数）
- E-05: `usr.bin/stat/stat.c` 行637-1110（format1関数）
- E-06: `usr.bin/stat/stat.c` 行1121-1185（hole検出関数）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行33

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | statはファイルステータス情報をレポートする | E-01, E-07 | ○ |
| C-02 | DEF_FORMATの出力項目構成 | E-02 (行97-99) | ○ |
| C-03 | LINUX_FORMATの出力項目構成 | E-02 (行109-117) | ○ |
| C-04 | readlinkモードでの動作 | E-03 (行233-239) | ○ |
| C-05 | 5種類の出力フォーマット（DEF/LS/RAW/SHELL/LINUX） | E-02, E-03 (行328-349) | ○ |
| C-06 | format1でSHOW_st_dev〜SHOW_sizerdevを処理 | E-05 (行662-971) | ○ |
| C-07 | stat/lstat/fstat/fhstatの使い分け | E-03 (行354-398) | ○ |
| C-08 | hole検出でSEEK_HOLE/SEEK_DATAを使用 | E-06 (行1139-1167) | ○ |
| C-09 | フォーマット文字列パースの仕組み | E-04 (行454-627) | ○ |
| C-10 | user_from_uid/group_from_gidで名前解決 | E-05 (行740, 753) | ○ |
| C-11 | fflagstostr()でフラグ文字列化 | E-01 (行420-432) | ○ |
| C-12 | FLOAT形式でナノ秒精度の時刻出力 | E-05 (行1000-1067) | ○ |
| C-13 | NFS handle（-Hオプション）対応 | E-03 (行251-253, 366-384) | ○ |
| C-14 | フォーマット不正時のerrx("bad format") | E-04 (行625-626) | ○ |
| C-15 | オプション競合のエラーチェック | E-03 (行281-283) | ○ |
| C-16 | パフォーマンス要件（ミリ秒単位） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：statシステムコールの応答時間はファイルシステムに依存する。「ミリ秒単位」は一般的な想定であり明確な根拠はない。
  - 候補：ファイルシステムベンチマーク / カーネルドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: フォーマット文字列の対応関係（ソースコードの定数定義から直接確認可能）
- 0: format1関数の各SHOW_*の処理（switch文から直接確認可能）
- 0: hole検出処理（SEEK_HOLE/SEEK_DATAの利用が明確）

## 6) レビュアーチェックリスト（最小）
- [ ] DEF_FORMAT定義がソースコードと一致しているか
- [ ] LINUX_FORMAT定義がソースコードと一致しているか
- [ ] format1の各SHOW_*の出力形式が正確か
- [ ] hole検出処理の説明が正確か
