---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-w

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/w/w.c` 行1-600（メインソースコード）
- E-02: `usr.bin/w/w.c` 行97-107（struct entry定義）
- E-03: `usr.bin/w/w.c` 行123-471（main関数）
- E-04: `usr.bin/w/w.c` 行473-576（pr_header関数）
- E-05: `usr.bin/w/pr_time.c` 行48-138（時刻・アイドル表示）
- E-06: `usr.bin/w/proc_compare.c` 行64-114（プロセス比較）
- E-07: `usr.bin/w/w.c` 行79-92（グローバル変数定義）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行34

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wはログイン中のユーザーと実行中プロセスをレポート | E-01 (行32-37), E-08 | ○ |
| C-02 | uptimeとしても動作する | E-03 (行149-155) | ○ |
| C-03 | libxo経由でJSON/XML出力対応 | E-01 (行75), E-03 (行139, 324-325) | ○ |
| C-04 | struct entryのフィールド構成 | E-02 (行97-107) | ○ |
| C-05 | USER列幅W_DISPUSERSIZE=10 | E-01 (行113) | ○ |
| C-06 | TTY列幅W_DISPLINESIZE=8 | E-01 (行114) | ○ |
| C-07 | FROM列最大幅W_MAXHOSTSIZE=40 | E-01 (行115) | ○ |
| C-08 | pr_headerで時刻・uptime・ユーザー数・ロードアベレージ出力 | E-04 (行486-575) | ○ |
| C-09 | clock_gettime(CLOCK_UPTIME)で稼働時間取得 | E-04 (行500) | ○ |
| C-10 | getloadavg()でロードアベレージ取得 | E-04 (行560) | ○ |
| C-11 | utmpxからUSER_PROCESSエントリーを収集 | E-03 (行203-212) | ○ |
| C-12 | ttystat()でttyデバイスのstat取得 | E-01 (行578-588) | ○ |
| C-13 | kvm_getprocs(KERN_PROC_ALL)で全プロセス取得 | E-03 (行344) | ○ |
| C-14 | proc_compare()で最も興味深いプロセスを選択 | E-06 (行64-114), E-03 (行355-359) | ○ |
| C-15 | -iオプションでアイドル時間ソート（挿入ソート） | E-03 (行397-412) | ○ |
| C-16 | pr_attime()でログイン時刻表示（1週間超/当日以外/当日で形式変更） | E-05 (行48-98) | ○ |
| C-17 | pr_idle()でアイドル時間表示（36時間超→日数/1時間超→HH:MM/0→"-"/その他→分） | E-05 (行105-138) | ○ |
| C-18 | tty名から"tty"/"cua"プレフィクス除去 | E-03 (行445-447) | ○ |
| C-19 | realhostname_sa()でDNS逆引き | E-03 (行274-278) | ○ |
| C-20 | アイドル時間 = now - max(tty_atime, login_time)、負の場合0に補正 | E-03 (行246-252) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: ヘッダー出力内容（pr_header関数から直接確認可能）
- 0: 明細出力フォーマット（xo_emit呼び出しから直接確認可能）
- 0: プロセス比較アルゴリズム（proc_compare.cから直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダー行のフォーマットがソースコードと一致しているか
- [ ] 明細行のカラム幅定義が正確か
- [ ] proc_compareアルゴリズムの説明が正確か
- [ ] アイドル時間の計算ロジックが正確か
