---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-ruptime

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.bin/ruptime/ruptime.c` 行1-311（メインソースコード）
- E-02: `usr.bin/ruptime/ruptime.c` 行46-52（データ構造・マクロ定義）
- E-03: `usr.bin/ruptime/ruptime.c` 行68-109（main関数）
- E-04: `usr.bin/ruptime/ruptime.c` 行177-275（ruptime関数）
- E-05: `usr.bin/ruptime/ruptime.c` 行111-134（interval関数）
- E-06: `usr.bin/ruptime/ruptime.c` 行154-175（ソート比較関数群）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行35

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ruptimeはリモートホスト稼働状況を一覧表示する | E-01, E-07 | ○ |
| C-02 | /var/rwho/whod.*ファイルを読み取る | E-04 (行196-215) | ○ |
| C-03 | ISDOWN判定は11分(11*60秒)が閾値 | E-02 (行51) | ○ |
| C-04 | LEFTEARTH判定は4日(4*24*60*60秒)が閾値 | E-02 (行50) | ○ |
| C-05 | upホスト: hostname/status/uptime/nusers/load出力 | E-04 (行262-271) | ○ |
| C-06 | downホスト: hostname/status/downtime出力 | E-04 (行256-260) | ○ |
| C-07 | ロードアベレージはwd_loadav[i]/100.0で計算 | E-04 (行270) | ○ |
| C-08 | -aフラグでアイドル1時間以上のユーザーもカウント | E-04 (行233) | ○ |
| C-09 | 4種のソート比較関数（hscmp/lcmp/tcmp/ucmp） | E-06, E-01 (行277-303) | ○ |
| C-10 | -rフラグでソート逆順 | E-01 (行56, 行84-86) | ○ |
| C-11 | interval()で時間をD+HH:MM形式に変換 | E-05 (行111-134) | ○ |
| C-12 | hs配列は40エントリーずつ動的拡張 | E-04 (行204-208) | ○ |
| C-13 | 表示幅79カラムに収まるよう調整 | E-04 (行251-252) | ○ |
| C-14 | qsort()でソート実行 | E-04 (行249) | ○ |
| C-15 | nusersカウントでwe_idle < 3600を条件判定 | E-04 (行233) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 出力フォーマット（printf文から直接確認可能）
- 0: ISDOWN/LEFTEARTH閾値（マクロ定義から直接確認可能）
- 0: ソート比較関数の動作（関数実装から直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] upホストの出力フォーマットがソースコードのprintf文と一致しているか
- [ ] downホストの出力フォーマットが正確か
- [ ] ISDOWN/LEFTEARTH閾値の記載が正確か
- [ ] ソート比較関数の説明が正確か
