---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-usbdump

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/usbdump/usbdump.c` 行1-996（メインソースコード）
- E-02: `usr.sbin/usbdump/usbdump.c` 行71-107（データ構造定義）
- E-03: `usr.sbin/usbdump/usbdump.c` 行795-995（main関数）
- E-04: `usr.sbin/usbdump/usbdump.c` 行459-572（print_apacket関数）
- E-05: `usr.sbin/usbdump/usbdump.c` 行690-716（do_loop関数）
- E-06: `usr.sbin/usbdump/usbdump.c` 行185-261（make_filter関数）
- E-07: `usr.sbin/usbdump/usbdump.c` 行118-165（テーブル定義）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行36

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | usbdumpはUSBトラフィックをキャプチャしてレポートする | E-01, E-08 | ○ |
| C-02 | BPFデバイス経由でUSBパケット取得 | E-03 (行925) | ○ |
| C-03 | パケット行のフォーマット（timestamp/bus.addr/dir/type/EP/SPD/NFR/SLEN/IVAL/ERR） | E-04 (行503-517) | ○ |
| C-04 | 転送タイプテーブル（CTRL/ISOC/BULK/INTR） | E-07 (行152-157) | ○ |
| C-05 | 速度テーブル（FULL/HIGH/LOW/VARI/SUPER） | E-07 (行159-165) | ○ |
| C-06 | エラー文字列テーブル（USB_ERR_*） | E-07 (行118-148) | ○ |
| C-07 | リトルエンディアン→ホストエンディアン変換 | E-04 (行483-492) | ○ |
| C-08 | verbose >= 1でフレーム詳細+hexdump出力 | E-04 (行520-567) | ○ |
| C-09 | verbose >= 2でflags出力 | E-04 (行568-569) | ○ |
| C-10 | verbose >= 3でstatus出力 | E-04 (行570-571) | ○ |
| C-11 | 終了時の統計出力（captured/received/dropped） | E-03 (行980-983) | ○ |
| C-12 | snapshotデフォルト192バイト | E-03 (行804) | ○ |
| C-13 | -w/-b時にverboseが1段階下がる | E-03 (行917-918) | ○ |
| C-14 | make_filterでBPFフィルタ動的生成 | E-06 (行185-261) | ○ |
| C-15 | キャプチャファイルのマジック値USBCAP_FILEHDR_MAGIC | E-02 (行92) | ○ |
| C-16 | do_loopでread/fix_packets/write_packets/print_packetsを実行 | E-05 (行690-716) | ○ |
| C-17 | SIGINT時にdoexit=1でループ終了 | E-01 (行291-297) | ○ |
| C-18 | hexdump関数で16バイトごとに16進+ASCII表示 | E-01 (行401-457) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: パケット出力フォーマット（printf文から直接確認可能）
- 0: BPFフィルタ生成ロジック（make_filter関数から直接確認可能）
- 0: エンディアン変換処理（le32toh呼び出しから確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] パケット行のフォーマット文字列がソースコードと一致しているか
- [ ] verboseレベルごとの出力内容が正確か
- [ ] データ長（SLEN）の計算式が正確か
- [ ] 統計出力の項目が正確か
