---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-efitable

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/efitable/efitable.c` 行1-295（メインソースコード）
- E-02: `usr.sbin/efitable/efitable.c` 行50-63（efi_table_ops配列）
- E-03: `usr.sbin/efitable/efitable.c` 行65-169（main関数）
- E-04: `usr.sbin/efitable/efitable.c` 行171-224（ESRT出力）
- E-05: `usr.sbin/efitable/efitable.c` 行226-243（Properties出力）
- E-06: `usr.sbin/efitable/efitable.c` 行245-288（Memory Attributes出力）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行37

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | efitableはEFIテーブル情報をレポートする | E-01, E-07 | ○ |
| C-02 | 3種類のテーブル対応（esrt/prop/memory） | E-02 (行56-63) | ○ |
| C-03 | /dev/efiをO_RDWRでオープン | E-03 (行151) | ○ |
| C-04 | 2段階ioctl（サイズ取得→データ取得） | E-03 (行155-163) | ○ |
| C-05 | efi_table_ops配列による関数ポインタディスパッチ | E-02, E-03 (行165) | ○ |
| C-06 | ESRT: fw_resource_count/max/version + エントリー7項目 | E-04 (行181-216) | ○ |
| C-07 | Properties: version/length/memory_protection_attribute | E-05 (行235-239) | ○ |
| C-08 | Memory: version/descriptor_size/num_ents + 記述子6項目 | E-06 (行259-280) | ○ |
| C-09 | ESRT出力でuuid_to_string()によるGUID文字列化 | E-04 (行196-199) | ○ |
| C-10 | Memory記述子のポインタ進行がdescriptor_sizeに基づく | E-06 (行278-279) | ○ |
| C-11 | libxo経由でJSON/XML出力対応 | E-03 (行83-84), E-01 (行40) | ○ |
| C-12 | -gと-uオプションが同じ処理（UUID指定） | E-03 (行89-90) | ○ |
| C-13 | テーブル未指定時のエラー"table is not set" | E-03 (行146) | ○ |
| C-14 | 非対応テーブル時のエラー"unsupported efi table/table" | E-03 (行136, 149) | ○ |
| C-15 | XOバージョン"1"を設定 | E-01 (行43), E-04 (行179) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 各テーブルの出力項目（xo_emit呼び出しから直接確認可能）
- 0: efi_table_ops対応テーブル一覧（配列定義から直接確認可能）
- 0: エラーメッセージ（xo_errx呼び出しから直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] 各テーブルの出力項目がソースコードのxo_emit文と一致しているか
- [ ] efi_table_ops配列のGUID定義が正確か
- [ ] 2段階ioctlの説明が正確か
- [ ] Memory記述子のポインタ進行の説明が正確か
