---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-dumpfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/dumpfs/dumpfs.c` 行1-535（メインソースコード）
- E-02: `sbin/dumpfs/dumpfs.c` 行66-69（マクロ・グローバル変数）
- E-03: `sbin/dumpfs/dumpfs.c` 行82-137（main関数）
- E-04: `sbin/dumpfs/dumpfs.c` 行147-330（dumpfs関数）
- E-05: `sbin/dumpfs/dumpfs.c` 行332-390（dumpcg関数）
- E-06: `sbin/dumpfs/dumpfs.c` 行392-419（dumpfreespace関数）
- E-07: `sbin/dumpfs/dumpfs.c` 行421-474（marshal関数）
- E-08: `sbin/dumpfs/dumpfs.c` 行139-145（dumpfsid関数）
- E-09: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行38

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dumpfsはUFSファイルシステムのメタデータをダンプする | E-01, E-09 | ○ |
| C-02 | UFS1/UFS2両対応（disk.d_ufsで判別） | E-04 (行155-180) | ○ |
| C-03 | afs/acg マクロでスーパーブロック/CGにアクセス | E-02 (行66-68) | ○ |
| C-04 | libufs使用（ufs_disk_fillout_blank, sbfind, cgread） | E-03 (行120-121), E-04 (行322) | ○ |
| C-05 | スーパーブロック情報出力（magic/ncg/size/bsize等） | E-04 (行155-301) | ○ |
| C-06 | ファイルシステムフラグ10種類の文字列化 | E-04 (行246-276) | ○ |
| C-07 | csサマリーは4件ずつ改行 | E-04 (行305-306) | ○ |
| C-08 | dumpcg関数でCG詳細出力 | E-05 (行332-390) | ○ |
| C-09 | pbits()でビットマップ出力 | E-05 (行385-388) | ○ |
| C-10 | -fオプションで空きブロック一覧 | E-06 (行392-419) | ○ |
| C-11 | -ffで個別ブロック表示（dofreespace > 1判定） | E-01 (行507) | ○ |
| C-12 | -mオプションでnewfsコマンド復元 | E-07 (行421-474) | ○ |
| C-13 | -lオプションでFS IDのみ出力 | E-08 (行139-145) | ○ |
| C-14 | -sオプションでスーパーブロックのみ（CGスキップ） | E-04 (行319-320) | ○ |
| C-15 | -fと-mの排他チェック | E-03 (行114) | ○ |
| C-16 | bpg = fs_fpg / fs_frag | E-04 (行200, 216) | ○ |
| C-17 | CG位置計算: fsbtodb(cgtod(fs, lcg)) * disk.d_bsize | E-05 (行340) | ○ |
| C-18 | ufserr()でlibufsエラー/errno/unknown errorを返す | E-01 (行519-527) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: スーパーブロック出力項目（printf文から直接確認可能）
- 0: CGダンプ出力項目（printf文から直接確認可能）
- 0: newfs復元パラメータ（marshal関数から直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] UFS2/UFS1固有フィールドの分類が正確か
- [ ] フラグ文字列の対応が正確か
- [ ] marshal関数のnewfsオプション対応が網羅されているか
- [ ] dumpcg関数の出力項目が正確か
