---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：38-ffsinfo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DBG_DUMP_*マクロの実装詳細**：debug.cファイルが見つからなかった

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/ffsinfo/ffsinfo.c` 行1-632（メインソースコード）
- E-02: `sbin/ffsinfo/ffsinfo.c` 行70-100（グローバル変数・マクロ定義）
- E-03: `sbin/ffsinfo/ffsinfo.c` 行115-316（main関数）
- E-04: `sbin/ffsinfo/ffsinfo.c` 行323-470（dump_whole_ufs1_inode関数）
- E-05: `sbin/ffsinfo/ffsinfo.c` 行477-611（dump_whole_ufs2_inode関数）
- E-06: `sbin/ffsinfo/ffsinfo.c` 行617-631（usage関数）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行39

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ffsinfoはFFSの全メタデータを詳細にダンプする | E-01 (行103-113コメント), E-07 | ○ |
| C-02 | デバッグマクロ（DBG_DUMP_*）を使用 | E-03 (行211-212, 279等) | ○ |
| C-03 | 出力レベルビットマスク制御（0x001-0x3ff） | E-03 (行211, 229, 260, 278-287, 300-303) | ○ |
| C-04 | デフォルトレベルは0xff | E-03 (行134) | ○ |
| C-05 | sblock/acg/osblockマクロ定義 | E-02 (行77-85) | ○ |
| C-06 | cfg_cg=-2で全CG、-1で最後のCG | E-03 (行215-227) | ○ |
| C-07 | cfg_in=-2で範囲内全inode | E-03 (行302-308) | ○ |
| C-08 | デバイス名解決（/dev/r%s, /dev/%s試行） | E-03 (行184-203) | ○ |
| C-09 | ufs_disk_fillout_blank + sbfindでSB読取 | E-03 (行205-207) | ○ |
| C-10 | UFS1/UFS2両対応（DUMP_WHOLE_INODEマクロ） | E-02 (行98-100) | ○ |
| C-11 | dump_whole_ufs1_inodeで単一/二重/三重間接ブロック展開 | E-04 (行364-466) | ○ |
| C-12 | dump_whole_ufs2_inodeで同様の処理 | E-05 (行516-607) | ○ |
| C-13 | di_nlink==0でスキップ（未使用inode判定） | E-04 (行341-344), E-05 (行495-498) | ○ |
| C-14 | rb = howmany(di_size, fs_bsize) - UFS_NDADDR | E-04 (行364), E-05 (行516) | ○ |
| C-15 | i1blk/i2blk/i3blkが間接ブロックバッファ | E-02 (行87-89) | ○ |
| C-16 | csumの読取にbread使用 | E-03 (行237-242) | ○ |
| C-17 | 出力先はデフォルト"-"（標準出力） | E-03 (行137) | ○ |
| C-18 | DBG_DUMP_*マクロの実装はsbin/growfs/debug.cにある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DBG_DUMP_*マクロの実装詳細：debug.hはincludeされているが（行68）、Glob検索でsbin/ffsinfo/debug.*が見つからなかった。sbin/growfs/debug.cに実装があると推測されるが、直接確認していない。
  - 候補：`sbin/growfs/debug.c` / `sbin/growfs/debug.h` / Makefile参照

## 5) リスクフラグ（レビュー観点）
- 0: 出力レベルビットマスクの対応（main関数のif文から直接確認可能）
- 0: inode間接ブロック展開ロジック（dump_whole_ufs*_inode関数から確認可能）
- 1: DBG_DUMP_*マクロの出力形式（実装ファイル未確認のため中リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] 出力レベルビットマスクの各ビットの説明が正確か
- [ ] CG範囲決定ロジック（cfg_cg値と出力範囲の対応）が正確か
- [ ] inode間接ブロック展開の説明（UFS1/UFS2の差異含む）が正確か
- [ ] DBG_DUMP_*マクロの出力形式をdebug.cで確認すること
