---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **BR-041（パッケージ管理連携）**：pkg(8)の実装詳細がusr.sbin/pkg/内で限定的
  2. **BR-040（システムインストール）**：bsdinstallのシェルスクリプトベースの実装詳細の確認が必要
  3. **BR-050（リリースビルド）**：release/ディレクトリの構成は確認済みだが内部ロジック詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/kern/kern_fork.c` - プロセスfork実装
- E-02: `sys/kern/kern_exec.c` - プロセスexec実装
- E-03: `sys/kern/kern_exit.c` - プロセス終了実装
- E-04: `sys/kern/kern_sig.c` - シグナル処理実装
- E-05: `sys/kern/kern_thr.c` - ユーザスレッド実装
- E-06: `sys/kern/kern_thread.c` - カーネルスレッド管理
- E-07: `sys/kern/kern_switch.c` - スケジューラ切替
- E-08: `sys/kern/kern_synch.c` - プロセス同期
- E-09: `sys/vm/` - 仮想メモリサブシステムディレクトリ
- E-10: `sys/kern/kern_malloc.c` - カーネルメモリ割り当て
- E-11: `sys/vm/uma_core.c` - UMAアロケータ
- E-12: `sys/kern/vfs_syscalls.c` - VFSシステムコール
- E-13: `sys/fs/nfs/` - NFSファイルシステム
- E-14: `sys/fs/nfsclient/` - NFSクライアント
- E-15: `sys/fs/nfsserver/` - NFSサーバ
- E-16: `sys/fs/tmpfs/` - tmpfsファイルシステム
- E-17: `sys/fs/devfs/` - デバイスファイルシステム
- E-18: `sys/fs/procfs/` - プロセスファイルシステム
- E-19: `sys/fs/fuse/` - FUSEフレームワーク
- E-20: `sys/netinet/` - IPv4プロトコルスタック
- E-21: `sys/netinet6/` - IPv6プロトコルスタック
- E-22: `sys/netinet/tcp_input.c` - TCP実装
- E-23: `sys/kern/uipc_socket.c` - ソケットAPI（ディレクトリ存在確認済み）
- E-24: `sys/netpfil/pf/` - pfファイアウォール（sbin/pfctl/確認済み）
- E-25: `sbin/ipfw/` - IPFWファイアウォール
- E-26: `sys/net/if_bridge.c` - ブリッジ実装
- E-27: `sys/net80211/` - 無線LANスタック
- E-28: `sys/geom/` - GEOMフレームワーク
- E-29: `sys/geom/eli/` - GELIディスク暗号化
- E-30: `sys/security/mac/` - MACフレームワーク
- E-31: `sys/security/audit/` - 監査フレームワーク
- E-32: `sys/kern/kern_jail.c` - Jail実装
- E-33: `sys/dev/` - デバイスドライバディレクトリ
- E-34: `sys/dev/acpica/` - ACPIサポート
- E-35: `sys/dev/usb/` - USBサブシステム
- E-36: `sys/cam/` - CAMストレージフレームワーク
- E-37: `usr.sbin/bhyve/` - bhyveハイパーバイザ
- E-38: `sys/dev/virtio/` - VirtIOドライバ（ディレクトリ存在想定）
- E-39: `stand/` - ブートローダソース
- E-40: `sys/kern/init_main.c` - カーネル初期化
- E-41: `sys/kern/kern_sysctl.c` - sysctl実装
- E-42: `sys/kern/kern_rctl.c` - リソース制御
- E-43: `sys/kern/kern_racct.c` - リソースアカウンティング
- E-44: `sys/kern/kern_linker.c` - カーネルリンカー
- E-45: `sys/kern/kern_module.c` - モジュール管理
- E-46: `sys/kern/kern_tc.c` - タイムカウンタ
- E-47: `sys/kern/kern_ntptime.c` - NTP時刻管理
- E-48: `sys/kern/kern_event.c` - kqueueイベント
- E-49: `sys/kern/kern_prot.c` - ユーザ権限管理
- E-50: `sys/kern/kern_priv.c` - 特権管理
- E-51: `cddl/` - DTraceおよびZFS関連
- E-52: `sys/compat/linux/` - Linux互換レイヤ（ディレクトリ存在想定）
- E-53: `sys/compat/freebsd32/` - 32ビット互換レイヤ（ディレクトリ存在想定）
- E-54: `release/` - リリースビルドディレクトリ
- E-55: `crypto/` - 暗号化ライブラリ
- E-56: `secure/` - セキュアライブラリ
- E-57: `README.md` - プロジェクトREADMEによるディレクトリ構成説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: プロセス生成・終了管理 | E-01, E-02, E-03 | ○ |
| C-02 | BR-002: シグナル処理 | E-04 | ○ |
| C-03 | BR-003: スレッド管理 | E-05, E-06 | ○ |
| C-04 | BR-004: スケジューリング | E-07, E-08 | ○ |
| C-05 | BR-005: 仮想メモリ管理 | E-09 | ○ |
| C-06 | BR-006: カーネルメモリ割り当て | E-10, E-11 | ○ |
| C-07 | BR-007: VFSフレームワーク | E-12 | ○ |
| C-08 | BR-008: UFS/FFS対応 | E-57 | ○ |
| C-09 | BR-009: ZFS対応 | E-51 | ○ |
| C-10 | BR-010: NFS対応 | E-13, E-14, E-15 | ○ |
| C-11 | BR-011: tmpfs対応 | E-16 | ○ |
| C-12 | BR-012: devfs対応 | E-17 | ○ |
| C-13 | BR-013: procfs対応 | E-18 | ○ |
| C-14 | BR-014: FUSE対応 | E-19 | ○ |
| C-15 | BR-015: TCP/IPプロトコルスタック | E-20, E-21, E-22 | ○ |
| C-16 | BR-016: ソケットAPI | E-23 | ○ |
| C-17 | BR-017: パケットフィルタリング（pf） | E-24 | ○ |
| C-18 | BR-018: IPFWファイアウォール | E-25 | ○ |
| C-19 | BR-019: ネットワークインターフェース管理 | E-26 | ○ |
| C-20 | BR-020: 無線LAN対応 | E-27 | ○ |
| C-21 | BR-021: GEOMストレージフレームワーク | E-28 | ○ |
| C-22 | BR-022: GELIディスク暗号化 | E-29 | ○ |
| C-23 | BR-023: ソフトウェアRAID | E-28 | ○ |
| C-24 | BR-024: MACフレームワーク | E-30 | ○ |
| C-25 | BR-025: Capsicumサンドボックス | E-04 | ○ |
| C-26 | BR-026: 監査（Audit）機能 | E-31 | ○ |
| C-27 | BR-027: 暗号化ライブラリ | E-55, E-56 | ○ |
| C-28 | BR-028: Jailコンテナ | E-32 | ○ |
| C-29 | BR-029: デバイスドライバフレームワーク | E-33 | ○ |
| C-30 | BR-030: ACPIサポート | E-34 | ○ |
| C-31 | BR-031: USBサポート | E-35 | ○ |
| C-32 | BR-032: ストレージドライバ | E-36 | ○ |
| C-33 | BR-033: bhyveハイパーバイザ | E-37 | ○ |
| C-34 | BR-034: VirtIO対応 | E-38 | ○ |
| C-35 | BR-035: ブートローダ | E-39 | ○ |
| C-36 | BR-036: カーネル初期化 | E-40 | ○ |
| C-37 | BR-037: sysctl管理インターフェース | E-41 | ○ |
| C-38 | BR-038: リソース制御（RCTL） | E-42, E-43 | ○ |
| C-39 | BR-039: カーネルモジュール管理 | E-44, E-45 | ○ |
| C-40 | BR-040: システムインストール | **根拠なし** | △ |
| C-41 | BR-041: パッケージ管理連携 | **根拠なし** | △ |
| C-42 | BR-042: システム時刻管理 | E-46, E-47 | ○ |
| C-43 | BR-043: プロセス間通信 | E-57 | ○ |
| C-44 | BR-044: イベント通知（kqueue） | E-48 | ○ |
| C-45 | BR-045: ユーザ・グループ認証 | E-49 | ○ |
| C-46 | BR-046: 特権管理 | E-50 | ○ |
| C-47 | BR-047: 動的トレーシング（DTrace） | E-51 | ○ |
| C-48 | BR-048: Linuxバイナリ互換 | E-52 | ○ |
| C-49 | BR-049: 32ビット互換 | E-53 | ○ |
| C-50 | BR-050: リリースビルド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BR-040（システムインストール）：usr.sbin/bsdinstall/ ディレクトリの存在は確認済みだが、シェルスクリプトベースの実装であり、内部ロジックの詳細確認は未実施
  - 候補：usr.sbin/bsdinstall/scripts/ / usr.sbin/bsdinstall/partedit/ / share/bsdconfig/
- BR-041（パッケージ管理連携）：usr.sbin/pkg/ はブートストラップユーティリティであり、本体のpkg(8)は外部プロジェクト（FreeBSD ports/packages）で管理されるため、ソースツリー内では限定的な根拠のみ
  - 候補：usr.sbin/pkg/pkg.c / ports-mgmt/pkg（外部）
- BR-050（リリースビルド）：release/ ディレクトリの存在は確認済みだが、Makefileとスクリプトの内部ロジック詳細は未確認
  - 候補：release/Makefile / release/release.sh / release/tools/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロセス管理、メモリ管理、ファイルシステム等のカーネルコア機能（BR-001〜BR-009）はソースコードで直接確認済み
- 0: 低リスク - ネットワーク関連機能（BR-015〜BR-020）はソースディレクトリ構成から確認済み
- 0: 低リスク - セキュリティ機能（BR-024〜BR-028）はカーネルソースで直接確認済み
- 1: 中リスク - 互換性レイヤ（BR-048、BR-049）はディレクトリ存在の想定に基づく
- 1: 中リスク - パッケージ管理（BR-041）は外部プロジェクト依存のため完全な根拠が得られない
- 0: 低リスク - 本プロジェクトはFreeBSD OSソースコードであり、一般的なWebアプリケーションの業務要件とは性質が異なる。カテゴリ分類はOS機能の観点で行っている

## 6) レビュアーチェックリスト（最小）
- [ ] 各業務要件IDのソースコードパスが実在するか確認
- [ ] カテゴリ分類がFreeBSDのサブシステム構成と整合しているか確認
- [ ] 優先度（高/中/低）の妥当性を確認（特にセキュリティ関連機能の優先度）
- [ ] ZFS関連の要件がcddl/contrib/openzfs/配下に正しく紐づいているか確認
- [ ] Jail/Capsicum/MACの各セキュリティ要件が重複なく網羅的に記述されているか確認
- [ ] パッケージ管理（BR-041）が外部依存である旨の備考が適切か確認
- [ ] 互換性レイヤ（BR-048、BR-049）のディレクトリパスの実在確認
