---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 110
  claims_with_evidence: 105
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：105 / 110、根拠なし：5
- 優先レビュー（高）
  1. **GPUドライバ（C-58）**：sys/dev/drm/ の存在が未確認。FreeBSDではDRM/KMSはポートまたは別リポジトリの場合あり
  2. **NTPデーモン（C-98）**：usr.sbin/ntpd の正確なパス未確認。FreeBSDではntpdがcontrib配下の場合あり
  3. **inetd（C-101）**：usr.sbin/inetd の存在確認が不十分
  4. **サウンドデバイス（C-59）**：sys/dev/sound/ の詳細構造未確認
  5. **jail（C-65）**：usr.sbin/jail コマンド群の正確なパス未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルート - ソースロードマップ）
- E-02: `bin/` ディレクトリ一覧（cat, chmod, cp, ls, sh 等44エントリ）
- E-03: `sbin/` ディレクトリ一覧（ifconfig, mount, fsck, geom 等90エントリ）
- E-04: `usr.bin/` ディレクトリ一覧（awk, clang, diff, grep 等280エントリ）
- E-05: `usr.sbin/` ディレクトリ一覧（bhyve, cron, audit 等236エントリ）
- E-06: `sys/kern/` ディレクトリ一覧（kern_exec.c, kern_fork.c 等カーネルソース）
- E-07: `sys/fs/` ディレクトリ一覧（autofs, cd9660, devfs, ext2fs, fuse, msdosfs, nfs, nullfs, procfs, tarfs, tmpfs, udf, unionfs 等）
- E-08: `sys/geom/` ディレクトリ一覧（eli, gate, mirror, raid, stripe 等）
- E-09: `sys/net/` ディレクトリ一覧（bpf, if_bridge, route 等ネットワークソース）
- E-10: `sys/netinet/` ディレクトリ一覧（TCP/IP関連ソース）
- E-11: `sys/netpfil/` ディレクトリ一覧（ipfilter, ipfw, pf）
- E-12: `sys/security/` ディレクトリ一覧（audit, mac, mac_biba, mac_veriexec 等）
- E-13: `sys/dev/` ディレクトリ一覧（ahci, ath, bge, usb 等デバイスドライバ）
- E-14: `sys/vm/` ディレクトリ一覧（vm_map.c, vm_page.c, swap_pager.c 等）
- E-15: `lib/` ディレクトリ一覧（libc, libalias, libarchive, libelf, libfetch 等）
- E-16: `crypto/` ディレクトリ一覧（heimdal, openssh, openssl）
- E-17: `secure/` ディレクトリ一覧（lib, usr.bin, usr.sbin）
- E-18: `kerberos5/` ディレクトリ存在確認
- E-19: `cddl/` ディレクトリ一覧（ZFS/DTrace関連）
- E-20: `stand/` ディレクトリ一覧（ブートローダソース）
- E-21: `libexec/` ディレクトリ一覧（hyperv, rc, rtld-elf 等）
- E-22: `release/` ディレクトリ存在確認
- E-23: `rescue/` ディレクトリ存在確認
- E-24: `tests/` ディレクトリ存在確認
- E-25: `share/` ディレクトリ一覧（man, i18n, mk 等）
- E-26: `sys/netgraph/` ディレクトリ存在確認（README.mdのロードマップ記載）
- E-27: `sys/netlink/` ディレクトリ存在確認
- E-28: `sys/xen/` ディレクトリ存在確認
- E-29: `sys/ddb/` ディレクトリ存在確認
- E-30: `sys/cam/` ディレクトリ存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロセス管理 | E-06 | ○ |
| C-02 | メモリ管理（仮想メモリ） | E-14 | ○ |
| C-03 | スレッド管理 | E-06 | ○ |
| C-04 | システムコールインタフェース | E-06 | ○ |
| C-05 | タイマー・クロック管理 | E-06 | ○ |
| C-06 | カーネルモジュール管理 | E-03 | ○ |
| C-07 | sysctl管理 | E-03, E-06 | ○ |
| C-08 | DTrace動的トレーシング | E-19, E-06 | ○ |
| C-09 | DDBカーネルデバッガ | E-29, E-03 | ○ |
| C-10 | イベント通知（kqueue） | E-06 | ○ |
| C-11 | UFS/FFS | E-07, E-03 | ○ |
| C-12 | ZFS | E-19 | ○ |
| C-13 | NFS（クライアント/サーバ） | E-07, E-03 | ○ |
| C-14 | msdosfs（FAT） | E-07, E-03 | ○ |
| C-15 | cd9660（ISO 9660） | E-07, E-03 | ○ |
| C-16 | tmpfs | E-07 | ○ |
| C-17 | nullfs | E-07, E-03 | ○ |
| C-18 | unionfs | E-07, E-03 | ○ |
| C-19 | FUSE | E-07, E-03 | ○ |
| C-20 | procfs / fdescfs | E-07 | ○ |
| C-21 | devfs | E-07, E-03 | ○ |
| C-22 | autofs | E-07, E-05 | ○ |
| C-23 | ext2fs | E-07 | ○ |
| C-24 | tarfs | E-07 | ○ |
| C-25 | UDF | E-07, E-03 | ○ |
| C-26 | GEOMストレージフレームワーク | E-08, E-03, E-15 | ○ |
| C-27 | GEOM ELI（ディスク暗号化） | E-08 | ○ |
| C-28 | GEOMミラー・ストライプ・RAID | E-08 | ○ |
| C-29 | GEOMゲートウェイ | E-08, E-03 | ○ |
| C-30 | CAMストレージサブシステム | E-30, E-03 | ○ |
| C-31 | NVMeコントローラ管理 | E-03 | ○ |
| C-32 | mdデバイス（メモリディスク） | E-03 | ○ |
| C-33 | スワップ管理 | E-03 | ○ |
| C-34 | TCP/IPプロトコルスタック | E-10 | ○ |
| C-35 | ネットワークインタフェース管理 | E-03, E-09 | ○ |
| C-36 | ルーティング | E-03, E-09 | ○ |
| C-37 | ブリッジング | E-09 | ○ |
| C-38 | BPF（パケットフィルタ） | E-09 | ○ |
| C-39 | netgraph | E-26 | ○ |
| C-40 | NetLink | E-27 | ○ |
| C-41 | IPFW | E-03, E-11 | ○ |
| C-42 | PF（Packet Filter） | E-03, E-11 | ○ |
| C-43 | IPFilter | E-03, E-11 | ○ |
| C-44 | MAC（Mandatory Access Control） | E-12 | ○ |
| C-45 | audit（セキュリティ監査） | E-12, E-05 | ○ |
| C-46 | Capsicum（ケイパビリティモード） | E-15 | ○ |
| C-47 | veriexec（実行ファイル検証） | E-12, E-03 | ○ |
| C-48 | 暗号化ライブラリ | E-16 | ○ |
| C-49 | IPsec | E-03 | ○ |
| C-50 | Kerberos 5（Heimdal） | E-18, E-16 | ○ |
| C-51 | SSH | E-16, E-17 | ○ |
| C-52 | ACL管理 | E-02 | ○ |
| C-53 | AHCIドライバ | E-13 | ○ |
| C-54 | NVMeドライバ | E-13 | ○ |
| C-55 | ネットワークデバイスドライバ | E-13 | ○ |
| C-56 | USBサブシステム | E-13 | ○ |
| C-57 | ACPIサポート | E-13 | ○ |
| C-58 | GPUドライバ | **根拠不足** | △ |
| C-59 | サウンドデバイス | **根拠不足** | △ |
| C-60 | コンソールドライバ | E-13 | ○ |
| C-61 | devdデバイスイベント | E-03, E-05 | ○ |
| C-62 | bhyveハイパーバイザ | E-05 | ○ |
| C-63 | Hyper-Vサポート | E-21 | ○ |
| C-64 | Xenサポート | E-28 | ○ |
| C-65 | jail（コンテナ） | E-06 | ○ |
| C-66 | ブートローダ（loader） | E-20 | ○ |
| C-67 | EFIブートマネージャ | E-05 | ○ |
| C-68 | Boot Environment管理 | E-03 | ○ |
| C-69 | init / rc | E-03, E-21 | ○ |
| C-70 | cron | E-05 | ○ |
| C-71 | syslogd | E-05 | ○ |
| C-72 | shutdown / reboot | E-03 | ○ |
| C-73 | ユーザ・グループ管理 | E-05, E-04 | ○ |
| C-74 | パッケージ管理支援 | E-05 | ○ |
| C-75 | ディスククォータ | E-05, E-03 | ○ |
| C-76 | コアダンプ管理 | E-03 | ○ |
| C-77 | dmesgシステムメッセージ | E-03 | ○ |
| C-78 | 電源管理 | E-05 | ○ |
| C-79 | シェル（sh / csh） | E-02 | ○ |
| C-80 | ファイル操作 | E-02 | ○ |
| C-81 | テキスト処理 | E-04 | ○ |
| C-82 | プロセス管理コマンド | E-02 | ○ |
| C-83 | アーカイブ・圧縮 | E-02, E-04 | ○ |
| C-84 | 日時・環境情報 | E-02 | ○ |
| C-85 | エディタ | E-02, E-04 | ○ |
| C-86 | make（ビルドツール） | E-04 | ○ |
| C-87 | Clangコンパイラ | E-04 | ○ |
| C-88 | libc（標準Cライブラリ） | E-15 | ○ |
| C-89 | libpthread（スレッドライブラリ） | E-15 | ○ |
| C-90 | libc++（C++標準ライブラリ） | E-15 | ○ |
| C-91 | libfetch | E-15 | ○ |
| C-92 | libarchive | E-15 | ○ |
| C-93 | libedit | E-15 | ○ |
| C-94 | libelf | E-15 | ○ |
| C-95 | libalias | E-15 | ○ |
| C-96 | DHCPクライアント | E-03 | ○ |
| C-97 | DNS解決 | E-03 | ○ |
| C-98 | NTPデーモン | **根拠不足** | △ |
| C-99 | SNMPエージェント | E-05 | ○ |
| C-100 | sendmail（メール配送） | E-21 | ○ |
| C-101 | inetd | **根拠不足** | △ |
| C-102 | PPPoE | E-21 | ○ |
| C-103 | ARPテーブル管理 | E-05 | ○ |
| C-104 | Bluetooth | E-04, E-05, E-15 | ○ |
| C-105 | リリースビルド | E-22 | ○ |
| C-106 | rescueツール | E-23 | ○ |
| C-107 | ビルドシステム | E-01, E-25 | ○ |
| C-108 | リグレッションテスト | E-24 | ○ |
| C-109 | manページ | E-25 | ○ |
| C-110 | 国際化・地域化 | E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-58 GPUドライバ**: sys/dev/drm/ ディレクトリの存在が直接確認できていない。FreeBSDではGPUドライバ（DRM/KMS）はportまたはdrm-kmodパッケージとして別途提供される可能性がある
  - 候補：sys/dev/ 配下の詳細スキャン / portsツリーの確認
- **C-59 サウンドデバイス**: sys/dev/sound/ ディレクトリの存在を直接確認していない
  - 候補：sys/dev/ 全ディレクトリの詳細スキャン
- **C-98 NTPデーモン**: usr.sbin/ntpd の正確なパスが未確認。FreeBSDではntpdがcontrib/ntp配下に存在する可能性がある
  - 候補：usr.sbin/ の全エントリ確認 / contrib/ 配下の確認
- **C-101 inetd**: usr.sbin/inetd の存在が236エントリの部分表示では確認できていない
  - 候補：usr.sbin/ の全エントリ確認
- **C-65 jail**: usr.sbin/jail コマンド群の正確な所在。kern_jail.c はsys/kern/に存在すると推定されるが直接未確認
  - 候補：sys/kern/ の全ファイル一覧確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: カーネル基盤（C-01〜C-10）、ファイルシステム（C-11〜C-25）、ストレージ（C-26〜C-33）、ネットワーク（C-34〜C-40）、ファイアウォール（C-41〜C-43）、セキュリティ（C-44〜C-52）、基本ユーザコマンド（C-79〜C-87）、ライブラリ（C-88〜C-95） -- ディレクトリ存在を直接確認済み
- **1（中リスク）**: GPUドライバ（C-58）、サウンドデバイス（C-59）、NTPデーモン（C-98）、inetd（C-101）、jail（C-65） -- ディレクトリ・ファイルの直接確認が不十分
- **1（中リスク）**: 機能一覧の網羅性 -- FreeBSD全体は非常に巨大なプロジェクトであり、全機能を110項目で網羅しきれていない可能性がある（例: Wi-Fi 802.11フレームワーク、iSCSI、CTL、各種contrib等）

## 6) レビュアーチェックリスト（最小）
- [ ] GPUドライバ（C-58）のソースコード所在を確認し、FreeBSD本体に含まれるか外部パッケージか判定する
- [ ] サウンドデバイス（C-59）のsys/dev/sound/ 存在を確認する
- [ ] NTPデーモン（C-98）の正確なソースパスを確認する
- [ ] inetd（C-101）のusr.sbin/inetd 存在を確認する
- [ ] jail（C-65）のusr.sbin/jail コマンドのパスを確認する
- [ ] カテゴリ分類の妥当性を確認する（特にストレージとファイルシステムの境界）
- [ ] 漏れている主要機能がないか確認する（802.11、iSCSI、CTL、poudriere等）
- [ ] 各機能の説明文が正確かつ十分か確認する
