# 機能設計書 104-Bluetooth

## 概要

本ドキュメントは、FreeBSDのBluetoothプロトコルスタックおよびユーティリティ群の機能設計を記述する。HCI、L2CAP、RFCOMM、SDP等のBluetoothプロトコル層と各種管理ツールを含む。

### 本機能の処理概要

FreeBSDのBluetooth機能は、netgraphフレームワーク上に構築されたBluetoothプロトコルスタックと、ユーザ空間の管理ユーティリティ群、およびライブラリ(libbluetooth)から構成される。HCI（Host Controller Interface）、L2CAP（Logical Link Control and Adaptation Protocol）、RFCOMM、SDP（Service Discovery Protocol）の各プロトコル層を実装する。

**業務上の目的・背景**：Bluetoothは近距離無線通信の標準規格であり、キーボード、マウス、ヘッドセット、携帯電話等の多様なデバイスとの接続に使用される。FreeBSDのBluetoothサポートにより、Bluetoothデバイスの検出・ペアリング・データ通信が可能となる。

**機能の利用シーン**：Bluetoothデバイスの検出・接続設定、Bluetoothシリアルポート（SPP）経由の通信、Bluetooth HID（Human Interface Device）の接続、Bluetooth PAN（Personal Area Network）の構築、SDPサービスの検索・登録。

**主要な処理内容**：
1. HCIコントローラの制御・管理（hccontrol）
2. HCIセキュリティデーモン（hcsecd）によるペアリング管理
3. L2CAPプロトコルの制御（l2control）
4. L2CAPレベルのping（l2ping）
5. SDPサービスの検索・制御（sdpcontrol）
6. SDPサーバデーモン（sdpd）
7. RFCOMM SPP接続（rfcomm_sppd）
8. RFCOMM PPP接続（rfcomm_pppd）
9. Bluetooth HIDデーモン（bthidd / bthidcontrol）
10. Bluetooth PAN（btpand）
11. Bluetooth設定ツール（bluetooth-config）
12. ファームウェアローダ（ath3kfw, bcmfw, iwmbtfw, rtlbtfw）
13. ホスト名・プロトコル解決（bthost, btsockstat）
14. libbluetooth共有ライブラリ

**関連システム・外部連携**：netgraph(4)フレームワーク（ng_bluetooth, ng_hci, ng_l2cap, ng_btsocket）、USBサブシステム（Bluetoothアダプタ接続）。

**権限による制御**：HCIコントローラの制御やデーモンの起動にはroot権限が必要。一部のユーティリティ（bthost等）は一般ユーザでも利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIツール群 | 主機能 | コマンドラインツール群、画面なし |

## 機能種別

プロトコルスタック / デーモンプロセス群 / CLI管理ツール群

## 入力仕様

### 入力パラメータ

主要ツールの代表的なパラメータを示す。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| hccontrol -n node | 文字列 | Yes | HCIノード名 | 有効なnetgraphノード名 |
| l2control -a address | BDアドレス | Yes | Bluetoothデバイスアドレス | 有効なBDアドレス形式 |
| l2ping -a address | BDアドレス | Yes | pingターゲットアドレス | 有効なBDアドレス形式 |
| sdpcontrol -a address | BDアドレス | Yes | SDPサーバアドレス | 有効なBDアドレス形式 |
| rfcomm_sppd -a address -c channel | BDアドレス+整数 | Yes | 接続先アドレスとチャネル | 有効なBDアドレスとチャネル番号 |
| bthidd -c config | ファイルパス | No | 設定ファイルパス | 読み取り可能 |

### 入力データソース

- コマンドライン引数
- 設定ファイル（hcsecd.conf, bthidd.conf等）
- netgraphソケット経由のBluetoothデバイスイベント
- /etc/bluetooth/hosts（Bluetoothホストデータベース）
- /etc/bluetooth/protocols（Bluetoothプロトコルデータベース）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| デバイス情報 | テキスト | Bluetoothデバイスの名前・アドレス・クラス等 |
| SDPサービスレコード | テキスト | SDPサービスの属性情報 |
| 接続状態 | テキスト | 接続確立・切断の状態メッセージ |
| syslogメッセージ | テキスト | デーモンのログ出力 |

### 出力先

- 標準出力（コマンドラインツール）
- syslog（デーモンプロセス）
- /dev/tty（rfcomm_sppdのシリアルポートエミュレーション）

## 処理フロー

### 処理シーケンス

```
1. Bluetoothアダプタの認識
   └─ USBサブシステムがアダプタを認識、netgraph HCIノード作成
2. HCIコントローラ初期化
   └─ hccontrolでHCIノードのリセット・設定
3. セキュリティ設定
   └─ hcsecdでPINコード/リンクキー管理
4. デバイス検出
   └─ hccontrol inquiryでデバイススキャン
5. 接続確立
   ├─ L2CAP接続: l2control / libbluetooth API
   ├─ RFCOMM SPP: rfcomm_sppd
   ├─ HID: bthidd
   └─ PAN: btpand
6. サービス検出
   └─ sdpcontrolでSDPサービス検索
```

### フローチャート

```mermaid
flowchart TD
    A[Bluetoothアダプタ接続] --> B[USBドライバ認識]
    B --> C[netgraph HCIノード作成]
    C --> D[hccontrol: HCI初期化]
    D --> E[hcsecd: セキュリティデーモン起動]
    E --> F{利用形態}
    F -->|HID| G[bthidd: HIDデーモン]
    F -->|SPP| H[rfcomm_sppd: シリアルポート]
    F -->|PAN| I[btpand: ネットワーク]
    F -->|SDP検索| J[sdpcontrol: サービス検出]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-104-1 | BDアドレス形式 | Bluetoothデバイスアドレスはxx:xx:xx:xx:xx:xx形式の6バイト | 全ツール共通 |
| BR-104-2 | ペアリング | HCIセキュリティデーモン(hcsecd)がPINコードとリンクキーを管理 | ペアリング時 |
| BR-104-3 | netgraph依存 | 全プロトコル層はnetgraphフレームワーク上で動作 | 常時 |
| BR-104-4 | ファームウェアロード | 特定チップセット(ath3k, bcm, iwm, rtl)はファームウェアのロードが必要 | デバイス初期化時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。/etc/bluetooth/hostsと/etc/bluetooth/protocolsをテキストファイルとして参照する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENODEV | デバイス不在 | Bluetoothアダプタが接続されていない | エラーメッセージ表示 |
| ECONNREFUSED | 接続拒否 | リモートデバイスが接続を拒否 | エラーメッセージ表示 |
| ETIMEDOUT | タイムアウト | 接続タイムアウト | エラーメッセージ表示 |
| EAUTH | 認証失敗 | ペアリングPINコード不一致 | hcsecdで再ペアリング |

### リトライ仕様

個別ツールレベルではリトライ機構なし。ユーザが手動で再実行する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- Bluetooth 2.0/2.1の場合、最大データレートは3 Mbps（EDR）
- デバイス検出（inquiry）は約10秒程度のスキャン時間

## セキュリティ考慮事項

- Bluetooth Simple Secure Pairing (SSP)サポート
- PINコードベースの旧式ペアリングもサポート
- hcsecdデーモンがリンクキーの永続管理を担当
- HCIコントローラ操作にはroot権限が必要

## 備考

- FreeBSDのBluetoothスタックはnetgraph(4)フレームワーク上に構築されており、カーネル内のプロトコル処理はng_bluetooth, ng_hci, ng_l2cap, ng_btsocketモジュールで実装される
- Linux BlueZ互換マクロ（bacmp, bacpy, ba2str, str2ba等）がbluetooth.hで提供されている
- 複数のファームウェアローダが各チップセットベンダ向けに用意されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bluetooth.h | `lib/libbluetooth/bluetooth.h` | bdaddr_t型、BlueZ互換マクロ、libbluetooth API宣言 |
| 1-2 | bluetooth.c | `lib/libbluetooth/bluetooth.c` | bt_ntoa(), bt_aton()等のアドレス変換関数 |

**読解のコツ**: bluetooth.h(35-80行目)がlibbluetooth APIの中核。BlueZ互換マクロ(62-69行目)によりLinuxのBluetoothコードとの移植性が確保されている。netgraph系ヘッダ(49-53行目)のインクルードがFreeBSD固有のnetgraph依存を示す。

#### Step 2: ホスト解決APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bluetooth.h | `lib/libbluetooth/bluetooth.h` | bt_gethostbyname(), bt_gethostbyaddr()等のホスト解決API |

**主要処理フロー**:
- **75-79行目**: bt_gethostbyname(), bt_gethostbyaddr(), bt_gethostent(), bt_sethostent(), bt_endhostent()のプロトタイプ

#### Step 3: ユーザ空間ツール群を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hccontrol/ | `usr.sbin/bluetooth/hccontrol/` | HCIコントローラ制御コマンド |
| 3-2 | l2control/ | `usr.sbin/bluetooth/l2control/` | L2CAP制御コマンド |
| 3-3 | sdpcontrol/ | `usr.sbin/bluetooth/sdpcontrol/` | SDPサービス検索 |
| 3-4 | sdpd/ | `usr.sbin/bluetooth/sdpd/` | SDPサーバデーモン |
| 3-5 | bthidd/ | `usr.sbin/bluetooth/bthidd/` | Bluetooth HIDデーモン |

#### Step 4: デバイス固有ファームウェアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ath3kfw/ | `usr.sbin/bluetooth/ath3kfw/` | Atheros Bluetoothファームウェアローダ |
| 4-2 | iwmbtfw/ | `usr.sbin/bluetooth/iwmbtfw/` | Intel Wireless Bluetoothファームウェアローダ |
| 4-3 | rtlbtfw/ | `usr.sbin/bluetooth/rtlbtfw/` | Realtek Bluetoothファームウェアローダ |

### プログラム呼び出し階層図

```
[ユーザ空間ツール群]
    |
    ├─ hccontrol ──── ng_hci (netgraph) ──── HCIコントローラ
    ├─ hcsecd ─────── ng_hci ─── PINコード/リンクキー管理
    ├─ l2control ──── ng_l2cap ──── L2CAP制御
    ├─ l2ping ─────── ng_l2cap ──── L2CAP Echo
    ├─ sdpcontrol ─── ng_btsocket ──── SDP検索
    ├─ sdpd ────────── ng_btsocket ──── SDPサーバ
    ├─ rfcomm_sppd ── ng_btsocket ──── RFCOMM SPP
    ├─ rfcomm_pppd ── ng_btsocket ──── RFCOMM PPP
    ├─ bthidd ─────── ng_btsocket ──── HIDプロファイル
    ├─ btpand ─────── ng_btsocket ──── PANプロファイル
    └─ ath3kfw/iwmbtfw/rtlbtfw ──── USB ──── ファームウェアロード

[ライブラリ]
    └─ libbluetooth ──── netgraph API ──── カーネルBluetoothスタック
```

### データフロー図

```
[入力]                      [処理]                       [出力]

Bluetooth RF ──▶ USB HCI ──▶ ng_hci ──▶ ng_l2cap ──▶ ng_btsocket
                                                          |
                                              ┌───────────┼──────────┐
                                              |           |          |
                                          rfcomm_sppd  bthidd   btpand
                                              |           |          |
                                          /dev/tty    input dev   tap/tun
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bluetooth.h | `lib/libbluetooth/bluetooth.h` | ヘッダ | libbluetooth API定義 |
| bluetooth.c | `lib/libbluetooth/bluetooth.c` | ソース | アドレス変換等の基本関数 |
| hci.c | `lib/libbluetooth/hci.c` | ソース | HCI関連ライブラリ関数 |
| dev.c | `lib/libbluetooth/dev.c` | ソース | デバイス管理ライブラリ関数 |
| hosts | `lib/libbluetooth/hosts` | 設定 | Bluetoothホストデータベースサンプル |
| protocols | `lib/libbluetooth/protocols` | 設定 | Bluetoothプロトコルデータベースサンプル |
| hccontrol/ | `usr.sbin/bluetooth/hccontrol/` | ソース | HCIコントローラ制御ツール |
| hcsecd/ | `usr.sbin/bluetooth/hcsecd/` | ソース | HCIセキュリティデーモン |
| l2control/ | `usr.sbin/bluetooth/l2control/` | ソース | L2CAP制御ツール |
| l2ping/ | `usr.sbin/bluetooth/l2ping/` | ソース | L2CAP pingツール |
| sdpcontrol/ | `usr.sbin/bluetooth/sdpcontrol/` | ソース | SDP制御ツール |
| sdpd/ | `usr.sbin/bluetooth/sdpd/` | ソース | SDPサーバデーモン |
| rfcomm_sppd/ | `usr.bin/bluetooth/rfcomm_sppd/` | ソース | RFCOMM SPP接続ツール |
| bthidd/ | `usr.sbin/bluetooth/bthidd/` | ソース | Bluetooth HIDデーモン |
| btpand/ | `usr.sbin/bluetooth/btpand/` | ソース | Bluetooth PANデーモン |
| ath3kfw/ | `usr.sbin/bluetooth/ath3kfw/` | ソース | Atheros FWローダ |
| iwmbtfw/ | `usr.sbin/bluetooth/iwmbtfw/` | ソース | Intel FWローダ |
| rtlbtfw/ | `usr.sbin/bluetooth/rtlbtfw/` | ソース | Realtek FWローダ |
| bthost/ | `usr.bin/bluetooth/bthost/` | ソース | Bluetoothホスト名解決ツール |
| btsockstat/ | `usr.bin/bluetooth/btsockstat/` | ソース | Bluetoothソケット状態表示ツール |
