# 機能設計書 105-リリースビルド

## 概要

本ドキュメントは、FreeBSDリリースイメージの構築機能の設計を記述する。release.shスクリプトとrelease/ディレクトリのMakefile群により、インストールCD/DVD/USB/VMイメージを自動的に構築する。

### 本機能の処理概要

FreeBSDリリースビルドシステムは、ソースツリーからFreeBSDの公式リリースイメージを構築するための自動化されたビルドパイプラインである。chroot環境でのクリーンビルド、カーネル・ユーザランドのクロスコンパイル、インストールメディアの作成、仮想マシンイメージの生成を一貫して行う。

**業務上の目的・背景**：FreeBSDプロジェクトは定期的にリリースイメージを公開しており、再現可能なリリースビルドプロセスが不可欠である。release.shはこのプロセスを自動化し、クリーンなchroot環境内でソースツリーのチェックアウトからイメージ生成まで一貫して実行する。ISPやシステムベンダがカスタムFreeBSDイメージを構築する際にも利用される。

**機能の利用シーン**：FreeBSD公式リリースの構築、カスタムインストールイメージの作成、仮想マシンイメージ（VMware/VirtualBox/Hyper-V等）の生成、クラウドイメージ（AWS EC2/GCE/Azure/OCI）の生成。

**主要な処理内容**：
1. chroot環境のセットアップ（ソースツリーチェックアウト、buildworld/installworld）
2. ターゲットアーキテクチャ向けのクロスビルド（buildworld/buildkernel）
3. リリースMakefile（release/Makefile）による成果物生成
4. ISOイメージ（disc1.iso, dvd1.iso）の作成
5. メモリスティックイメージ（memstick.img）の作成
6. 仮想マシンイメージ（.vmdk, .vhd, .qcow2等）の作成
7. クラウドイメージ（AMI, GCE image等）の作成
8. OCI（コンテナ）イメージの作成
9. アーキテクチャ別（amd64, arm64, i386, powerpc, riscv）のビルド対応

**関連システム・外部連携**：git（ソースツリー取得）、make/bmake（ビルドシステム）、chroot（隔離環境）、pkg（パッケージ管理）。

**権限による制御**：リリースビルドはroot権限で実行する必要がある（chroot環境の構築、mount操作等のため）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIスクリプト | 主機能 | シェルスクリプトによるバッチ処理、画面なし |

## 機能種別

ビルド自動化 / イメージ生成 / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -c release.conf | ファイルパス | No | カスタム設定ファイル | 読み取り可能なファイル |
| CHROOTDIR | 環境変数 | No | chroot環境のルートディレクトリ（デフォルト/scratch） | 有効なディレクトリパス |
| SRCBRANCH | 環境変数 | No | ソースブランチ（デフォルトmain） | 有効なgitブランチ名 |
| KERNEL | 環境変数 | No | カーネル設定名（デフォルトGENERIC） | 有効なカーネル設定名 |
| TARGET | 環境変数 | No | ターゲットアーキテクチャ | amd64, arm, arm64, i386, powerpc, riscv |
| TARGET_ARCH | 環境変数 | No | ターゲットCPUアーキテクチャ | 対応するアーキテクチャ名 |
| WITH_DVD | 環境変数 | No | DVDイメージ作成の有効化 | 空でない値 |
| WITH_VMIMAGES | 環境変数 | No | 仮想マシンイメージ作成の有効化 | 空でない値 |
| WITH_CLOUDWARE | 環境変数 | No | クラウドイメージ作成の有効化 | 空でない値 |
| WITH_OCIIMAGES | 環境変数 | No | OCIイメージ作成の有効化 | 空でない値 |

### 入力データソース

- release.conf: カスタムビルド設定
- git リポジトリ: FreeBSD ソースツリーおよびportsツリー
- カーネル設定ファイル: sys/${TARGET}/conf/${KERNEL}

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| disc1.iso | ISOイメージ | CD/DVDインストールイメージ |
| dvd1.iso | ISOイメージ | DVD インストールイメージ（WITH_DVD時） |
| memstick.img | ディスクイメージ | USBメモリスティックイメージ |
| *.vmdk, *.vhd, *.qcow2 | VMイメージ | 各種仮想マシンイメージ（WITH_VMIMAGES時） |
| クラウドイメージ | 各種形式 | AWS/GCE/Azure等のクラウドイメージ（WITH_CLOUDWARE時） |
| MANIFEST | テキスト | 配布ファイルのチェックサムとサイズ情報 |

### 出力先

- ${CHROOTDIR}/R/（リリース成果物ディレクトリ）

## 処理フロー

### 処理シーケンス

```
1. 環境設定（env_setup / env_check）
   └─ 変数初期化、git/make/chroot等の前提条件確認
2. chroot環境セットアップ（chroot_setup）
   ├─ gitでソースツリーをクローン/pull
   ├─ buildworld → installworld → distribution
   └─ chroot環境へのシステムインストール
3. 追加chroot設定（extra_chroot_setup）
   ├─ devfs マウント
   ├─ resolv.conf コピー
   └─ ldconfig実行
4. リリースビルド（chroot_build_release）
   ├─ chroot内でbuildworld
   ├─ chroot内でbuildkernel
   └─ chroot内でmake release
5. 後処理（chroot_build_release_post）
   └─ devfsアンマウント等
```

### フローチャート

```mermaid
flowchart TD
    A[release.sh起動] --> B[env_setup: 変数初期化]
    B --> C[release.conf読み込み]
    C --> D[env_check: 前提条件確認]
    D --> E[chroot_setup: 環境構築]
    E --> F[git clone ソースツリー]
    F --> G[buildworld + installworld + distribution]
    G --> H[extra_chroot_setup: devfsマウント等]
    H --> I[chroot_build_release]
    I --> J[chroot内 buildworld]
    J --> K[chroot内 buildkernel]
    K --> L[chroot内 make release]
    L --> M[ISO/IMG/VM イメージ生成]
    M --> N[chroot_build_release_post: 後処理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-105-1 | root必須 | リリースビルドはroot権限で実行する必要がある | 常時 |
| BR-105-2 | クリーンビルド | chroot環境内でクリーンビルドを実施し、ホストシステムの影響を排除 | 常時 |
| BR-105-3 | make.conf/src.conf無効化 | chroot内では/dev/nullをmake.conf/src.confとして使用 | chroot内ビルド時 |
| BR-105-4 | 並列ビルド | WORLD_FLAGSはCPU数、KERNEL_FLAGSはCPU数の半分の並列数 | 常時 |
| BR-105-5 | 組み込みビルド | EMBEDDEDBUILD設定時はDVD/圧縮イメージを無効化 | ARM/RISC-Vビルド時 |

### 計算ロジック

- WORLD_FLAGS: `-j$(sysctl -n hw.ncpu)` (CPU数分の並列ジョブ)
- KERNEL_FLAGS: `-j$(( $(( $(sysctl -n hw.ncpu) + 1 )) / 2))` (CPU数の半分の並列ジョブ)
- RELEASE_FLAGS: KERNEL_FLAGSと同じ

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | git不在 | gitコマンドが見つからない | エラーメッセージ表示、終了 |
| 1 | 非root実行 | root以外のユーザで実行 | エラーメッセージ表示、終了 |
| 1 | CHROOTDIR未設定 | chroot先ディレクトリが未設定 | エラーメッセージ表示、終了 |
| 非0 | ビルド失敗 | buildworld/buildkernel/make release失敗 | make実行のエラーコード返却 |

### リトライ仕様

- CHROOTBUILD_SKIPオプションにより、chroot環境構築をスキップして再実行可能
- SRC_UPDATE_SKIPにより、ソースツリーの更新をスキップ可能

## トランザクション仕様

該当なし。シェルスクリプトによる逐次処理。

## パフォーマンス要件

- 完全なリリースビルドには数時間〜十数時間を要する（CPU/ディスク性能に依存）
- ディスク容量：最低6 GBの/usr/obj空間が必要（完全universe buildには167 GB以上）

## セキュリティ考慮事項

- chroot環境で隔離ビルドを行い、ホストシステムへの影響を防止
- make.conf/src.confを/dev/nullに設定し、非デフォルト設定の混入を防止
- NO_ROOT=1オプションでrootless installをサポート

## 備考

- release.shのVERSIONは3
- 各アーキテクチャ（amd64, arm, arm64, i386, powerpc, riscv）向けのサブディレクトリがrelease/内に存在
- クラウドイメージは各プロバイダ向けのMakefileで定義（Makefile.azure, Makefile.ec2, Makefile.gce, Makefile.oci, Makefile.oracle）
- VMイメージはMakefile.vmで定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リリースビルドスクリプトの全体像を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | release.sh | `release/release.sh` | メインスクリプト。env_setup, env_check, chroot_setup, chroot_build_release等の関数 |

**読解のコツ**: シェルスクリプトであり、関数定義 → 呼び出しの流れで読む。env_setup()(55-127行目)で変数初期化、env_check()(133-206行目)で前提条件確認、chroot_setup()(208-238行目)でchroot環境構築を行う。

#### Step 2: ビルド変数と設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | release.conf.sample | `release/release.conf.sample` | カスタマイズ可能な変数一覧 |

**主要処理フロー**:
- **57行目**: CHROOTDIR="/scratch" デフォルトchroot先
- **72行目**: VCSCMD="/usr/local/bin/git clone -q" ソース取得コマンド
- **76-80行目**: GITROOT, SRCBRANCH, PORTBRANCH, GITSRC, GITPORTS
- **94-96行目**: WORLD_FLAGS, KERNEL_FLAGS, RELEASE_FLAGS の並列ジョブ数計算

#### Step 3: リリースMakefileを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Makefile.inc1 | `release/Makefile.inc1` | リリースビルドの共通Makefile |
| 3-2 | Makefile.vm | `release/Makefile.vm` | 仮想マシンイメージ生成 |
| 3-3 | Makefile.ec2 | `release/Makefile.ec2` | AWS EC2イメージ生成 |

### プログラム呼び出し階層図

```
release.sh
    |
    ├─ env_setup() ─── 変数初期化
    ├─ source release.conf ─── カスタム設定読み込み
    ├─ env_check() ─── 前提条件チェック
    |
    ├─ chroot_setup()
    |     ├─ git clone src ─── ソースツリー取得
    |     ├─ make buildworld ─── ホスト向けworld構築
    |     ├─ make installworld ─── chrootへインストール
    |     └─ make distribution ─── 基本設定ファイル配置
    |
    ├─ extra_chroot_setup()
    |     ├─ mount devfs ─── デバイスFS準備
    |     └─ ldconfig ─── ライブラリキャッシュ更新
    |
    └─ chroot_build_release()
          ├─ make buildworld ─── ターゲット向けworld構築
          ├─ make buildkernel ─── カーネル構築
          └─ make release ─── リリースイメージ生成
                ├─ disc1.iso
                ├─ memstick.img
                ├─ dvd1.iso (WITH_DVD)
                ├─ VM images (WITH_VMIMAGES)
                └─ Cloud images (WITH_CLOUDWARE)
```

### データフロー図

```
[入力]                       [処理]                      [出力]

git repo ──────────▶ chroot_setup ──────────▶ chroot環境
release.conf ──────▶ env_setup/env_check
                          |
chroot環境 ────────▶ buildworld/buildkernel ──▶ /tmp/obj/
                          |
/tmp/obj/ ─────────▶ make release ──────────▶ disc1.iso
                          |                    memstick.img
                          |                    dvd1.iso
                          |                    VM images
                          └──────────────────▶ MANIFEST
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| release.sh | `release/release.sh` | スクリプト | メインリリースビルドスクリプト |
| release.conf.sample | `release/release.conf.sample` | 設定サンプル | カスタム設定ファイルのサンプル |
| Makefile | `release/Makefile` | ビルド | リリースイメージ生成のメインMakefile |
| Makefile.inc1 | `release/Makefile.inc1` | ビルド | 共通変数・ターゲット定義 |
| Makefile.vm | `release/Makefile.vm` | ビルド | 仮想マシンイメージ生成 |
| Makefile.ec2 | `release/Makefile.ec2` | ビルド | AWS EC2イメージ生成 |
| Makefile.gce | `release/Makefile.gce` | ビルド | Google Cloud Engineイメージ生成 |
| Makefile.azure | `release/Makefile.azure` | ビルド | Microsoft Azureイメージ生成 |
| Makefile.oci | `release/Makefile.oci` | ビルド | OCIイメージ生成 |
| Makefile.vagrant | `release/Makefile.vagrant` | ビルド | Vagrant boxイメージ生成 |
| scripts/ | `release/scripts/` | スクリプト | リリースビルド補助スクリプト群 |
| tools/ | `release/tools/` | ツール | リリースビルド補助ツール群 |
