# 機能設計書 106-rescueツール

## 概要

本ドキュメントは、FreeBSDの静的リンクされたレスキューユーティリティ群のビルド機能設計を記述する。/rescueディレクトリに配置される単一バイナリ（crunchgen方式）で、システム障害時の復旧作業に使用される。

### 本機能の処理概要

rescueツールは、crunchgen(1)メカニズムを使用して多数のシステムユーティリティを単一の静的リンクバイナリに統合したレスキュー環境である。共有ライブラリやダイナミックリンカに依存しないため、/usrがマウントできない等の重大なシステム障害時でも基本的な復旧操作が可能である。

**業務上の目的・背景**：システム障害時（ファイルシステム破損、共有ライブラリ破損、/usrマウント不可等）に、最低限のシステム管理・復旧操作を可能にするための緊急ツールセットである。全てのコマンドが単一の静的リンクバイナリに結合されており、/rescueディレクトリからハードリンクで各コマンド名にアクセスできる。

**機能の利用シーン**：ファイルシステム破損時のfsck実行、共有ライブラリ破損時のシステム復旧、シングルユーザモードでの緊急修復作業、/usrマウント不可時の基本操作。

**主要な処理内容**：
1. /bin配下コマンドの静的リンク統合（cat, chmod, cp, date, dd, df, echo, ed, hostname, kill, ln, ls, mkdir, mv, ps, pwd, rm, rmdir, sh, sleep, sync等）
2. /sbin配下コマンドの静的リンク統合（camcontrol, devfs, dmesg, dump, fsck, fsck_ffs, geom, ifconfig, init, kldload, mount, newfs, reboot, route, shutdown, swapon, sysctl, umount等）
3. /usr/bin配下コマンドの統合（vi等、オプション依存）
4. /usr/sbin配下コマンドの統合（chown等、オプション依存）
5. librescueによるライブラリエントリの事前リンク
6. ZFS関連ツールの統合（MK_ZFS有効時：bectl, zfs, zpool, zdb等）
7. ファイアウォールツールの統合（MK_IPFW/MK_PF/MK_IPFILTER有効時）

**関連システム・外部連携**：crunchgen(1)（マルチバイナリ統合ツール）、bsd.crunchgen.mk（ビルドフレームワーク）。

**権限による制御**：/rescueディレクトリのバイナリは通常root所有。多くの管理コマンド（fsck, mount, reboot等）の実行にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | シングルユーザモードまたは緊急シェルからの利用 |

## 機能種別

ビルド生成物 / 緊急復旧ツールセット

## 入力仕様

### 入力パラメータ

ビルド時パラメータ：

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| MK_ZFS | yes/no | No | ZFSツールの組み込み | yes or no |
| MK_IPFW | yes/no | No | IPFWの組み込み | yes or no |
| MK_PF | yes/no | No | PFの組み込み | yes or no |
| MK_IPFILTER | yes/no | No | IPFilterの組み込み | yes or no |
| MK_TCSH | yes/no | No | tcshの組み込み | yes or no |
| MK_INET | yes/no | No | IPv4 pingの組み込み | yes or no |
| MK_INET6 | yes/no | No | IPv6 pingの組み込み | yes or no |

### 入力データソース

- src.opts.mk: ビルドオプション定義
- 各コマンドのソースディレクトリ: bin/, sbin/, usr.bin/, usr.sbin/

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| /rescue/rescue | バイナリ | crunchgen統合された単一静的リンクバイナリ |
| /rescue/* | ハードリンク | rescue バイナリへの各コマンド名ハードリンク |
| /rescue/dhclient-script | スクリプト | DHCPクライアントスクリプト（/rescue/sh用に修正版） |

### 出力先

- /rescue/ ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. librescue ビルド
   └─ 特定ライブラリエントリの再コンパイル（オブジェクトファイル生成）
2. crunchgen 設定生成
   └─ Makefileの CRUNCH_PROGS_bin, CRUNCH_PROGS_sbin 等からcrunchgen設定を自動生成
3. 各コマンドのソースコンパイル
   └─ CRUNCH_BUILDOPTS に -DRESCUE を付与してコンパイル
4. 単一バイナリリンク
   └─ 全オブジェクトを静的リンクして rescue バイナリを生成
5. ハードリンク作成
   └─ 各コマンド名で rescue へのハードリンクを /rescue/ に配置
6. 補助スクリプトインストール
   └─ dhclient-script の修正版をインストール
```

### フローチャート

```mermaid
flowchart TD
    A[ビルド開始] --> B[librescue: ライブラリオブジェクト生成]
    B --> C[crunchgen: 統合設定生成]
    C --> D[各コマンドソースのコンパイル -DRESCUE]
    D --> E[静的リンク: rescue バイナリ生成]
    E --> F[ハードリンク作成: /rescue/*]
    F --> G[dhclient-script インストール]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-106-1 | 静的リンク必須 | NO_SHARED=yes、MK_PIE=no、MK_SSP=noで静的リンクバイナリを生成 | 常時 |
| BR-106-2 | RESCUE定義 | コンパイル時にRESCUEマクロを定義し、不要な動的ライブラリ依存を除去 | 常時 |
| BR-106-3 | 多重定義許容 | lld >= 16では --allow-multiple-definition を指定し、crunchgen統合時のシンボル衝突を許容 | LINKER_VERSION >= 160000 |
| BR-106-4 | エイリアス抑止 | -sh, -csh, -tcsh等のダッシュ付きエイリアスはハードリンクを作成しない | 該当エイリアス |
| BR-106-5 | librescue先行リンク | librescueのオブジェクトを先にリンクし、標準ライブラリのエントリをオーバーライド | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ビルドエラー | コンパイル失敗 | ソースコードのコンパイルエラー | make出力を確認して修正 |
| リンクエラー | リンク失敗 | シンボル未解決等 | CRUNCH_LIBS追加等で対処 |

### リトライ仕様

makeの再実行でインクリメンタルビルドが可能。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 単一バイナリのため、起動時のダイナミックリンカ処理が不要で高速起動
- 静的リンクによりバイナリサイズは大きくなるが、復旧シナリオでは許容範囲

## セキュリティ考慮事項

- /rescueバイナリはroot所有で配置される
- 静的リンクにより、共有ライブラリの改竄攻撃に対する耐性がある
- ASLR/PIEは無効（MK_PIE=no）のため、セキュリティ強化は制限的

## 備考

- argv[0]の名前に基づいてどのコマンドとして動作するか決定する（crunchgenの標準動作）
- 特定エイリアス（test -> [、pkill -> pgrep、ln -> link、rm -> unlink、ed -> red）が定義されている
- ZFS有効時は多数の追加ライブラリ（libzpool, libzfs, libicp等）がリンクされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビルド構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `rescue/rescue/Makefile` | 統合対象コマンドの一覧、CRUNCH_PROGS定義、CRUNCH_LIBS定義 |

**読解のコツ**: Makefileの構造はCRUNCH_SRCDIRS（ソースディレクトリ）、CRUNCH_PROGS_xxx（各ディレクトリのプログラム一覧）、CRUNCH_ALIAS_xxx（エイリアス定義）、CRUNCH_LIBS（追加ライブラリ）のセクションに分かれる。条件付きビルド(.if ${MK_ZFS}等)を確認すること。

#### Step 2: /bin コマンドの統合対象を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Makefile | `rescue/rescue/Makefile` | CRUNCH_PROGS_bin（56-59行目） |

**主要処理フロー**:
- **56-59行目**: cat, chflags, chio, chmod, cp, date, dd, df, echo, ed, expr, getfacl, hostname, kenv, kill, ln, ls, mkdir, mv, pkill, ps, pwd, realpath, rm, rmdir, setfacl, sh, sleep, stty, sync, test
- **64-71行目**: エイリアス定義（test->[, sh->-sh, ln->link, rm->unlink, ed->red, pkill->pgrep）

#### Step 3: /sbin コマンドの統合対象を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Makefile | `rescue/rescue/Makefile` | CRUNCH_PROGS_sbin（91-101行目） |

**主要処理フロー**:
- **91-101行目**: camcontrol, clri, devfs, dmesg, dump, dumpfs, dumpon, fsck, fsck_ffs, fsck_msdosfs, fsdb, fsirand, geom, ifconfig, init, kldconfig, kldload, kldstat, kldunload, ldconfig, md5, mdconfig, mdmfs, mknod, mount, mount_cd9660, mount_msdosfs, mount_nfs, mount_nullfs, mount_udf, mount_unionfs, newfs, newfs_msdos, nos-tun, reboot, restore, rcorder, route, savecore, shutdown, swapon, sysctl, tunefs, umount

#### Step 4: 条件付きコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Makefile | `rescue/rescue/Makefile` | ZFS/IPFW/PF/IPFILTER条件分岐（103-140行目） |

**主要処理フロー**:
- **107-109行目**: MK_INET/MK_INET6有効時にping追加
- **116-123行目**: MK_IPFILTER/MK_IPFW/MK_PF有効時にファイアウォールツール追加
- **134-140行目**: MK_ZFS有効時にbectl, zfs, zpool, zdb追加

### プログラム呼び出し階層図

```
rescue/Makefile
    |
    ├─ rescue/librescue/Makefile ─── ライブラリオブジェクト生成
    |
    └─ rescue/rescue/Makefile
          |
          ├─ bsd.crunchgen.mk ─── crunchgen統合フレームワーク
          |     |
          |     ├─ crunchgen ─── 統合ソース生成
          |     └─ cc -static ─── 静的リンク
          |
          ├─ CRUNCH_PROGS_bin ─── bin/cat, bin/sh, ...
          ├─ CRUNCH_PROGS_sbin ─── sbin/fsck, sbin/mount, ...
          ├─ CRUNCH_PROGS_usr.bin ─── usr.bin/vi, ...
          └─ CRUNCH_PROGS_usr.sbin ─── usr.sbin/chown, ...
```

### データフロー図

```
[入力]                      [処理]                      [出力]

各コマンドの ────────▶ crunchgen ──────────▶ 統合ソースコード
ソースコード                  |
                              |
librescue ──────────▶ cc -static ─────────▶ /rescue/rescue
オブジェクト                  |                  (単一バイナリ)
                              |
CRUNCH_LIBS ────────▶ ld (static link)
                              |
                         ハードリンク作成 ──▶ /rescue/sh
                                              /rescue/fsck
                                              /rescue/mount
                                              ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `rescue/rescue/Makefile` | ビルド | 統合対象コマンドの定義、ビルドオプション |
| Makefile | `rescue/librescue/Makefile` | ビルド | rescueオーバーライドライブラリのビルド |
| Makefile | `rescue/Makefile` | ビルド | トップレベルMakefile |
| README | `rescue/README` | ドキュメント | rescueシステムの説明 |
| bsd.crunchgen.mk | `share/mk/bsd.crunchgen.mk` | ビルド | crunchgen統合のMakefileフレームワーク |
