# 機能設計書 107-ビルドシステム

## 概要

本ドキュメントは、FreeBSDのMakefileベースのビルドインフラストラクチャの機能設計を記述する。トップレベルMakefile、Makefile.inc1、share/mk/配下のMakefileフラグメント群により、FreeBSDシステム全体のビルドを制御する。

### 本機能の処理概要

FreeBSDビルドシステムは、bmake(1)（BSD make）をベースとした階層的なMakefileインフラストラクチャである。share/mk/配下のMakefileフラグメント（bsd.prog.mk, bsd.lib.mk, bsd.subdir.mk等）が標準的なビルドパターンを提供し、各コンポーネントのMakefileはこれらを.includeで取り込んで使用する。

**業務上の目的・背景**：FreeBSDはソースツリーからシステム全体を再構築可能な「自己ホスティング」OSであり、この特性を支えるのがビルドシステムである。buildworld/buildkernelターゲットにより、ツールチェーンの構築からカーネル・ユーザランド全体の構築まで一貫したビルドパイプラインを提供する。クロスコンパイル、段階的ビルド、オプション管理（src.conf）も統一的に処理される。

**機能の利用シーン**：FreeBSDソースからのシステム全体ビルド（buildworld/installworld）、カーネルの再構築（buildkernel/installkernel）、個別コンポーネントのビルド、クロスコンパイル（xdev）、ユニバースビルド（universe：全アーキテクチャ向け一括ビルド）。

**主要な処理内容**：
1. buildworld: ユーザランド全体の構築（ツールチェーン含む）
2. installworld: 構築されたユーザランドのインストール
3. buildkernel: カーネルとカーネルモジュールの構築
4. installkernel: カーネルのインストール
5. universe: 全アーキテクチャ向けの一括ビルド
6. tinderbox: universeビルドの失敗検出
7. check-old / delete-old: 不要ファイルの検出・削除
8. ELF hardening（PIE, RELRO, BIND_NOW, retpoline, branch protection）
9. src.confによるビルドオプション制御
10. クロスコンパイルツールチェーン（xdev / native-xtools）

**関連システム・外部連携**：bmake(1)、Clang/LLVM（コンパイラ）、lld（リンカ）、各コンポーネントのMakefile。

**権限による制御**：buildworldは一般ユーザでも実行可能（/usr/obj配下に出力）。installworld/installkernelはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | makeコマンドによるビルド実行 |

## 機能種別

ビルドインフラストラクチャ / 自動化フレームワーク

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TARGET | 文字列 | No | ターゲットアーキテクチャ（デフォルトはホスト） | amd64, arm, arm64, i386, powerpc, riscv |
| TARGET_ARCH | 文字列 | No | ターゲットCPUアーキテクチャ | 対応するCPUアーキテクチャ |
| KERNCONF | 文字列 | No | カーネル設定名（デフォルトGENERIC） | 有効な設定名 |
| DESTDIR | ディレクトリ | No | インストール先ディレクトリ | 有効なパス |
| MAKEOBJDIRPREFIX | ディレクトリ | No | オブジェクトファイル出力先プレフィックス | 有効なパス |
| -j N | 整数 | No | 並列ジョブ数 | 正の整数 |
| __MAKE_CONF | ファイルパス | No | make.confのパス | 有効なファイルパス |
| SRCCONF | ファイルパス | No | src.confのパス | 有効なファイルパス |

### 入力データソース

- Makefile: トップレベルMakefile
- Makefile.inc1: メインビルドロジック
- share/mk/*.mk: Makefileフラグメント群
- src.conf / make.conf: ビルドオプション設定
- sys/conf/: カーネル設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| /usr/obj/ | ディレクトリ | ビルドオブジェクトファイル群 |
| カーネル | バイナリ | /boot/kernel/kernel |
| カーネルモジュール | バイナリ群 | /boot/kernel/*.ko |
| ユーザランドバイナリ | バイナリ群 | /bin/, /sbin/, /usr/bin/, /usr/sbin/ 等 |
| ライブラリ | 共有ライブラリ | /lib/, /usr/lib/ 等 |

### 出力先

- ${MAKEOBJDIRPREFIX}（ビルド中間ファイル）
- ${DESTDIR}（インストール先、デフォルトは/）

## 処理フロー

### 処理シーケンス

```
1. buildworld フェーズ
   ├─ bootstrap-tools: ホスト上でブートストラップツール構築
   ├─ cross-tools: クロスコンパイラ・ツールチェーン構築
   ├─ build-tools: ビルドに必要なツール構築
   ├─ libraries: 共有ライブラリ構築
   └─ everything: 全ユーザランドコンポーネント構築
2. installworld フェーズ
   ├─ インストール先ディレクトリ作成
   └─ 構築済みバイナリ・ライブラリのインストール
3. buildkernel フェーズ
   ├─ カーネル設定ファイル解析
   ├─ カーネルコンパイル
   └─ カーネルモジュールコンパイル
4. installkernel フェーズ
   ├─ 既存カーネルのバックアップ
   └─ 新カーネル・モジュールのインストール
```

### フローチャート

```mermaid
flowchart TD
    A[make buildworld] --> B[bootstrap-tools]
    B --> C[cross-tools]
    C --> D[build-tools]
    D --> E[libraries]
    E --> F[everything]
    F --> G[make installworld]
    G --> H[ディレクトリ作成]
    H --> I[バイナリインストール]
    I --> J[make buildkernel]
    J --> K[カーネル設定解析]
    K --> L[カーネルコンパイル]
    L --> M[モジュールコンパイル]
    M --> N[make installkernel]
    N --> O[旧カーネルバックアップ]
    O --> P[新カーネルインストール]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-1 | PIE有効化 | MK_PIE != noの場合、位置独立実行ファイル（-fPIE / -pie）を生成 | 動的リンク時 |
| BR-107-2 | RELRO有効化 | MK_RELRO != noの場合、GOT保護（-Wl,-zrelro）を適用 | 非macリンカ時 |
| BR-107-3 | BIND_NOW | MK_BIND_NOW != noの場合、即時バインド（-Wl,-znow）を適用 | 常時 |
| BR-107-4 | retpoline | MK_RETPOLINE != noかつコンパイラ/リンカサポート時、Spectre V2対策を適用 | 対応環境時 |
| BR-107-5 | branch protection | MK_BRANCH_PROTECTION != noの場合、ARM BTI/PAC保護を適用 | ARM環境時 |
| BR-107-6 | スタック初期化 | OPT_INIT_ALL設定時、スタック変数の自動初期化を適用 | コンパイラサポート時 |
| BR-107-7 | noexecstack | LLDのデフォルトに合わせBFDでも-znoexecstackを適用 | BFDリンカ時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | コンパイルエラー | ソースコードのコンパイル失敗 | エラーメッセージを確認して修正 |
| 非0 | リンクエラー | シンボル未解決、ライブラリ不足 | 依存関係を確認して修正 |
| 非0 | インストールエラー | 権限不足、ディスク容量不足 | 権限/容量を確認 |

### リトライ仕様

makeの再実行でインクリメンタルビルドが可能。-DNO_CLEANオプションで前回のビルドから再開可能。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- buildworldの所要時間はCPU数・ディスク速度に大きく依存
- -j Nオプションで並列ビルドが可能
- SSD使用を推奨（大量のファイルI/Oが発生）

## セキュリティ考慮事項

- PIE (Position Independent Executables)によるASLR対応
- RELRO (Relocation Read-Only)によるGOT保護
- BIND_NOWによる遅延バインド無効化（GOT overwrite攻撃対策）
- retpolineによるSpectre V2対策
- Branch Protection (ARM BTI/PAC)対応
- スタック変数の自動初期化（init-all）対応

## 備考

- FreeBSDビルドシステムは/usr/share/mk/sys.mkを起点として動作
- share/mk/ディレクトリに約100以上のMakefileフラグメントが存在
- src.conf(5)マニュアルでビルドオプションの全一覧が参照可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: トップレベルMakefileを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `Makefile` | 利用可能ターゲット一覧、ビルドの全体構造の説明コメント |

**読解のコツ**: トップレベルMakefile(1-80行目)は主にコメントで構成されており、buildworld, installworld, buildkernel, installkernel, universe等の主要ターゲットの説明がある。実際のビルドロジックはMakefile.inc1に委譲される。

#### Step 2: プログラムビルドの標準パターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bsd.prog.mk | `share/mk/bsd.prog.mk` | 標準プログラムビルドのMakefileフラグメント |

**主要処理フロー**:
- **3-6行目**: bsd.init.mk, bsd.compiler.mk, bsd.linker.mkのインクルード
- **24-33行目**: ELF hardening（BIND_NOW, RELRO）
- **35-42行目**: PIE設定（-fPIE / -pie）
- **43-56行目**: retpoline設定
- **59-64行目**: branch protection設定
- **67-80行目**: スタック変数初期化設定

### プログラム呼び出し階層図

```
Makefile (トップレベル)
    |
    └─ Makefile.inc1
          |
          ├─ bootstrap-tools ──── ホストツール構築
          ├─ cross-tools ──────── クロスツールチェーン
          ├─ build-tools ──────── ビルドツール
          ├─ libraries ────────── 共有ライブラリ
          └─ everything ────────── 全コンポーネント
                |
                ├─ share/mk/bsd.prog.mk ──── プログラムビルド
                ├─ share/mk/bsd.lib.mk ───── ライブラリビルド
                ├─ share/mk/bsd.subdir.mk ── サブディレクトリ走査
                └─ share/mk/bsd.obj.mk ───── オブジェクトディレクトリ管理
```

### データフロー図

```
[入力]                       [処理]                      [出力]

ソースコード ──────▶ bsd.compiler.mk ──▶ コンパイラ選択
src.conf ──────────▶ src.opts.mk ─────▶ ビルドオプション
                          |
                    bsd.prog.mk ────────▶ プログラムバイナリ
                    bsd.lib.mk ─────────▶ 共有ライブラリ
                          |
                    Makefile.inc1 ──────▶ /usr/obj/
                          |               (中間ファイル)
                    installworld ───────▶ ${DESTDIR}/
                                          (インストール先)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `Makefile` | ビルド | トップレベルMakefile |
| Makefile.inc1 | `Makefile.inc1` | ビルド | メインビルドロジック |
| bsd.prog.mk | `share/mk/bsd.prog.mk` | ビルド | プログラムビルドの標準パターン |
| bsd.lib.mk | `share/mk/bsd.lib.mk` | ビルド | ライブラリビルドの標準パターン |
| bsd.subdir.mk | `share/mk/bsd.subdir.mk` | ビルド | サブディレクトリ走査 |
| bsd.obj.mk | `share/mk/bsd.obj.mk` | ビルド | オブジェクトディレクトリ管理 |
| bsd.compiler.mk | `share/mk/bsd.compiler.mk` | ビルド | コンパイラ検出・設定 |
| bsd.linker.mk | `share/mk/bsd.linker.mk` | ビルド | リンカ検出・設定 |
| src.opts.mk | `share/mk/src.opts.mk` | ビルド | ソースビルドオプション定義 |
| bsd.init.mk | `share/mk/bsd.init.mk` | ビルド | 初期化処理 |
| bsd.crunchgen.mk | `share/mk/bsd.crunchgen.mk` | ビルド | crunchgen統合ビルド |
