# 機能設計書 108-リグレッションテスト

## 概要

本ドキュメントは、FreeBSDのKyuaテストフレームワークによるリグレッションテスト群の機能設計を記述する。tests/ディレクトリ配下に配置されたテストスイートにより、FreeBSDの各機能の品質を継続的に検証する。

### 本機能の処理概要

FreeBSDのリグレッションテストは、Kyua（テストフレームワーク）とATF（Automated Testing Framework）を基盤として構築されたテストスイートである。カーネル機能、ライブラリ関数、コマンド群の正常動作を自動的に検証する。

**業務上の目的・背景**：FreeBSDの開発において、コードの変更が既存機能に影響を与えないことを確認するリグレッションテストは品質保証の基盤である。Kyuaテストフレームワークにより、テストの実行・結果収集・レポート生成を自動化し、継続的インテグレーション（CI）環境での活用を可能にしている。

**機能の利用シーン**：開発者がコード変更後に影響範囲のテストを実行する場合、CIパイプラインで自動テストを実行する場合、リリース前の品質確認テスト、FreeBSD開発者コミュニティでのテスト結果共有。

**主要な処理内容**：
1. Kyuafileによるテストスイートの階層的な定義
2. ATFテストケースの実行（C/C++/sh）
3. Pythonベースのテストケース実行（atf_python）
4. カーネルテスト（sys/配下：ネットワーク、ファイルシステム、仮想メモリ等）
5. ライブラリテスト（lib/配下：libc、libpthread等）
6. コマンドテスト（bin/、sbin/、usr.bin/、usr.sbin/配下）
7. テスト結果のレポート生成
8. conftest.pyによるテスト設定の共通化

**関連システム・外部連携**：Kyua（テストランナー）、ATF（テストフレームワーク）、Python（atf_python）、CI/CDシステム。

**権限による制御**：多くのカーネルテスト（ネットワーク設定変更、ファイルシステム操作等）にはroot権限が必要。ライブラリテストの一部は一般ユーザでも実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | kyuaコマンドによるテスト実行 |

## 機能種別

テストフレームワーク / 品質保証 / 自動テスト

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| kyua test | コマンド | Yes | テストスイートの実行 | なし |
| kyua report | コマンド | No | テスト結果レポートの生成 | なし |
| -k Kyuafile | ファイルパス | No | テスト定義ファイルの指定 | 有効なKyuafile |
| --filter | テスト名 | No | 実行するテストのフィルタ | 有効なテスト名パターン |

### 入力データソース

- Kyuafile: テストスイートの階層定義
- ATFテストプログラム: C/C++/シェルスクリプトで記述されたテストケース
- conftest.py: Pythonテストの共通設定
- テストデータファイル: 各テストが使用する入力データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テスト結果 | テキスト | passed/failed/skipped/broken の結果表示 |
| テストレポート | HTML/テキスト | Kyuaレポート形式のテスト結果サマリー |
| テストログ | テキスト | 各テストケースの詳細実行ログ |

### 出力先

- 標準出力（テスト結果サマリー）
- ~/.kyua/store/（テスト結果データベース）
- レポートファイル（kyua report出力時）

## 処理フロー

### 処理シーケンス

```
1. テストスイート発見
   └─ Kyuafileの再帰的読み込みによるテストプログラム列挙
2. テスト環境準備
   └─ テストごとの一時ディレクトリ作成、環境変数設定
3. テストケース実行
   ├─ ATF C/C++テスト: atf-run経由で実行
   ├─ ATFシェルテスト: atf-sh経由で実行
   └─ Pythonテスト: atf_python経由で実行
4. 結果収集
   └─ 各テストの結果(passed/failed/skipped)をKyuaデータベースに格納
5. レポート生成
   └─ kyua reportコマンドで集約レポートを出力
```

### フローチャート

```mermaid
flowchart TD
    A[kyua test 実行] --> B[Kyuafile読み込み]
    B --> C[テストプログラム列挙]
    C --> D{テストタイプ判定}
    D -->|ATF C/C++| E[atf-run 経由実行]
    D -->|ATF Shell| F[atf-sh 経由実行]
    D -->|Python| G[atf_python 経由実行]
    E --> H[結果収集]
    F --> H
    G --> H
    H --> I{全テスト完了?}
    I -->|No| D
    I -->|Yes| J[結果サマリー表示]
    J --> K[kyua report でレポート生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-108-1 | Kyuafile自動発見 | 各サブディレクトリのKyuafileを自動的に発見して再帰的にテストを組み込む | 常時 |
| BR-108-2 | テスト隔離 | 各テストケースは独立した一時ディレクトリで実行され、他のテストに影響しない | 常時 |
| BR-108-3 | 結果分類 | テスト結果はpassed（成功）、failed（失敗）、skipped（スキップ）、broken（テスト自体の問題）に分類 | 常時 |
| BR-108-4 | syntax(2) | Kyuafileはsyntax(2)形式で記述 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| kyua test | Kyuaストア | INSERT | テスト結果をSQLiteデータベースに格納 |
| kyua report | Kyuaストア | SELECT | テスト結果を読み込んでレポート生成 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| failed | テスト失敗 | テストアサーション失敗 | テスト対象コードまたはテストケースを修正 |
| broken | テスト破損 | テストプログラム自体のエラー | テストプログラムを修正 |
| skipped | テストスキップ | 前提条件不足（権限不足等） | 必要な権限/環境を整備 |

### リトライ仕様

kyuaコマンドの再実行でテストを再実行可能。特定テストのみを--filterで指定して再実行可能。

## トランザクション仕様

該当なし。Kyuaストアへの結果格納はKyuaが内部的に管理する。

## パフォーマンス要件

- 全テストスイートの実行には相当な時間を要する（テスト数とシステム性能に依存）
- 個別テストケースにはタイムアウトが設定されている

## セキュリティ考慮事項

- カーネルテストの一部はroot権限が必要であり、テスト環境のセキュリティに注意が必要
- テストはシステム設定を変更する場合があり（ネットワーク設定、ファイルシステム操作等）、本番環境での実行には注意

## 備考

- tests/ディレクトリは大規模で、カーネル、ライブラリ、コマンドの広範なテストを含む
- atf_pythonモジュール（tests/atf_python/）はPythonベースのテスト記述を支援する
- CIスクリプト（tests/ci/）が継続的インテグレーション環境での実行をサポート
- conftest.py（tests/conftest.py）がテストの共通設定を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テストフレームワークの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Kyuafile | `tests/Kyuafile` | トップレベルKyuafile。syntax(2)形式、サブディレクトリ自動発見ロジック |

**読解のコツ**: Kyuafile(38-51行目)はLua風の構文。syntax(2)でバージョン指定、fs.files()でディレクトリ走査、fs.exists()でKyuafile存在チェック、include()でサブテスト組み込みを行う。このパターンは再帰的にサブディレクトリに適用される。

#### Step 2: テスト設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | conftest.py | `tests/conftest.py` | Pythonテストの共通設定 |
| 2-2 | Makefile | `tests/Makefile` | テストビルドのトップレベルMakefile |

#### Step 3: テストカテゴリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sys/ | `tests/sys/` | カーネルテスト群 |
| 3-2 | examples/ | `tests/examples/` | テスト記述例 |
| 3-3 | freebsd_test_suite/ | `tests/freebsd_test_suite/` | FreeBSD固有テストスイート |

#### Step 4: Pythonテストフレームワークを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | __init__.py | `tests/atf_python/` | atf_pythonパッケージ |

### プログラム呼び出し階層図

```
kyua test
    |
    ├─ tests/Kyuafile (トップレベル)
    |     |
    |     ├─ tests/sys/Kyuafile ──── カーネルテスト
    |     |     ├─ net/ ──── ネットワークテスト
    |     |     ├─ fs/ ──── ファイルシステムテスト
    |     |     └─ vm/ ──── 仮想メモリテスト
    |     |
    |     ├─ tests/etc/Kyuafile ──── 設定ファイルテスト
    |     |
    |     └─ tests/examples/Kyuafile ── テスト例
    |
    ├─ ATF C/C++ テスト ──── atf-run
    ├─ ATF Shell テスト ──── atf-sh
    └─ Python テスト ─────── atf_python
```

### データフロー図

```
[入力]                    [処理]                      [出力]

Kyuafile ──────────▶ kyua (テストランナー) ──▶ テスト結果
テストプログラム                |                     |
テストデータ                   |               ~/.kyua/store/
                               |               (SQLite DB)
                          ATF フレームワーク          |
                               |               kyua report ──▶ レポート
                          テスト実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Kyuafile | `tests/Kyuafile` | テスト定義 | トップレベルテストスイート定義 |
| conftest.py | `tests/conftest.py` | テスト設定 | Pythonテストの共通設定 |
| Makefile | `tests/Makefile` | ビルド | テストビルドのトップレベルMakefile |
| Makefile.inc0 | `tests/Makefile.inc0` | ビルド | テストビルド共通設定 |
| README | `tests/README` | ドキュメント | テストフレームワークの説明 |
| __init__.py | `tests/__init__.py` | Python | Pythonパッケージ初期化 |
| atf_python/ | `tests/atf_python/` | Python | ATF Pythonテストフレームワーク |
| ci/ | `tests/ci/` | スクリプト | CI実行スクリプト群 |
| sys/ | `tests/sys/` | テスト | カーネルテスト群 |
| examples/ | `tests/examples/` | テスト | テスト記述例 |
