# 機能設計書 109-manページ

## 概要

本ドキュメントは、FreeBSDのオンラインマニュアルページ（manページ）システムの機能設計を記述する。share/man/ディレクトリ配下に配置されたマニュアルページソースにより、FreeBSDの各コマンド・ライブラリ・システムコール・ファイル形式等のリファレンスドキュメントを提供する。

### 本機能の処理概要

FreeBSDのmanページシステムは、mdoc(7)マクロ形式で記述されたマニュアルページソースをshare/man/ディレクトリに集約管理する。各セクション（man1〜man9）に分類された数千のマニュアルページが、FreeBSDの全コンポーネントのリファレンスドキュメントを構成する。

**業務上の目的・背景**：UNIXシステムの伝統において、manページはシステムの公式リファレンスドキュメントであり、コマンドの使用方法、ライブラリ関数のAPI仕様、システムコールのインタフェース仕様、設定ファイルの形式等を記述する最も信頼性の高い情報源である。FreeBSDではmdoc(7)マクロによるセマンティックマークアップを採用し、一貫した形式でドキュメントを管理している。

**機能の利用シーン**：man(1)コマンドによるオンラインリファレンス参照、apropos(1)によるキーワード検索、mandoc(1)によるHTML/PDF出力、bsdinstallでのドキュメントパッケージインストール。

**主要な処理内容**：
1. man1: ユーザコマンドのマニュアル
2. man3: ライブラリ関数のマニュアル
3. man3lua: Luaライブラリバインディングのマニュアル
4. man4: デバイスドライバ・プロトコルのマニュアル
5. man5: ファイル形式・プロトコルのマニュアル
6. man6: ゲームのマニュアル
7. man7: 各種情報（プロトコル、規約等）のマニュアル
8. man8: システム管理コマンドのマニュアル
9. man9: カーネル開発者向けインタフェースのマニュアル
10. mdoc(7)マクロによるセマンティックマークアップ

**関連システム・外部連携**：man(1)（マニュアルビューア）、mandoc(1)（マニュアルフォーマッタ）、apropos(1)（キーワード検索）、makewhatis(8)（whatis DB構築）。

**権限による制御**：manページの参照は一般ユーザでも可能。manページのインストールにはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ドキュメントインストール画面 | 補助機能 | Handbook・FAQ・記事等のドキュメントセット内容 |

## 機能種別

ドキュメント管理 / リファレンスシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| man [section] name | 文字列 | Yes | 参照するマニュアルページ名とセクション | 有効なマニュアル名 |
| man -k keyword | 文字列 | No | キーワードによるマニュアル検索 | 任意の文字列 |

### 入力データソース

- share/man/man[1-9]/: mdoc(7)形式のマニュアルページソース
- 各コンポーネントディレクトリ配下のマニュアルページ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーマット済みマニュアル | テキスト | mandoc(1)でフォーマットされたマニュアルページ |
| whatisデータベース | バイナリ | キーワード検索用インデックス |
| HTML出力 | HTML | mandoc -Thtmlによるウェブ形式出力 |

### 出力先

- 標準出力（ページャ経由）
- /usr/share/man/（インストール先）
- /usr/share/man/whatis（検索データベース）

## 処理フロー

### 処理シーケンス

```
1. マニュアルページのビルド
   └─ share/man/Makefile経由で各セクションのマニュアルをインストール
2. whatisデータベース構築
   └─ makewhatis(8)でキーワード検索用インデックスを生成
3. マニュアル参照
   ├─ man(1)コマンドでセクション・名前を指定
   ├─ mandoc(1)でmdocソースをフォーマット
   └─ ページャ（less等）で表示
4. キーワード検索
   └─ apropos(1) / man -k でwhatisデータベースを検索
```

### フローチャート

```mermaid
flowchart TD
    A[share/man/man*/*.mdoc ソース] --> B[make install]
    B --> C[/usr/share/man/ にインストール]
    C --> D[makewhatis: whatisDB構築]
    D --> E{参照方法}
    E -->|man name| F[mandoc フォーマット]
    E -->|man -k keyword| G[whatis DB検索]
    F --> H[ページャ表示]
    G --> I[一致するマニュアル一覧]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-109-1 | セクション分類 | man1=コマンド, man3=ライブラリ, man4=デバイス, man5=ファイル形式, man7=情報, man8=管理コマンド, man9=カーネルAPI | 常時 |
| BR-109-2 | mdoc形式 | マニュアルページはmdoc(7)セマンティックマクロで記述 | 常時 |
| BR-109-3 | MANPATHの検索順序 | man(1)は/usr/share/man、/usr/local/share/man等のMANPATHを順に検索 | man参照時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| makewhatis | whatis DB | CREATE | マニュアル名・説明のインデックス構築 |
| apropos / man -k | whatis DB | SELECT | キーワードによる検索 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| "No manual entry" | マニュアル不在 | 指定名のマニュアルが存在しない | セクション指定を確認、approposで検索 |
| mdoc警告 | フォーマット警告 | mdocマクロの使用方法に問題 | mandoc -Tlintで検証して修正 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 個別マニュアルの表示はmandoc処理時間（通常ミリ秒オーダー）
- whatisデータベースの構築は全マニュアルの走査が必要

## セキュリティ考慮事項

- manページ自体にセキュリティリスクはない
- mandocのパーサにおける入力バリデーションは実装済み

## 備考

- FreeBSDはmdoc(7)マクロを標準マニュアル記述形式として採用しており、man(7)マクロ形式のマニュアルも処理可能
- man3luaセクションはLua言語バインディングのドキュメント用の拡張セクション
- share/man/以外に、各コンポーネントのソースディレクトリにもマニュアルページが配置されている（ビルド時に統合される）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ディレクトリ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `share/man/Makefile` | マニュアルセクションのビルド・インストール定義 |
| 1-2 | man1/ | `share/man/man1/` | ユーザコマンドマニュアル |
| 1-3 | man4/ | `share/man/man4/` | デバイスドライバマニュアル |

**読解のコツ**: share/man/は共通のマニュアルページを集約するディレクトリであり、各コンポーネント固有のマニュアルは各ソースディレクトリのMakefileからMAN変数で指定される。man1からman9のセクション番号の意味を理解することが重要。

#### Step 2: マニュアルページの記述形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | 任意の.1/.3/.4/.5/.7/.8/.9ファイル | `share/man/man*/` | mdoc(7)マクロの実際の使用例 |

**主要処理フロー**:
- `.Dd`: ドキュメント日付
- `.Dt`: ドキュメントタイトル（コマンド名 セクション番号）
- `.Os`: オペレーティングシステム名
- `.Sh NAME`, `.Sh SYNOPSIS`, `.Sh DESCRIPTION`: 標準セクション

#### Step 3: ビルドシステムとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bsd.man.mk | `share/mk/bsd.man.mk` | マニュアルページのビルド・インストールルール |

### プログラム呼び出し階層図

```
share/man/Makefile
    |
    ├─ share/man/man1/Makefile ──── セクション1マニュアル
    ├─ share/man/man3/Makefile ──── セクション3マニュアル
    ├─ share/man/man3lua/Makefile ─ Luaバインディングマニュアル
    ├─ share/man/man4/Makefile ──── セクション4マニュアル
    ├─ share/man/man5/Makefile ──── セクション5マニュアル
    ├─ share/man/man6/Makefile ──── セクション6マニュアル
    ├─ share/man/man7/Makefile ──── セクション7マニュアル
    ├─ share/man/man8/Makefile ──── セクション8マニュアル
    └─ share/man/man9/Makefile ──── セクション9マニュアル

[各コンポーネント]
    |
    └─ Makefile (MAN=xxx.1) ──── コンポーネント固有マニュアル
```

### データフロー図

```
[入力]                     [処理]                    [出力]

mdoc(7)ソース ─────▶ make install ──────▶ /usr/share/man/man*/
                          |
                    makewhatis ──────────▶ /usr/share/man/whatis
                          |
ユーザ入力 ────────▶ man(1) ──▶ mandoc ──▶ ページャ表示
(man コマンド)                              (less/more)
                          |
ユーザ入力 ────────▶ apropos ──────────▶ 検索結果表示
(man -k キーワード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `share/man/Makefile` | ビルド | マニュアルページのトップレベルMakefile |
| man1/ | `share/man/man1/` | ドキュメント | ユーザコマンドマニュアル |
| man3/ | `share/man/man3/` | ドキュメント | ライブラリ関数マニュアル |
| man3lua/ | `share/man/man3lua/` | ドキュメント | Luaバインディングマニュアル |
| man4/ | `share/man/man4/` | ドキュメント | デバイス・プロトコルマニュアル |
| man5/ | `share/man/man5/` | ドキュメント | ファイル形式マニュアル |
| man6/ | `share/man/man6/` | ドキュメント | ゲームマニュアル |
| man7/ | `share/man/man7/` | ドキュメント | 情報・規約マニュアル |
| man8/ | `share/man/man8/` | ドキュメント | システム管理マニュアル |
| man9/ | `share/man/man9/` | ドキュメント | カーネルAPIマニュアル |
| bsd.man.mk | `share/mk/bsd.man.mk` | ビルド | マニュアルビルド・インストールルール |
