# 機能設計書 110-国際化・地域化

## 概要

本ドキュメントは、FreeBSDの国際化（i18n）・地域化（l10n）機能の設計を記述する。ロケール定義、文字コード変換テーブル、照合順序定義、通貨形式定義等を含む。

### 本機能の処理概要

FreeBSDの国際化・地域化機能は、share/i18n/（文字コード変換マッピング・エンコーディングスキームデータベース）、share/colldef/（照合順序定義）、share/monetdef/（通貨形式定義）等のデータファイル群により、多言語対応のシステム環境を提供する。

**業務上の目的・背景**：FreeBSDは世界中で使用されるOSであり、各国・各言語のユーザが自国の言語・文字・通貨形式・照合順序等を使用できる環境が必要である。国際化（internationalization: i18n）は多言語対応の基盤を提供し、地域化（localization: l10n）は特定の言語・地域向けのデータを提供する。iconv(3)による文字コード変換、setlocale(3)によるロケール設定等のlibc機能の基盤データを提供する。

**機能の利用シーン**：システムのロケール設定（日本語、中国語、韓国語、ヨーロッパ諸語等）、文字コード変換（UTF-8、ISO-8859、EUC、Shift_JIS等の相互変換）、キーボードレイアウトの選択（bsdinstall経由）、無線LAN規制ドメインの国コード選択。

**主要な処理内容**：
1. csmapper（文字コード変換マッピング）：各種文字エンコーディング間の変換テーブル定義
2. esdb（エンコーディングスキームデータベース）：文字エンコーディングの仕様定義
3. colldef（照合順序定義）：各ロケールの文字照合（ソート）順序の定義
4. monetdef（通貨形式定義）：各ロケールの通貨表示形式の定義
5. iconv(3)ライブラリへのデータ供給
6. setlocale(3)によるロケール切替基盤
7. キーボードレイアウト定義データの提供

**関連システム・外部連携**：libc（setlocale, iconv, strftime等）、bsdinstall（キーマップ選択、無線LAN国コード選択）、terminal（端末の文字表示）。

**権限による制御**：ロケールデータの参照は一般ユーザでも可能。ロケールデータのインストール・更新にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | キーマップ選択画面 | 補助機能 | キーマップ定義ファイルの参照によるキーボードレイアウト一覧の生成 |
| 7 | 無線LAN設定画面 | 補助機能 | 無線LAN規制ドメイン・国コード選択処理 |

## 機能種別

データ管理 / 変換テーブル / ロケール定義

## 入力仕様

### 入力パラメータ

ロケール設定時：

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LANG | 環境変数 | No | ロケール名（例：ja_JP.UTF-8） | 有効なロケール名 |
| LC_ALL | 環境変数 | No | 全カテゴリのロケール上書き | 有効なロケール名 |
| LC_CTYPE | 環境変数 | No | 文字分類ロケール | 有効なロケール名 |
| LC_COLLATE | 環境変数 | No | 照合順序ロケール | 有効なロケール名 |
| LC_MONETARY | 環境変数 | No | 通貨形式ロケール | 有効なロケール名 |

### 入力データソース

- share/i18n/csmapper/: 文字コード変換マッピングソースファイル群
- share/i18n/esdb/: エンコーディングスキームデータベースソースファイル群
- share/colldef/: 照合順序定義ソースファイル群
- share/monetdef/: 通貨形式定義ソースファイル群

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 文字コード変換テーブル | バイナリ | iconv(3)が使用する変換テーブル |
| エンコーディング定義 | バイナリ | エンコーディングスキーム仕様 |
| 照合順序データ | バイナリ | LC_COLLATEデータ |
| 通貨形式データ | バイナリ | LC_MONETARYデータ |

### 出力先

- /usr/share/i18n/csmapper/（文字コード変換テーブル）
- /usr/share/i18n/esdb/（エンコーディング定義）
- /usr/share/locale/（ロケールデータ）

## 処理フロー

### 処理シーケンス

```
1. csmapperデータのビルド
   └─ *.src ファイルから文字コード変換テーブルをコンパイル
2. esdbデータのビルド
   └─ エンコーディングスキーム定義のコンパイル
3. colldefデータのビルド
   └─ *.src ファイルから照合順序データをコンパイル
4. monetdefデータのビルド
   └─ *.src ファイルから通貨形式データをコンパイル
5. インストール
   └─ コンパイル済みデータを/usr/share/配下にインストール
6. ランタイム使用
   ├─ setlocale(3)でロケール切替
   ├─ iconv(3)で文字コード変換
   └─ strftime(3)等でロケール依存フォーマット
```

### フローチャート

```mermaid
flowchart TD
    A[ソースデータ *.src] --> B{データ種別}
    B -->|csmapper| C[文字コード変換テーブルコンパイル]
    B -->|esdb| D[エンコーディング定義コンパイル]
    B -->|colldef| E[照合順序データコンパイル]
    B -->|monetdef| F[通貨形式データコンパイル]
    C --> G[/usr/share/i18n/ にインストール]
    D --> G
    E --> H[/usr/share/locale/ にインストール]
    F --> H
    G --> I[iconv(3) ランタイム使用]
    H --> J[setlocale(3) ランタイム使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-110-1 | ロケール名規約 | language_TERRITORY.ENCODING形式（例：ja_JP.UTF-8, en_US.ISO8859-1） | ロケール設定時 |
| BR-110-2 | csmapperピボット | 文字コード変換はUCS（Unicode）をピボットとして2段階変換を行う | iconv変換時 |
| BR-110-3 | mapper.dir | csmapper/mapper.dir.srcで変換マッピングのルーティングを定義 | iconv初期化時 |
| BR-110-4 | 照合順序定義形式 | colldefは各ロケール固有の文字ソート順序を*.src形式で定義 | LC_COLLATE使用時 |

### 計算ロジック

- csmapperのピボット変換: ソースエンコーディング -> UCS -> ターゲットエンコーディング

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。バイナリ形式のデータファイルをファイルシステム上で管理する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EILSEQ | 不正バイトシーケンス | iconv変換時に変換不可能な文字 | フォールバック文字の使用 |
| EINVAL | ロケール不在 | setlocaleで未インストールのロケール指定 | ロケールデータのインストール |
| ENOMEM | メモリ不足 | 大規模変換テーブルのロード失敗 | システムメモリの増設 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- iconv変換は文字単位で処理され、変換テーブルのメモリキャッシュにより高速化
- ロケールデータはsetlocale時に一度ロードされ、以降はメモリ上で参照

## セキュリティ考慮事項

- 文字コード変換の誤りによるセキュリティバイパス（例：UTF-8のオーバーロング表現）に注意
- ロケールデータの改竄は文字処理の誤動作を引き起こす可能性がある

## 備考

- csmapperは多数のエンコーディングスキームをサポート：APPLE, AST, BIG5, CNS, CP, EBCDIC, GB, GEORGIAN, ISO-8859, ISO646, JIS, KAZAKH, KOI, KS等
- esdbも同様に多数のエンコーディング定義を含む：APPLE, AST, BIG5, CP, DEC, EBCDIC, EUC, GB, GEORGIAN, ISO-2022, ISO-8859, ISO646, KAZAKH, KOI, MISC, TCVN等
- colldefは各ロケール固有のソート順序を定義（af_ZA, be_BY, ca_AD, cs_CZ, da_DK, el_GR, es_MX, et_EE, fi_FI, fr_CA, hi_IN, hr_HR, hu_HU, hy_AM, is_IS, ja_JP, ko_KR等）
- monetdefは各ロケール固有の通貨形式を定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ディレクトリ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `share/i18n/Makefile` | i18nデータのトップレベルMakefile |
| 1-2 | csmapper/ | `share/i18n/csmapper/` | 文字コード変換マッピングディレクトリ |
| 1-3 | esdb/ | `share/i18n/esdb/` | エンコーディングスキームデータベース |

**読解のコツ**: csmapperとesdbは対になっており、csmapperが実際の変換テーブル（バイト値の対応表）、esdbがエンコーディングの仕様（可変長/固定長、ステートフル/ステートレス等）を定義する。mapper.dir.srcがcsmapper全体のルーティング定義として重要。

#### Step 2: 文字コード変換マッピングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mapper.dir.src | `share/i18n/csmapper/mapper.dir.src` | 変換マッピングのルーティング定義（どのエンコーディングペアにどの変換テーブルを使うか） |
| 2-2 | charset.pivot.src | `share/i18n/csmapper/charset.pivot.src` | ピボット文字セット（UCS）定義 |

**主要処理フロー**:
- mapper.dir.src: ソースエンコーディング名 → ターゲットエンコーディング名 → 変換テーブルファイルの3列マッピング
- charset.pivot.src: UCSをピボットとした変換経路の定義

#### Step 3: 各エンコーディングの変換テーブルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | JIS/ | `share/i18n/csmapper/JIS/` | 日本語JISエンコーディング変換テーブル |
| 3-2 | ISO-8859/ | `share/i18n/csmapper/ISO-8859/` | ISO-8859系エンコーディング変換テーブル |
| 3-3 | GB/ | `share/i18n/csmapper/GB/` | 中国語GB系エンコーディング変換テーブル |
| 3-4 | KS/ | `share/i18n/csmapper/KS/` | 韓国語KS系エンコーディング変換テーブル |

#### Step 4: 照合順序定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ja_JP.eucJP.src | `share/colldef/ja_JP.eucJP.src` | 日本語EUC-JPの照合順序定義 |
| 4-2 | en_US.US-ASCII.src | `share/monetdef/en_US.US-ASCII.src` | 英語(米国)の通貨形式定義 |

### プログラム呼び出し階層図

```
[ビルド時]
share/i18n/Makefile
    |
    ├─ share/i18n/csmapper/Makefile
    |     ├─ APPLE/Makefile ──── Apple系エンコーディング
    |     ├─ ISO-8859/Makefile ── ISO-8859系
    |     ├─ JIS/Makefile ────── JIS系
    |     ├─ GB/Makefile ─────── GB系
    |     └─ KS/Makefile ─────── KS系
    |
    └─ share/i18n/esdb/Makefile
          ├─ ISO-8859/Makefile
          ├─ EUC/Makefile
          └─ ...

[ランタイム]
setlocale(3) ──── /usr/share/locale/ ──── LC_* データ
iconv(3) ──────── /usr/share/i18n/csmapper/ ──── 変換テーブル
                   /usr/share/i18n/esdb/ ──── エンコーディング定義
```

### データフロー図

```
[入力]                      [処理]                      [出力]

*.src (ソース定義) ──▶ Makefile (コンパイル) ──▶ バイナリデータ
                              |
                    /usr/share/i18n/ にインストール
                              |
アプリケーション ──────▶ iconv(3) ──────────────▶ 変換済みテキスト
                              |
                         setlocale(3) ──────────▶ ロケール設定済み環境
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `share/i18n/Makefile` | ビルド | i18nトップレベルMakefile |
| csmapper/ | `share/i18n/csmapper/` | データ | 文字コード変換マッピング定義群 |
| mapper.dir.src | `share/i18n/csmapper/mapper.dir.src` | データ | 変換ルーティング定義 |
| charset.pivot.src | `share/i18n/csmapper/charset.pivot.src` | データ | ピボット文字セット定義 |
| esdb/ | `share/i18n/esdb/` | データ | エンコーディングスキームデータベース |
| colldef/ | `share/colldef/` | データ | 照合順序定義群 |
| monetdef/ | `share/monetdef/` | データ | 通貨形式定義群 |
| Makefile.inc | `share/i18n/csmapper/Makefile.inc` | ビルド | csmapper共通ビルド設定 |
| Makefile.part | `share/i18n/csmapper/Makefile.part` | ビルド | csmapper部分ビルド設定 |
