# 機能設計書 15-cd9660（ISO 9660）

## 概要

本ドキュメントは、FreeBSDにおけるISO 9660ファイルシステム（cd9660）のサポート機能の設計を記載する。CD-ROM/DVD-ROM等の光学メディアに使用されるISO 9660標準およびRock Ridge拡張に対応した読み取り専用ファイルシステムである。

### 本機能の処理概要

**業務上の目的・背景**：cd9660はISO 9660フォーマットの光学メディアやISOイメージファイルの読み取りをFreeBSD上で実現する。インストールメディア、ソフトウェア配布メディア、データアーカイブ等の光学メディアへのアクセスに不可欠である。

**機能の利用シーン**：FreeBSDインストールCD/DVDのマウント、ISOイメージファイルのマウント（mdconfigと組み合わせ）、光学ドライブからのデータ読み取り、Rock Ridge拡張によるUNIXファイル属性の復元など。

**主要な処理内容**：
1. ISO 9660ファイルシステムのマウント（読み取り専用）
2. Primary Volume Descriptorの解析
3. ディレクトリレコードの検索・列挙
4. Rock Ridge拡張の処理（UNIXパーミッション、シンボリックリンク等）
5. Joliet拡張の処理（Unicode長いファイル名）
6. マルチセッション対応
7. 文字コード変換（iconv連携）

**関連システム・外部連携**：GEOMストレージフレームワークまたはmdデバイス経由でアクセス。mdconfig(8)と組み合わせてISOイメージファイルを直接マウント可能。

**権限による制御**：読み取り専用ファイルシステムのため書き込み権限は不要。Rock Ridge拡張がない場合はマウントオプションでuid/gid/modeを指定。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接関連する画面なし |

## 機能種別

読み取り専用ファイルアクセス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| デバイスパス | char* | Yes | CD/DVDデバイスまたはmdデバイス | デバイスの存在確認 |
| マウントポイント | char* | Yes | マウント先ディレクトリ | ディレクトリの存在確認 |
| セッション番号 | int | No | マルチセッションのセッション番号 | 有効なセッション番号 |
| rrip | bool | No | Rock Ridge拡張の有効/無効 | - |
| joliet | bool | No | Joliet拡張の有効/無効 | - |

### 入力データソース

- mount_cd9660(8) コマンドからのユーザ入力
- /etc/fstab設定ファイル
- ISO 9660 Volume Descriptor

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルデータ | バイトストリーム | CD/DVD上のファイル内容 |
| ファイル属性 | struct vattr | ISO 9660メタデータ（Rock Ridge時はUNIX属性含む） |
| ディレクトリエントリ | struct dirent | ディレクトリ内ファイル一覧 |

### 出力先

- VFS層を介したユーザ空間アプリケーション

## 処理フロー

### 処理シーケンス

```
1. マウント処理（cd9660_mount → iso_mountfs）
   └─ Volume Descriptor読み込み → Root Directory Record取得 → Rock Ridge検出
2. ファイルアクセス
   └─ ディレクトリレコード検索 → エクステント位置特定 → データ読み取り
3. Rock Ridge処理
   └─ System Use Entryの解析 → UNIXパーミッション・シンボリックリンク復元
```

### フローチャート

```mermaid
flowchart TD
    A[mount要求] --> B[cd9660_mount]
    B --> C[iso_mountfs]
    C --> D[Volume Descriptor読み込み]
    D --> E{Rock Ridge?}
    E -->|Yes| F[RR拡張処理有効化]
    E -->|No| G[基本ISO 9660モード]
    F --> H[マウント完了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | 読み取り専用 | cd9660は常に読み取り専用でマウントされる（VFCF_READONLY） | 常時 |
| BR-15-02 | Rock Ridge優先 | Rock Ridge拡張が存在する場合はUNIX属性を復元 | Rock Ridge検出時 |
| BR-15-03 | ファイル名変換 | ISO 9660 Level 1では8.3形式、Rock Ridge/Jolietでは長いファイル名 | ファイル名処理時 |
| BR-15-04 | エクステントベース | ファイルはディスク上の連続セクタ（エクステント）として格納 | ファイルI/O時 |

### 計算ロジック

- ファイル位置 = エクステント開始LBA * 論理セクタサイズ（通常2048バイト）
- CD-ROMのセクタサイズ: 2048バイト（Mode 1）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル読み取り | - | SELECT | エクステントからのデータ読み取り |
| ディレクトリ列挙 | - | SELECT | ディレクトリレコードの解析 |

### テーブル別操作詳細

読み取り専用ファイルシステムのため、INSERT/UPDATE/DELETE操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EINVAL | バリデーション | 不正なVolume Descriptor | メディアの確認 |
| EIO | I/Oエラー | メディア読み取り失敗 | メディアの清掃・交換 |
| EROFS | 書き込み試行 | 読み取り専用FSへの書き込み | 書き込み不可の仕様 |

### リトライ仕様

光学ドライブのI/Oエラー時はデバイスドライバ層でリトライが行われる。

## トランザクション仕様

読み取り専用ファイルシステムのため、トランザクション管理は不要。

## パフォーマンス要件

- エクステントベースの連続配置によりシーケンシャル読み取り性能が良好
- バッファキャッシュによる読み取り性能向上
- 光学ドライブ固有のシーク遅延はハードウェア依存

## セキュリティ考慮事項

- 読み取り専用のためデータ改ざんリスクは低い
- nosuidマウントオプションの適用推奨（Rock Ridge使用時）
- 信頼できないメディアからのマウント時はnoexecオプション推奨

## 備考

- ISO 9660 Level 1（8.3ファイル名）、Level 2/3（長いファイル名）に対応
- Rock Ridge Interchange Protocol (RRIP)によりUNIXファイル属性を保持
- Joliet拡張によりUnicode（UCS-2）ファイル名をサポート
- cd9660はVFCF_READONLYフラグで登録される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | iso.h | `sys/fs/cd9660/iso.h` | ISO 9660 Volume Descriptor、ディレクトリレコード構造体 |
| 1-2 | cd9660_node.h | `sys/fs/cd9660/cd9660_node.h` | iso_node構造体（cd9660版inode） |
| 1-3 | iso_rrip.h | `sys/fs/cd9660/iso_rrip.h` | Rock Ridge拡張のSystem Use Entry定義 |
| 1-4 | cd9660_mount.h | `sys/fs/cd9660/cd9660_mount.h` | マウント情報構造体 |

**読解のコツ**: ISO 9660のディレクトリレコードは可変長であり、iso.hの構造体定義を理解することが重要。Rock Ridge拡張はSystem Use Sharing Protocol (SUSP)に基づく。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cd9660_vfsops.c | `sys/fs/cd9660/cd9660_vfsops.c` | VFS操作実装 |

**主要処理フロー**:
1. **68行目**: cd9660_mount関数の宣言
2. **76-85行目**: cd9660_vfsops構造体定義（VFCF_READONLYフラグ）
3. **130行目**: cd9660_mount() - マウント処理
4. **206行目**: iso_mountfs() - 実際のマウント処理（Volume Descriptor解析）

#### Step 3: vnode操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cd9660_vnops.c | `sys/fs/cd9660/cd9660_vnops.c` | vnode操作（read, readdir, readlink等） |
| 3-2 | cd9660_lookup.c | `sys/fs/cd9660/cd9660_lookup.c` | ディレクトリ検索 |

#### Step 4: Rock Ridge処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cd9660_rrip.c | `sys/fs/cd9660/cd9660_rrip.c` | Rock Ridge拡張の処理 |

### プログラム呼び出し階層図

```
mount_cd9660(8)
    │
    └─ kernel: cd9660_mount() → iso_mountfs()
           │
           ├─ Volume Descriptor解析
           ├─ Root Directory Record取得
           └─ Rock Ridge/Joliet検出

VFS I/O要求（読み取りのみ）
    │
    ├─ cd9660_vnops.c（vnode操作）
    │      ├─ cd9660_read()
    │      ├─ cd9660_readdir()
    │      └─ cd9660_readlink()（Rock Ridge）
    │
    ├─ cd9660_lookup.c（ディレクトリ検索）
    │
    ├─ cd9660_rrip.c（Rock Ridge処理）
    │
    ├─ cd9660_bmap.c（ブロックマッピング）
    │
    └─ cd9660_node.c（ノード管理）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

光学メディア/ISO  ──────▶ iso_mountfs()             ──▶ マウント情報
                          （Volume Descriptor解析）

ファイル読み取り要求 ──▶ cd9660_vnops              ──▶ ファイルデータ
                          ↓
                          cd9660_bmap.c
                          （エクステント位置計算）
                          ↓
                          デバイスI/O → セクタ読み取り
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| iso.h | `sys/fs/cd9660/iso.h` | ヘッダ | ISO 9660構造体定義 |
| cd9660_node.h | `sys/fs/cd9660/cd9660_node.h` | ヘッダ | iso_node構造体 |
| iso_rrip.h | `sys/fs/cd9660/iso_rrip.h` | ヘッダ | Rock Ridge定義 |
| cd9660_rrip.h | `sys/fs/cd9660/cd9660_rrip.h` | ヘッダ | Rock Ridge処理定義 |
| cd9660_mount.h | `sys/fs/cd9660/cd9660_mount.h` | ヘッダ | マウント情報 |
| cd9660_vfsops.c | `sys/fs/cd9660/cd9660_vfsops.c` | ソース | VFS操作 |
| cd9660_vnops.c | `sys/fs/cd9660/cd9660_vnops.c` | ソース | vnode操作 |
| cd9660_lookup.c | `sys/fs/cd9660/cd9660_lookup.c` | ソース | ディレクトリ検索 |
| cd9660_rrip.c | `sys/fs/cd9660/cd9660_rrip.c` | ソース | Rock Ridge処理 |
| cd9660_bmap.c | `sys/fs/cd9660/cd9660_bmap.c` | ソース | ブロックマッピング |
| cd9660_node.c | `sys/fs/cd9660/cd9660_node.c` | ソース | ノード管理 |
| cd9660_util.c | `sys/fs/cd9660/cd9660_util.c` | ソース | ユーティリティ |
| cd9660_iconv.c | `sys/fs/cd9660/cd9660_iconv.c` | ソース | 文字コード変換 |
| mount_cd9660.c | `sbin/mount_cd9660/mount_cd9660.c` | ソース | mountコマンド |
