# 機能設計書 16-tmpfs

## 概要

本ドキュメントは、FreeBSDのメモリベース一時ファイルシステム（tmpfs）の機能設計を記載する。tmpfsはシステムメモリ（RAM）上にファイルシステムを構築し、高速な一時ファイル格納領域を提供する。

### 本機能の処理概要

**業務上の目的・背景**：tmpfsはディスクI/Oを伴わない高速なファイルアクセスが必要な場面で利用される。一時ファイル、ビルド中間成果物、キャッシュデータなどの格納に適している。メモリ上に存在するため、システム再起動時にデータは消失する。

**機能の利用シーン**：/tmpディレクトリのマウント、ビルドシステムの中間ファイル格納、テスト環境の一時領域、高速I/Oが必要なアプリケーションのワーキングディレクトリなど。

**主要な処理内容**：
1. メモリベースファイルシステムのマウント・アンマウント
2. ファイル・ディレクトリ・シンボリックリンクの作成・削除
3. メモリページの動的割り当て・解放
4. サイズ制限（クォータ的制御）
5. スワップ領域へのページアウト対応
6. POSIX準拠のファイル操作サポート

**関連システム・外部連携**：VMサブシステム（vm_page, vm_object）と密接に連携。スワップ領域との間でページの入出力が行われる。

**権限による制御**：マウントにはroot権限が必要。ファイルアクセスはUNIXパーミッションに従う。マウント時にuid/gid/modeでルートディレクトリの属性を指定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接関連する画面なし |

## 機能種別

CRUD操作 / メモリファイルシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| マウントポイント | char* | Yes | マウント先ディレクトリ | ディレクトリの存在確認 |
| size | off_t | No | 最大サイズ制限 | 正の値 |
| maxfilesize | off_t | No | 最大ファイルサイズ | 正の値 |
| inodes | ino_t | No | 最大inode数 | 正の値 |
| uid | uid_t | No | ルートディレクトリ所有者 | 有効なUID |
| gid | gid_t | No | ルートディレクトリグループ | 有効なGID |
| mode | mode_t | No | ルートディレクトリパーミッション | 有効なモード値 |

### 入力データソース

- mount(8) -t tmpfs コマンドからのユーザ入力
- /etc/fstab設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルデータ | バイトストリーム | メモリ上のファイル内容 |
| ファイルメタデータ | struct vattr | tmpfsノードのメタデータ |
| ディレクトリエントリ | struct dirent | ディレクトリ内ファイル一覧 |
| statfs情報 | struct statfs | メモリ使用量情報 |

### 出力先

- VFS層を介したユーザ空間アプリケーション

## 処理フロー

### 処理シーケンス

```
1. マウント処理（tmpfs_mount）
   └─ tmpfs_mount構造体初期化 → ルートノード作成 → UMA zone初期化
2. ファイル作成
   └─ tmpfs_node割り当て → vm_object作成（通常ファイル時）→ ディレクトリエントリ追加
3. ファイルI/O
   └─ vm_pageを介したメモリ読み書き（uiomove）
4. アンマウント
   └─ 全ノード解放 → tmpfs_mount解放
```

### フローチャート

```mermaid
flowchart TD
    A[mount -t tmpfs] --> B[tmpfs_mount]
    B --> C[tmpfs_mount構造体初期化]
    C --> D[ルートtmpfs_node作成]
    D --> E[マウント完了]
    E --> F[ファイルI/O要求]
    F --> G{操作種別}
    G -->|読み取り| H[vm_page参照]
    G -->|書き込み| I[vm_page割り当て・書き込み]
    G -->|作成| J[tmpfs_node割り当て]
    H --> K[データ返却]
    I --> K
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | メモリ動的割り当て | ファイルサイズに応じてvm_pageを動的に割り当て・解放 | ファイルI/O時 |
| BR-16-02 | サイズ制限 | sizeオプション指定時は合計サイズを制限 | マウント時設定 |
| BR-16-03 | スワップアウト | メモリ不足時はtmpfsのページもスワップ対象 | メモリプレッシャー時 |
| BR-16-04 | 揮発性 | リブート時に全データ消失 | 常時 |

### 計算ロジック

- 使用可能容量 = min(sizeオプション, 利用可能物理メモリ + スワップ)
- ノード数制限 = inodesオプション（未指定時は制限なし）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル作成 | tmpfs_nodeリスト | INSERT | ノード割り当てとvm_object作成 |
| ファイル削除 | tmpfs_nodeリスト | DELETE | ノード解放とvm_object解放 |

### テーブル別操作詳細

tmpfsはディスクベースのデータ構造を持たず、全てインメモリで管理される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOSPC | リソース不足 | サイズ制限到達またはメモリ不足 | size拡張またはファイル削除 |
| ENOMEM | メモリ不足 | vm_page割り当て失敗 | メモリ解放またはスワップ追加 |
| ENOENT | ファイル不在 | 存在しないファイルへのアクセス | パス確認 |

### リトライ仕様

メモリ割り当て失敗時はVMサブシステムによるページリクレイム後にリトライされる場合がある。

## トランザクション仕様

tmpfsはインメモリ構造のため、トランザクション管理は不要。システムクラッシュ時は全データが消失する。

## パフォーマンス要件

- ディスクI/Oを伴わないためレイテンシが極めて低い
- メモリバンド幅に依存した高スループット
- vm_objectを介した効率的なページ管理

## セキュリティ考慮事項

- UNIXパーミッションによるアクセス制御
- メモリ上のデータのためディスクフォレンジクスによる復元は困難
- nosuid/noexecマウントオプション推奨（/tmp用途時）
- スワップアウトされたページはスワップデバイスに残る可能性がある

## 備考

- mdmfs(8)と異なり、tmpfsはVMサブシステムと直接統合されている
- FreeBSD独自実装であり、NetBSD由来のtmpfsがベース
- UMA（Universal Memory Allocator）zoneを使用してノードを管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tmpfs.h | `sys/fs/tmpfs/tmpfs.h` | tmpfs_mount, tmpfs_node, tmpfs_dirent等の中核構造体 |
| 1-2 | tmpfs_vnops.h | `sys/fs/tmpfs/tmpfs_vnops.h` | vnode操作プロトタイプ |
| 1-3 | tmpfs_fifoops.h | `sys/fs/tmpfs/tmpfs_fifoops.h` | FIFO操作プロトタイプ |

**読解のコツ**: tmpfs_nodeはファイルタイプ（通常ファイル、ディレクトリ、シンボリックリンク等）に応じた共用体メンバを持つ。通常ファイルではvm_objectへの参照を保持する。

#### Step 2: エントリーポイントを理解する（VFS操作）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tmpfs_vfsops.c | `sys/fs/tmpfs/tmpfs_vfsops.c` | VFS操作実装 |

**主要処理フロー**:
1. **322行目**: tmpfs_mount() - マウント処理、tmpfs_mount構造体初期化
2. **443行目**: tmpfs_mount構造体のメモリ割り当て
3. **475行目**: ルートノード（tm_root）の初期化
4. **495行目**: tmpfs_unmount() - アンマウント処理
5. **550行目**: tmpfs_free_tmp() - 構造体解放
6. **574行目**: tmpfs_root() - ルートvnode取得

#### Step 3: vnode操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tmpfs_vnops.c | `sys/fs/tmpfs/tmpfs_vnops.c` | vnode操作（create, read, write, remove等） |

#### Step 4: ノード管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tmpfs_subr.c | `sys/fs/tmpfs/tmpfs_subr.c` | ノード割り当て・解放、ディレクトリエントリ管理 |

### プログラム呼び出し階層図

```
mount -t tmpfs
    │
    └─ kernel: tmpfs_mount()（tmpfs_vfsops.c:322）
           │
           ├─ tmpfs_mount構造体初期化
           ├─ ルートtmpfs_node作成
           └─ マウント完了

VFS I/O要求
    │
    ├─ tmpfs_vnops.c（vnode操作）
    │      ├─ tmpfs_read() / tmpfs_write()
    │      │      └─ vm_page操作（uiomove）
    │      ├─ tmpfs_create() / tmpfs_remove()
    │      └─ tmpfs_readdir()
    │
    └─ tmpfs_subr.c（ノード管理）
           ├─ tmpfs_alloc_node()
           ├─ tmpfs_free_node()
           └─ tmpfs_alloc_dirent()
```

### データフロー図

```
[入力]                    [処理]                        [出力]

マウント要求     ──────▶ tmpfs_mount()             ──▶ tmpfs_mount構造体
                          （メモリ構造体初期化）

ファイルI/O要求  ──────▶ tmpfs_vnops               ──▶ メモリ上のファイルデータ
                          ↓
                          vm_page操作
                          （メモリページ読み書き）
                          ↓
                          必要に応じてスワップI/O
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tmpfs.h | `sys/fs/tmpfs/tmpfs.h` | ヘッダ | 中核データ構造定義 |
| tmpfs_vnops.h | `sys/fs/tmpfs/tmpfs_vnops.h` | ヘッダ | vnode操作プロトタイプ |
| tmpfs_fifoops.h | `sys/fs/tmpfs/tmpfs_fifoops.h` | ヘッダ | FIFO操作プロトタイプ |
| tmpfs_vfsops.c | `sys/fs/tmpfs/tmpfs_vfsops.c` | ソース | VFS操作 |
| tmpfs_vnops.c | `sys/fs/tmpfs/tmpfs_vnops.c` | ソース | vnode操作 |
| tmpfs_subr.c | `sys/fs/tmpfs/tmpfs_subr.c` | ソース | ノード管理サブルーチン |
| tmpfs_fifoops.c | `sys/fs/tmpfs/tmpfs_fifoops.c` | ソース | FIFO操作 |
