# 機能設計書 18-unionfs

## 概要

本ドキュメントは、FreeBSDのunionfsファイルシステムの機能設計を記載する。unionfsは複数のファイルシステムを重ね合わせて統合表示するユニオンマウント機構であり、上層（upper layer）と下層（lower layer）のファイルシステムを透過的に結合する。

### 本機能の処理概要

**業務上の目的・背景**：unionfsは読み取り専用のベースファイルシステムの上に書き込み可能な層を重ねるOverlay型のファイルシステム統合を実現する。LiveCD/USB環境で読み取り専用メディア上に変更を重ねる、テンプレートディレクトリに対するカスタマイズ層の追加などに利用される。

**機能の利用シーン**：読み取り専用メディア（CD/DVD/ISOイメージ）上への変更のオーバーレイ、テンプレートベースの環境構築、jail環境でのベースシステム共有と個別変更の分離など。

**主要な処理内容**：
1. 上層（writable）と下層（read-only）のファイルシステム統合マウント
2. ディレクトリ統合表示（whiteout処理を含む）
3. Copy-Up処理（下層ファイルの上層への自動コピー）
4. Whiteoutエントリによる下層ファイルの隠蔽
5. 上層・下層のvnodeの統合管理

**関連システム・外部連携**：VFS層と連携し、上層・下層の2つのファイルシステムのvnodeを統合管理する。

**権限による制御**：マウントにはroot権限が必要。上層ファイルシステムの書き込み権限に従う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接関連する画面なし |

## 機能種別

ファイルシステム統合 / オーバーレイマウント

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 下層パス | char* | Yes | 下層（ベース）ディレクトリ | パスの存在確認 |
| マウントポイント | char* | Yes | 上層ディレクトリ（マウント先） | ディレクトリの存在確認 |
| マウントオプション | int | No | -o below等のオプション | 有効なオプション |

### 入力データソース

- mount_unionfs(8) コマンドからのユーザ入力
- /etc/fstab設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルデータ | バイトストリーム | 上層優先の統合ファイルデータ |
| ディレクトリエントリ | struct dirent | 上層・下層を統合したディレクトリ一覧 |

### 出力先

- VFS層を介したユーザ空間アプリケーション

## 処理フロー

### 処理シーケンス

```
1. マウント処理
   └─ 上層・下層vnode取得 → unionfs_mount構造体初期化 → マウント完了
2. ファイル検索
   └─ 上層で検索 → 見つからなければ下層で検索 → whiteout確認
3. ファイル書き込み（Copy-Up）
   └─ 下層ファイルへの書き込み時は上層に自動コピー後書き込み
4. ファイル削除
   └─ 上層から削除 + whiteoutエントリ作成（下層に同名ファイルがある場合）
5. ディレクトリ列挙
   └─ 上層・下層のエントリを統合（重複排除、whiteout適用）
```

### フローチャート

```mermaid
flowchart TD
    A[ファイルアクセス要求] --> B[上層で検索]
    B --> C{上層に存在?}
    C -->|Yes| D[上層ファイルにアクセス]
    C -->|No| E{whiteoutあり?}
    E -->|Yes| F[ENOENT返却]
    E -->|No| G[下層で検索]
    G --> H{下層に存在?}
    H -->|Yes| I{書き込み要求?}
    H -->|No| F
    I -->|Yes| J[Copy-Up処理]
    I -->|No| K[下層ファイル読み取り]
    J --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | 上層優先 | 同名ファイルが両層に存在する場合は上層が優先される | ファイル検索時 |
| BR-18-02 | Copy-Up | 下層ファイルへの変更時は上層に自動コピーしてから変更 | 書き込み要求時 |
| BR-18-03 | Whiteout | 下層ファイルの削除はwhiteoutエントリにより論理的に隠蔽 | ファイル削除時 |
| BR-18-04 | ループバック | VFCF_LOOPBACKフラグで登録 | 常時 |

### 計算ロジック

特別な計算ロジックはない。ファイルアクセスは上層→下層の優先順位で解決される。

## データベース操作仕様

### 操作別データベース影響一覧

unionfsはスタッキングファイルシステムであり、データの実体は上層・下層のファイルシステムに存在する。

### テーブル別操作詳細

直接のデータベース操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | 上層・下層いずれにもファイルが存在しない | パス確認 |
| ENOSPC | 容量不足 | Copy-Up時に上層FSの容量不足 | 上層FSの容量確保 |
| EROFS | 書き込み不可 | 上層FSが読み取り専用 | マウントオプション確認 |

### リトライ仕様

unionfs自体ではリトライを行わない。エラーは該当ファイルシステムのものが返却される。

## トランザクション仕様

unionfsはスタッキングFSであるため、トランザクション管理は上層・下層のファイルシステムに依存する。Copy-Up処理はアトミックではないため、途中で中断された場合は不整合が発生する可能性がある。

## パフォーマンス要件

- ファイル検索は上層→下層の2段階となるため、nullfsに比べてオーバーヘッドが大きい
- Copy-Up処理はファイル全体のコピーとなるため、大きなファイルでは遅延が発生
- ディレクトリ統合表示は両層のエントリを読み取るためオーバーヘッドあり

## セキュリティ考慮事項

- 上層・下層それぞれのファイルシステムの権限設定が適用される
- Copy-Up時のファイルパーミッションは元ファイルと同一
- whiteoutによる下層ファイルの隠蔽は上層の書き込み権限で可能

## 備考

- unionfsはVFCF_LOOPBACKフラグで登録される
- Linux のoverlayfsに近い概念だが、実装は異なる
- 安定性に注意が必要な場面があり、代替としてnullfs + mdデバイスの組み合わせが推奨される場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | union.h | `sys/fs/unionfs/union.h` | unionfs_mount構造体、unionfs_node構造体（上層/下層vnodeの対） |

**読解のコツ**: unionfs_nodeは上層vnode（un_uppervp）と下層vnode（un_lowervp）の2つの参照を保持する。ファイルが上層にのみ存在する場合はun_lowervp=NULL、下層にのみ存在する場合はun_uppervp=NULL。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | union_vfsops.c | `sys/fs/unionfs/union_vfsops.c` | VFS操作実装 |

**主要処理フロー**:
1. **66行目**: unionfs_vfsops構造体の宣言
2. **593行目**: unionfs_vfsops構造体定義
3. **608行目**: VFS_SET登録（VFCF_LOOPBACK）

#### Step 3: vnode操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | union_vnops.c | `sys/fs/unionfs/union_vnops.c` | vnode操作（上層/下層の振り分け、Copy-Up処理） |

#### Step 4: サブルーチンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | union_subr.c | `sys/fs/unionfs/union_subr.c` | ノード管理、Copy-Up実装、whiteout処理 |

### プログラム呼び出し階層図

```
mount_unionfs(8)
    │
    └─ kernel: unionfs_mount（union_vfsops.c）
           │
           ├─ 上層vnode取得
           ├─ 下層vnode取得
           └─ unionfs_mount構造体初期化

VFS I/O要求
    │
    └─ union_vnops.c（vnode操作）
           │
           ├─ 上層vnodeで操作（上層に存在する場合）
           ├─ 下層vnodeで操作（下層のみに存在し読み取りの場合）
           ├─ Copy-Up → 上層で操作（下層のみに存在し書き込みの場合）
           │      └─ union_subr.c: unionfs_copyup()
           └─ Whiteout作成（削除時、下層に同名ファイルがある場合）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ファイルアクセス要求 ──▶ union_vnops                   ──▶ 統合ファイルデータ
                          ↓
                          上層FS検索
                          ↓（見つからない場合）
                          下層FS検索
                          ↓（書き込み時）
                          Copy-Up（union_subr.c）
                          ↓
                          上層FSで書き込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| union.h | `sys/fs/unionfs/union.h` | ヘッダ | データ構造定義 |
| union_vfsops.c | `sys/fs/unionfs/union_vfsops.c` | ソース | VFS操作 |
| union_vnops.c | `sys/fs/unionfs/union_vnops.c` | ソース | vnode操作 |
| union_subr.c | `sys/fs/unionfs/union_subr.c` | ソース | Copy-Up、whiteout等サブルーチン |
| mount_unionfs.c | `sbin/mount_unionfs/mount_unionfs.c` | ソース | mountコマンド |
