# 機能設計書 20-procfs / fdescfs

## 概要

本ドキュメントは、FreeBSDのprocfs（プロセス情報擬似ファイルシステム）およびfdescfs（ファイルディスクリプタ擬似ファイルシステム）の機能設計を記載する。両者はカーネル内部の情報をファイルシステムインタフェースで公開する擬似ファイルシステムである。

### 本機能の処理概要

**業務上の目的・背景**：procfsはプロセスの状態情報（メモリマップ、レジスタ、ステータス等）をファイルとして公開し、デバッガやシステム監視ツールからのアクセスを可能にする。fdescfsはプロセスのファイルディスクリプタを/dev/fd/配下のファイルとして公開する。

**機能の利用シーン**：デバッガ（gdb等）によるプロセスのメモリ・レジスタアクセス、システム監視ツールによるプロセス情報の取得、シェルスクリプトでの/dev/fd/利用（プロセス置換等）、Linux互換環境（linprocfs）の基盤。

**主要な処理内容**：

**procfs:**
1. /proc/<pid>/statusによるプロセスステータス情報の提供
2. /proc/<pid>/mapによるメモリマッピング情報の提供
3. /proc/<pid>/memによるプロセスメモリの直接読み書き
4. /proc/<pid>/regs, /proc/<pid>/fpregs等によるレジスタ情報の提供
5. /proc/<pid>/noteによるプロセスへの通知
6. /proc/<pid>/rlimitによるリソース制限情報の提供
7. /proc/<pid>/osrelによるOS互換バージョン情報
8. /proc/<pid>/typeによるプロセスタイプ情報

**fdescfs:**
1. /dev/fd/<n>によるファイルディスクリプタのファイルアクセス
2. /dev/stdinなどの標準入出力デバイスの提供

**関連システム・外部連携**：プロセス管理サブシステム（sys/kern/kern_proc.c）と連携。ptrace(2)システムコールの代替/補完。

**権限による制御**：procfsでは自プロセスの情報は閲覧可能だが、他プロセスの情報はセキュリティポリシーに基づきアクセスが制限される。fdescfsでは自プロセスのファイルディスクリプタのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接関連する画面なし |

## 機能種別

情報公開 / 擬似ファイルシステム

## 入力仕様

### 入力パラメータ

**procfs:**

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| マウントポイント | char* | Yes | マウント先（通常 /proc） | ディレクトリの存在確認 |
| PID | pid_t | - | アクセス対象プロセスのPID | 有効なPID |

**fdescfs:**

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| マウントポイント | char* | Yes | マウント先（通常 /dev/fd） | ディレクトリの存在確認 |
| fd番号 | int | - | アクセス対象のファイルディスクリプタ番号 | 有効なFD番号 |

### 入力データソース

- mount(8) -t procfs / mount(8) -t fdescfs コマンド
- /etc/fstab設定ファイル
- カーネル内プロセス構造体（struct proc）

## 出力仕様

### 出力データ

**procfs:**

| 項目名 | 型 | 説明 |
|--------|-----|------|
| status | テキスト | プロセスステータス情報 |
| map | テキスト | メモリマッピング情報 |
| mem | バイトストリーム | プロセスメモリ内容 |
| regs | struct reg | レジスタ値 |
| fpregs | struct fpreg | 浮動小数点レジスタ値 |
| dbregs | struct dbreg | デバッグレジスタ値 |
| rlimit | テキスト | リソース制限情報 |

**fdescfs:**

| 項目名 | 型 | 説明 |
|--------|-----|------|
| /dev/fd/N | ファイル参照 | ファイルディスクリプタNへの参照 |

### 出力先

- VFS層を介したユーザ空間アプリケーション

## 処理フロー

### 処理シーケンス

**procfs:**
```
1. マウント処理
   └─ procfs_mount構造体初期化 → マウント完了
2. /proc/<pid>/<file>アクセス
   └─ PIDからstruct proc取得 → ファイルタイプ判定 → 対応する情報生成・返却
```

**fdescfs:**
```
1. マウント処理
   └─ fdesc_mount → マウント完了
2. /dev/fd/<n>アクセス
   └─ ファイルディスクリプタ番号取得 → カレントプロセスのfd table参照 → ファイル操作転送
```

### フローチャート

```mermaid
flowchart TD
    A[/proc/PID/statusアクセス] --> B[procfs vnode lookup]
    B --> C[PIDからstruct proc取得]
    C --> D{プロセス存在?}
    D -->|Yes| E{アクセス権限?}
    D -->|No| F[ENOENT]
    E -->|許可| G[procfs_status読み取り]
    E -->|拒否| H[EACCES]
    G --> I[テキスト生成・返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-20-01 | PIDベースアクセス | /proc/<pid>/形式でプロセス固有情報にアクセス | procfsアクセス時 |
| BR-20-02 | セキュリティチェック | 他プロセスの情報アクセスはカーネルセキュリティポリシーで制御 | 他プロセスアクセス時 |
| BR-20-03 | 合成ファイルシステム | VFCF_SYNTHETICフラグで登録（fdescfs） | マウント時 |
| BR-20-04 | jail対応 | VFCF_JAILフラグにより jail内でのマウントに対応（fdescfs） | jail使用時 |

### 計算ロジック

特別な計算ロジックはない。カーネル内部データ構造の情報をテキストまたはバイナリ形式で変換して返却する。

## データベース操作仕様

### 操作別データベース影響一覧

擬似ファイルシステムであり、ディスク上のデータベースへの操作はない。カーネル内のプロセス情報を読み取って返却する。

### テーブル別操作詳細

直接のデータベース操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | プロセス不在 | 指定PIDのプロセスが存在しない | PID確認 |
| EACCES | 権限不足 | 他プロセスへのアクセス権限なし | 権限確認 |
| EPERM | 操作不許可 | セキュリティポリシーによる拒否 | セキュリティ設定確認 |
| EBADF | 不正なFD | 存在しないファイルディスクリプタへのアクセス | FD確認 |

### リトライ仕様

擬似ファイルシステムのため、リトライ仕様はない。

## トランザクション仕様

擬似ファイルシステムのため、トランザクション管理は不要。プロセス情報はスナップショット的に取得され、一貫性は保証されない。

## パフォーマンス要件

- カーネル内データ構造への直接アクセスのため高速
- ディスクI/Oを伴わない
- プロセス数が多い場合の/proc/ディレクトリ列挙はプロセス数に比例

## セキュリティ考慮事項

- procfsによるメモリアクセスはデバッガ権限（PRIV_DEBUG）で制御
- kern.security.bsd.unprivileged_proc_debug sysctlで非特権ユーザのデバッグアクセスを制御
- procfsはセキュリティ上の理由からデフォルトではマウントされないことが多い
- MACフレームワークとの連携によるアクセス制御

## 備考

- FreeBSDではprocfsの利用は非推奨となりつつあり、sysctl(8)やprocstat(1)が推奨される
- Linuxバイナリ互換のためのlinprocfsは別実装（sys/compat/linux/）
- fdescfsは主にシェルの/dev/fd/機能のために必要
- pseudofsフレームワーク（sys/fs/pseudofs/）がprocfsの基盤として使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | procfs.h | `sys/fs/procfs/procfs.h` | procfsのノードタイプ定義、関数プロトタイプ |
| 1-2 | fdesc.h | `sys/fs/fdescfs/fdesc.h` | fdescfsのノード構造体 |
| 1-3 | pseudofs.h | `sys/fs/pseudofs/` | pseudofsフレームワーク（procfsの基盤） |

**読解のコツ**: procfsの各ファイル（status, map, mem等）は個別のソースファイル（procfs_status.c, procfs_map.c, procfs_mem.c等）で実装されている。ファイル名から対応する/proc/<pid>/下のエントリが推測できる。

#### Step 2: procfsのエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | procfs.c | `sys/fs/procfs/procfs.c` | procfsの初期化・ノード登録 |

#### Step 3: procfsの各情報ファイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | procfs_status.c | `sys/fs/procfs/procfs_status.c` | プロセスステータス情報の生成 |
| 3-2 | procfs_map.c | `sys/fs/procfs/procfs_map.c` | メモリマッピング情報の生成 |
| 3-3 | procfs_mem.c | `sys/fs/procfs/procfs_mem.c` | プロセスメモリの直接アクセス |
| 3-4 | procfs_regs.c | `sys/fs/procfs/procfs_regs.c` | 汎用レジスタの読み書き |
| 3-5 | procfs_fpregs.c | `sys/fs/procfs/procfs_fpregs.c` | 浮動小数点レジスタ |
| 3-6 | procfs_dbregs.c | `sys/fs/procfs/procfs_dbregs.c` | デバッグレジスタ |
| 3-7 | procfs_rlimit.c | `sys/fs/procfs/procfs_rlimit.c` | リソース制限情報 |
| 3-8 | procfs_note.c | `sys/fs/procfs/procfs_note.c` | プロセスへの通知 |
| 3-9 | procfs_osrel.c | `sys/fs/procfs/procfs_osrel.c` | OS互換バージョン |
| 3-10 | procfs_type.c | `sys/fs/procfs/procfs_type.c` | プロセスタイプ |

#### Step 4: fdescfsを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fdesc_vfsops.c | `sys/fs/fdescfs/fdesc_vfsops.c` | fdescfs VFS操作 |
| 4-2 | fdesc_vnops.c | `sys/fs/fdescfs/fdesc_vnops.c` | fdescfs vnode操作 |

**主要処理フロー（fdescfs）**:
1. **58-59行目**: fdesc_mount / fdesc_unmount の宣言
2. **77行目**: fdesc_mount() - マウント処理
3. **133行目**: fdesc_unmount() - アンマウント処理
4. **231行目**: fdesc_vfsops構造体定義
5. **241行目**: VFS_SET登録（VFCF_SYNTHETIC | VFCF_JAIL）

### プログラム呼び出し階層図

```
procfs:
    mount -t procfs
        │
        └─ procfs.c（初期化・ノード登録）
               │
               └─ pseudofsフレームワーク
                      │
                      ├─ procfs_status.c → struct proc参照
                      ├─ procfs_map.c → vm_map参照
                      ├─ procfs_mem.c → プロセスメモリ読み書き
                      ├─ procfs_regs.c → struct reg取得
                      ├─ procfs_rlimit.c → rlimit情報取得
                      └─ 他の procfs_*.c ファイル

fdescfs:
    mount -t fdescfs
        │
        └─ fdesc_vfsops.c（VFS操作）
               │
               └─ fdesc_vnops.c（vnode操作）
                      │
                      └─ curproc->p_fd参照 → 対応するvnode取得
```

### データフロー図

```
[procfs]
/proc/<pid>/status  ──▶  procfs_status.c  ──▶  struct proc参照  ──▶  テキスト出力
/proc/<pid>/map     ──▶  procfs_map.c     ──▶  vm_map参照       ──▶  テキスト出力
/proc/<pid>/mem     ──▶  procfs_mem.c     ──▶  メモリ直接アクセス ──▶  バイナリ出力

[fdescfs]
/dev/fd/<n>         ──▶  fdesc_vnops.c    ──▶  fd table参照      ──▶  ファイル操作転送
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| procfs.h | `sys/fs/procfs/procfs.h` | ヘッダ | procfs定義 |
| procfs.c | `sys/fs/procfs/procfs.c` | ソース | 初期化・ノード登録 |
| procfs_status.c | `sys/fs/procfs/procfs_status.c` | ソース | ステータス情報 |
| procfs_map.c | `sys/fs/procfs/procfs_map.c` | ソース | メモリマップ情報 |
| procfs_mem.c | `sys/fs/procfs/procfs_mem.c` | ソース | メモリアクセス |
| procfs_regs.c | `sys/fs/procfs/procfs_regs.c` | ソース | レジスタ情報 |
| procfs_fpregs.c | `sys/fs/procfs/procfs_fpregs.c` | ソース | 浮動小数点レジスタ |
| procfs_dbregs.c | `sys/fs/procfs/procfs_dbregs.c` | ソース | デバッグレジスタ |
| procfs_rlimit.c | `sys/fs/procfs/procfs_rlimit.c` | ソース | リソース制限 |
| procfs_note.c | `sys/fs/procfs/procfs_note.c` | ソース | プロセス通知 |
| procfs_osrel.c | `sys/fs/procfs/procfs_osrel.c` | ソース | OS互換バージョン |
| procfs_type.c | `sys/fs/procfs/procfs_type.c` | ソース | プロセスタイプ |
| fdesc.h | `sys/fs/fdescfs/fdesc.h` | ヘッダ | fdescfs定義 |
| fdesc_vfsops.c | `sys/fs/fdescfs/fdesc_vfsops.c` | ソース | fdescfs VFS操作 |
| fdesc_vnops.c | `sys/fs/fdescfs/fdesc_vnops.c` | ソース | fdescfs vnode操作 |
