# 機能設計書 22-autofs

## 概要

本ドキュメントは、FreeBSDのautofs（自動マウントファイルシステム）の機能設計を記述する。autofsはオンデマンドでファイルシステムを自動マウントする機構であり、ユーザがディレクトリにアクセスした際にautofsデーモン（automountd）と連携して必要なファイルシステムを透過的にマウントする。

### 本機能の処理概要

**業務上の目的・背景**：NFSなどのネットワークファイルシステムや取り外し可能メディアの手動マウントは管理負荷が高い。autofsは必要時に自動マウントし、一定時間未使用後に自動アンマウントすることで、管理コストの削減と利便性向上を実現する。カーネルとユーザ空間デーモンの協調動作により柔軟なマウントマップ設定が可能。

**機能の利用シーン**：NFSホームディレクトリの自動マウント、ネットワーク共有のオンデマンドマウント、auto_masterマップに基づく大規模ファイルシステム管理。

**主要な処理内容**：
1. autofsファイルシステムのマウント・アンマウント（autofs_mount / autofs_unmount）
2. ディレクトリアクセス時のマウントトリガ（autofs_trigger）
3. automountdデーモンとのioctl通信（/dev/autofsデバイス）
4. マウント結果のキャッシュとタイムアウト管理
5. 名前空間ノード管理（RB-treeベース）

**関連システム・外部連携**：automountd(8)デーモン、autounmountd(8)デーモン、automount(8)コマンド、auto_masterマップ

**権限による制御**：マウント操作にはroot権限が必要。autofsデバイスはautomountdのみがオープンする。

## 関連画面

本機能はカーネルモジュールおよびデーモンであり、直接的なUI画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ファイルシステム操作（自動マウントトリガ）/ デーモン連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| from | char* | Yes | マウントマップ名 | MAXPATHLEN以内 |
| fspath | char* | Yes | マウントポイントパス | MAXPATHLEN以内 |
| master_options | char* | Yes | auto_masterオプション | MAXPATHLEN以内 |
| master_prefix | char* | Yes | パスプレフィックス | MAXPATHLEN以内 |

### 入力データソース

- auto_masterマップファイル（automount(8)コマンド経由）
- automountdデーモンからのioctl応答
- ディレクトリアクセスイベント（VFS lookup）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| autofs_request | struct | automountdへのマウント要求 |
| vnode | struct vnode* | マウントポイントのvnode |

### 出力先

- /dev/autofsデバイス経由でautomountdへ通知
- VFSレイヤ経由でユーザ空間に公開

## 処理フロー

### 処理シーケンス

```
1. autofs_mount()
   └─ autofs_mount構造体の割り当て・初期化
      ├─ am_from, am_mountpoint, am_options, am_prefixの設定
      ├─ am_lockの初期化（sx_init）
      └─ ルートノード作成（autofs_node_new）
2. ディレクトリアクセス時
   └─ VFS lookup → autofs_trigger()呼び出し
      ├─ キャッシュ確認（autofs_cached）
      ├─ キャッシュミス時: autofs_request生成
      ├─ /dev/autofs経由でautomountdに通知
      └─ automountdの応答待ち（cv_wait）
3. automountdの処理
   └─ マウント実行 → 結果返却（ioctl）
4. autofs_unmount()
   └─ 未処理リクエストのキャンセル → ノードツリー解放
```

### フローチャート

```mermaid
flowchart TD
    A[ディレクトリアクセス] --> B{autofs_cached?}
    B -->|Yes| C[キャッシュ済みマウント利用]
    B -->|No| D[autofs_trigger]
    D --> E[autofs_request生成]
    E --> F[automountdに通知]
    F --> G[cv_wait: 応答待ち]
    G --> H{マウント成功?}
    H -->|Yes| I[マウント済みFS利用]
    H -->|No| J[エラー返却]
    C --> K[結果返却]
    I --> K
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | オンデマンドマウント | ディレクトリへのアクセス時にのみマウントが発生 | VFS lookup時 |
| BR-22-02 | キャッシュ制御 | an_cachedフラグによりマウント済みかを判定 | autofs_trigger呼び出し時 |
| BR-22-03 | リトライ制御 | an_retriesカウンタでマウント失敗時のリトライを管理 | autofs_trigger失敗時 |
| BR-22-04 | MNT_UPDATE時フラッシュ | MNT_UPDATEフラグ指定時は既存キャッシュをフラッシュ | remount時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステムベースであり、RDBMS操作は行わない。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マウント | autofs_mount | CREATE | マウント情報構造体の生成 |
| ノード管理 | autofs_node | CREATE/DELETE | RB-tree上のノード管理 |
| リクエスト管理 | autofs_request | CREATE/READ/DELETE | automountdとの通信キュー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EINVAL | 不正パラメータ | 無効なマウントオプション | マウントオプションを確認 |
| ENXIO | デバイスなし | アンマウント時の未処理リクエスト | リクエストを自動キャンセル |
| ETIMEDOUT | タイムアウト | automountdの応答遅延 | timeout_task管理 |

### リトライ仕様

autofs_nodeのan_retriesカウンタによりリトライを管理。an_calloutによるタイマーベースの再試行。

## トランザクション仕様

autofs_mount構造体のam_lock（sx_lock）により排他制御。autofs_softcのsc_lock（sx_lock）でリクエストキューを保護。リクエストの完了通知はsc_cv（条件変数）で同期。

## パフォーマンス要件

キャッシュヒット時はカーネル内メモリ操作のみで完結。キャッシュミス時はautomountdとの通信が発生するため、ネットワークファイルシステムの場合はネットワーク遅延に依存。

## セキュリティ考慮事項

- /dev/autofsデバイスはautomountdのセッションIDで保護（sc_dev_sid）
- automountdはroot権限で動作
- マウントポイントのアクセス制御はマウント先ファイルシステムのパーミッションに従う

## 備考

- autofsはVFCF_SYNTHETICおよびVFCF_NETWORKフラグで登録されている
- MODULE_VERSION(autofs, 1)でバージョン管理
- usr.sbin/autofsディレクトリにautomount(8), automountd(8), autounmountd(8)の関連ユーザランドツールが存在

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | autofs.h | `sys/fs/autofs/autofs.h` | autofs_node（68-83行目）RB-treeノード、autofs_mount（85-95行目）マウント情報、autofs_request（97-112行目）デーモン通信構造、autofs_softc（114-123行目）デバイス制御 |

**読解のコツ**: autofs_nodeはRB-treeで管理されるファイルシステムノード。an_cachedフラグがマウント済みかの判定に使われ、an_calloutがタイムアウト管理に使われる。

#### Step 2: VFS操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | autofs_vfsops.c | `sys/fs/autofs/autofs_vfsops.c` | autofs_mount()（56-110行目）、autofs_unmount()（112-177行目）、autofs_root()（179-190行目） |

**主要処理フロー**:
1. **56-110行目**: autofs_mount() - マウントオプション解析、autofs_mount構造体初期化、ルートノード作成
2. **112-177行目**: autofs_unmount() - 未処理リクエストのENXIOキャンセル（137-154行目）、ノードツリーの非再帰的削除（161-167行目）
3. **207-217行目**: VFS操作テーブルとVFS_SET登録

#### Step 3: vnodeオペレーションとトリガ機構を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | autofs_vnops.c | `sys/fs/autofs/autofs_vnops.c` | lookup時のautofs_trigger呼び出し、readdir実装 |

#### Step 4: デーモン連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | autofs.c | `sys/fs/autofs/autofs.c` | /dev/autofsデバイス実装、ioctl処理、autofs_trigger/autofs_cached実装 |

### プログラム呼び出し階層図

```
VFS lookup (ディレクトリアクセス)
    |
    +-- autofs_vnops: lookup
    |       +-- autofs_trigger() [autofs.c]
    |       |       +-- autofs_cached() : キャッシュ判定
    |       |       +-- autofs_request生成
    |       |       +-- cv_wait() : automountd応答待ち
    |       +-- autofs_node_vn() : vnode取得
    |
automountd (ユーザ空間デーモン)
    |
    +-- ioctl(/dev/autofs, ...)
    |       +-- G_GATE_CMD_START相当 : リクエスト取得
    |       +-- mount実行
    |       +-- G_GATE_CMD_DONE相当 : 結果返却
    |
autofs_mount() [autofs_vfsops.c]
    +-- autofs_node_new() : ルートノード作成
    +-- sx_init() : ロック初期化

autofs_unmount() [autofs_vfsops.c]
    +-- リクエストキャンセル (ar_error = ENXIO)
    +-- autofs_node_delete() : ノードツリー解放
```

### データフロー図

```
[入力]                          [処理]                           [出力]

auto_masterマップ    ───▶ automount(8)             ───▶ mount -t autofs
                           (マウントポイント設定)

ディレクトリアクセス ───▶ autofs_trigger()         ───▶ autofs_request
(VFS lookup)               (トリガ判定)                  (/dev/autofs)
                                                           │
                                                           ▼
                          automountd(8)            ───▶ 実マウント実行
                           (デーモン処理)                  (NFS等)
                                                           │
                                                           ▼
                          autofs_cached更新        ───▶ ユーザアクセス可能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| autofs.h | `sys/fs/autofs/autofs.h` | ヘッダ | 主要データ構造・API定義 |
| autofs_vfsops.c | `sys/fs/autofs/autofs_vfsops.c` | ソース | VFS操作（mount/unmount/root/statfs） |
| autofs_vnops.c | `sys/fs/autofs/autofs_vnops.c` | ソース | vnodeオペレーション（lookup/readdir等） |
| autofs.c | `sys/fs/autofs/autofs.c` | ソース | デバイス管理、トリガ機構、キャッシュ管理 |
| autofs_ioctl.h | `sys/fs/autofs/autofs_ioctl.h` | ヘッダ | ioctlインタフェース定義 |
