# 機能設計書 23-ext2fs

## 概要

本ドキュメントは、FreeBSDにおけるLinux ext2/ext3/ext4ファイルシステムの読み書きサポート（ext2fs）の機能設計を記述する。ext2fsはLinuxで標準的に使用されるファイルシステムをFreeBSD上でマウント・読み書きするための機構を提供する。

### 本機能の処理概要

**業務上の目的・背景**：LinuxとFreeBSDのデュアルブート環境やLinuxパーティションへのデータアクセスが必要な場面で、ext2/ext3/ext4ファイルシステムをFreeBSDから直接読み書きする必要がある。本機能によりLinuxファイルシステムとの相互運用性を確保する。

**機能の利用シーン**：デュアルブート環境でのLinuxパーティションアクセス、Linuxフォーマットの外部ストレージの読み書き、クロスプラットフォームデータ移行。

**主要な処理内容**：
1. ext2/ext3/ext4ファイルシステムのマウント・アンマウント（ext2_mount / ext2_unmount）
2. スーパーブロック解析とファイルシステムメタデータ管理
3. inode管理（読み込み、更新、割り当て、解放）
4. ブロック割り当て・管理（ビットマップベース、エクステントベース）
5. ディレクトリ操作（lookup, readdir, create, remove等）
6. ジャーナリング対応（ext3/ext4のジャーナルログ）
7. 拡張属性（xattr）サポート
8. HTREEディレクトリインデックスサポート

**関連システム・外部連携**：GEOMストレージフレームワーク（ディスクアクセス層）、VFSフレームワーク

**権限による制御**：マウント操作にはroot権限が必要。リードオンリーマウントはMNT_RDONLYフラグで制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ファイルシステム操作（ブロックデバイスファイルシステム）/ CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fspath | char* | Yes | マウントポイントパス | 有効なディレクトリ |
| from | char* | Yes | デバイスパス（例: /dev/ada0s1） | 有効なブロックデバイス |
| MNT_RDONLY | flag | No | 読み取り専用マウント | - |

### 入力データソース

- ブロックデバイス上のext2/ext3/ext4ファイルシステムイメージ
- マウントコマンドオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| vnode | struct vnode* | ファイル/ディレクトリのvnode |
| statfs | struct statfs | ファイルシステム統計情報 |
| ファイルデータ | void* | 読み書きされるファイル内容 |

### 出力先

- VFSレイヤ経由でユーザ空間に公開
- ブロックデバイスへの書き込み（読み書きマウント時）

## 処理フロー

### 処理シーケンス

```
1. ext2_mount()
   └─ デバイスオープン
      ├─ ext2_mountfs() : スーパーブロック読み込み・検証
      │   ├─ シリンダグループ検証（ext2_cg_validate）
      │   ├─ スーパーブロックデータ計算（ext2_compute_sb_data）
      │   └─ ルートinode取得
      └─ vfs_mountedfrom設定
2. ファイルアクセス時
   └─ ext2_lookup → ext2_vget → inode読み込み
      ├─ エクステントベース: ext2_ext_balloc
      └─ ブロックマップベース: ext2_balloc
3. ファイル書き込み時
   └─ ext2_write → ブロック割り当て → デバイス書き込み
4. ext2_unmount()
   └─ ダーティバッファフラッシュ → デバイスクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[mount ext2fs] --> B[ext2_mountfs]
    B --> C[スーパーブロック読み込み]
    C --> D{スーパーブロック有効?}
    D -->|Yes| E[シリンダグループ検証]
    D -->|No| F[エラー返却]
    E --> G[ルートinode取得]
    G --> H[マウント完了]
    H --> I[ファイルアクセス]
    I --> J[ext2_lookup / ext2_vget]
    J --> K[inode読み込み]
    K --> L[データ読み書き]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | エクステント/ブロックマップ判定 | inodeのフラグでエクステントベースかブロックマップベースかを判定 | ファイルアクセス時 |
| BR-23-02 | ジャーナル非対応の制約 | ext3/ext4のジャーナル機能は完全にはサポートされない場合がある | マウント時 |
| BR-23-03 | リードオンリーフォールバック | ファイルシステムエラー検出時はリードオンリーに降格 | ファイルシステム不整合検出時 |

### 計算ロジック

ブロックアドレス計算: ブロックグループ番号 = (ブロック番号 - first_data_block) / blocks_per_group

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステムベースであり、RDBMS操作は行わない。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マウント | superblock | READ | スーパーブロック読み込み・検証 |
| ファイル操作 | inode | READ/WRITE | inode読み書き |
| ブロック管理 | block bitmap | READ/WRITE | ブロック割り当て・解放 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EINVAL | 不正パラメータ | スーパーブロックのマジック番号不一致 | ファイルシステムの整合性確認 |
| EIO | I/Oエラー | デバイス読み書き失敗 | デバイスの状態確認 |
| EROFS | 読み取り専用 | 読み取り専用FSへの書き込み試行 | 読み書きモードで再マウント |
| ENOSPC | 空き容量不足 | ブロック/inode割り当て失敗 | 不要ファイルの削除 |

### リトライ仕様

I/Oエラー時のリトライはGEOM/BIOレイヤに委譲。

## トランザクション仕様

バッファキャッシュによる遅延書き込み。sync(2)またはfsync(2)でディスクへの書き込みを保証。ext3/ext4のジャーナル機能のサポートは限定的。

## パフォーマンス要件

ブロックデバイスI/Oに依存。バッファキャッシュによる読み込みの高速化。HTREEインデックスにより大規模ディレクトリの検索を高速化。

## セキュリティ考慮事項

- マウント操作はroot権限が必要
- ファイルパーミッションはext2/ext3/ext4のinode情報に従う
- ACLサポート（ext2_acl.c）

## 備考

- SDT（DTrace）プローブが定義されており、トレーシングが可能（ext2_vfsops.c 68-76行目）
- ext4のエクステントベースのブロック管理をサポート（ext2_extents.c）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fs.h | `sys/fs/ext2fs/fs.h` | ext2fsスーパーブロック構造体 |
| 1-2 | ext2fs.h | `sys/fs/ext2fs/ext2fs.h` | メモリ上のスーパーブロック表現（m_ext2fs） |
| 1-3 | inode.h | `sys/fs/ext2fs/inode.h` | inode構造体定義 |
| 1-4 | ext2_dinode.h | `sys/fs/ext2fs/ext2_dinode.h` | ディスク上のinode表現 |
| 1-5 | ext2_mount.h | `sys/fs/ext2fs/ext2_mount.h` | マウント情報構造体 |

**読解のコツ**: ext2fsはUFS/FFSのコードをベースにしており、構造が類似している。ディスク上のバイトオーダーはリトルエンディアン。

#### Step 2: VFS操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ext2_vfsops.c | `sys/fs/ext2fs/ext2_vfsops.c` | ext2_mount/ext2_mountfs/ext2_unmount（78-80行目に前方宣言）、SDTプローブ定義（68-76行目） |

**主要処理フロー**:
1. **78行目**: ext2_flushfiles前方宣言
2. **79行目**: ext2_mountfs前方宣言 - スーパーブロック読み込み・検証の中核
3. **80行目**: ext2_reload前方宣言 - ファイルシステム再読み込み

#### Step 3: inode管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ext2_inode.c | `sys/fs/ext2fs/ext2_inode.c` | inode読み込み・書き込み・割り当て |
| 3-2 | ext2_inode_cnv.c | `sys/fs/ext2fs/ext2_inode_cnv.c` | ディスク/メモリ間のinode変換 |

#### Step 4: ブロック管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ext2_balloc.c | `sys/fs/ext2fs/ext2_balloc.c` | ブロック割り当て（従来方式） |
| 4-2 | ext2_extents.c | `sys/fs/ext2fs/ext2_extents.c` | エクステントベースのブロック管理（ext4） |
| 4-3 | ext2_alloc.c | `sys/fs/ext2fs/ext2_alloc.c` | ブロック/inode割り当てアルゴリズム |

#### Step 5: ディレクトリ操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ext2_lookup.c | `sys/fs/ext2fs/ext2_lookup.c` | ディレクトリエントリ検索 |
| 5-2 | ext2_htree.c | `sys/fs/ext2fs/ext2_htree.c` | HTREEディレクトリインデックス |
| 5-3 | ext2_hash.c | `sys/fs/ext2fs/ext2_hash.c` | ディレクトリハッシュ計算 |

#### Step 6: vnodeオペレーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | ext2_vnops.c | `sys/fs/ext2fs/ext2_vnops.c` | 全vnodeオペレーション実装 |

### プログラム呼び出し階層図

```
mount(2) "ext2fs"
    |
    +-- ext2_mount() [ext2_vfsops.c]
    |       +-- ext2_mountfs()
    |       |       +-- bread() : スーパーブロック読み込み
    |       |       +-- ext2_compute_sb_data()
    |       |       +-- ext2_cg_validate()
    |       +-- ext2_vget() : ルートinode取得
    |
    +-- VFS操作
    |       +-- ext2_lookup() [ext2_lookup.c]
    |       |       +-- ext2_htree_lookup() [ext2_htree.c]
    |       +-- ext2_read/ext2_write [ext2_vnops.c]
    |       |       +-- ext2_balloc() / ext2_ext_balloc()
    |       +-- ext2_create/ext2_remove [ext2_vnops.c]
    |               +-- ext2_alloc() [ext2_alloc.c]
    |
    +-- ext2_unmount() [ext2_vfsops.c]
            +-- ext2_flushfiles()
            +-- g_vfs_close()
```

### データフロー図

```
[入力]                          [処理]                           [出力]

ブロックデバイス     ───▶ ext2_mountfs()           ───▶ m_ext2fs
(/dev/adaXsY)            (スーパーブロック解析)          (メモリ上のFS情報)
                                                           │
ファイルパス         ───▶ ext2_lookup()             ───▶ inode
(VFS namei)              (ディレクトリ検索)               (ファイルメタデータ)
                                                           │
read/write要求      ───▶ ext2_read/ext2_write     ───▶ ファイルデータ
                          (ブロックI/O)                    (バッファキャッシュ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs.h | `sys/fs/ext2fs/fs.h` | ヘッダ | スーパーブロック構造体 |
| ext2fs.h | `sys/fs/ext2fs/ext2fs.h` | ヘッダ | メモリ上のFS構造体 |
| inode.h | `sys/fs/ext2fs/inode.h` | ヘッダ | inode構造体 |
| ext2_dinode.h | `sys/fs/ext2fs/ext2_dinode.h` | ヘッダ | ディスク上inode |
| ext2_mount.h | `sys/fs/ext2fs/ext2_mount.h` | ヘッダ | マウント情報 |
| ext2_extern.h | `sys/fs/ext2fs/ext2_extern.h` | ヘッダ | 外部関数宣言 |
| ext2_vfsops.c | `sys/fs/ext2fs/ext2_vfsops.c` | ソース | VFS操作 |
| ext2_vnops.c | `sys/fs/ext2fs/ext2_vnops.c` | ソース | vnodeオペレーション |
| ext2_inode.c | `sys/fs/ext2fs/ext2_inode.c` | ソース | inode管理 |
| ext2_inode_cnv.c | `sys/fs/ext2fs/ext2_inode_cnv.c` | ソース | inode変換 |
| ext2_alloc.c | `sys/fs/ext2fs/ext2_alloc.c` | ソース | ブロック/inode割り当て |
| ext2_balloc.c | `sys/fs/ext2fs/ext2_balloc.c` | ソース | ブロック割り当て |
| ext2_extents.c | `sys/fs/ext2fs/ext2_extents.c` | ソース | エクステント管理 |
| ext2_lookup.c | `sys/fs/ext2fs/ext2_lookup.c` | ソース | ディレクトリ検索 |
| ext2_htree.c | `sys/fs/ext2fs/ext2_htree.c` | ソース | HTREEインデックス |
| ext2_hash.c | `sys/fs/ext2fs/ext2_hash.c` | ソース | ハッシュ計算 |
| ext2_subr.c | `sys/fs/ext2fs/ext2_subr.c` | ソース | ユーティリティ関数 |
| ext2_acl.c | `sys/fs/ext2fs/ext2_acl.c` | ソース | ACLサポート |
| ext2_extattr.c | `sys/fs/ext2fs/ext2_extattr.c` | ソース | 拡張属性サポート |
| ext2_csum.c | `sys/fs/ext2fs/ext2_csum.c` | ソース | チェックサム計算 |
| ext2_bmap.c | `sys/fs/ext2fs/ext2_bmap.c` | ソース | ブロックマッピング |
