# 機能設計書 24-tarfs

## 概要

本ドキュメントは、FreeBSDのtarfs（tarアーカイブファイルシステム）の機能設計を記述する。tarfsはtarアーカイブをファイルシステムとして直接マウントする機構を提供し、アーカイブ内のファイルにファイルシステム操作でアクセスできるようにする。

### 本機能の処理概要

**業務上の目的・背景**：tarアーカイブ内のファイルに対して、展開せずに直接ファイルシステム操作でアクセスしたい場面がある。パッケージインストールやコンテナイメージのマウントなど、tarアーカイブの内容を読み取り専用で透過的に参照する用途に対応する。zstd圧縮されたtarアーカイブもサポートする。

**機能の利用シーン**：tarアーカイブの内容確認、コンテナイメージのマウント、パッケージ内容の直接参照、圧縮tarアーカイブのオンデマンド展開。

**主要な処理内容**：
1. tarアーカイブのマウント（UStar形式ヘッダの解析）
2. アーカイブ内ファイルのvnodeオペレーション（read, lookup, readdir等）
3. スパースファイルのブロックマップ管理
4. zstd圧縮アーカイブの透過的解凍（tarfs_zio）
5. ファイル属性（uid/gid/mode/mtime）の保持

**関連システム・外部連携**：GEOMストレージフレームワーク（ブロックデバイスアクセス）、zstdライブラリ（圧縮アーカイブ対応）

**権限による制御**：マウント操作にはroot権限が必要。アーカイブ内ファイルのパーミッションはtarヘッダに記録された値に従う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ファイルシステム操作（読み取り専用アーカイブファイルシステム）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fspath | char* | Yes | マウントポイントパス | 有効なディレクトリ |
| from | char* | Yes | tarアーカイブファイルパスまたはデバイスパス | 有効なファイル/デバイス |

### 入力データソース

- tarアーカイブファイル（UStar形式）
- オプションでzstd圧縮されたtarアーカイブ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| vnode | struct vnode* | アーカイブ内ファイル/ディレクトリのvnode |
| ファイルデータ | void* | アーカイブ内ファイルの内容 |

### 出力先

- VFSレイヤ経由でユーザ空間に読み取り専用で公開

## 処理フロー

### 処理シーケンス

```
1. tarfs_mount() [tarfs_vfsops.c]
   └─ アーカイブオープン
      ├─ UStarヘッダの順次解析
      │   ├─ 各エントリのtarfs_node作成
      │   ├─ ディレクトリツリー構築
      │   └─ スパースファイルのブロックマップ構築
      ├─ zstd圧縮の場合: tarfs_io_init()
      └─ ルートノード設定
2. ファイルアクセス時
   └─ tarfs_lookup → tarfs_node検索
      ├─ tarfs_read_file : ファイルデータ読み込み
      └─ 圧縮時: tarfs_io_read → zstd解凍
3. tarfs_unmount()
   └─ tarfs_io_fini() → ノード解放 → デバイスクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[mount tarfs] --> B[アーカイブオープン]
    B --> C{zstd圧縮?}
    C -->|Yes| D[tarfs_io_init: 解凍初期化]
    C -->|No| E[直接読み込み]
    D --> F[UStarヘッダ順次解析]
    E --> F
    F --> G[tarfs_node生成・ツリー構築]
    G --> H[マウント完了]
    H --> I[ファイルアクセス]
    I --> J{圧縮アーカイブ?}
    J -->|Yes| K[tarfs_io_read: zstd解凍]
    J -->|No| L[直接ブロック読み込み]
    K --> M[データ返却]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 読み取り専用 | tarfsは読み取り専用ファイルシステムである | 常時 |
| BR-24-02 | UStar形式必須 | tarアーカイブはUStar形式である必要がある | マウント時 |
| BR-24-03 | 512バイトアラインメント | tarアーカイブ内のデータは512バイト境界でアラインされる | 常時（TARFS_BLOCKSIZE=512） |
| BR-24-04 | スパースファイル対応 | スパースファイルはブロックマップで管理される | スパースファイルアクセス時 |

### 計算ロジック

ブロック数計算: TARFS_SZ2BLKS(sz) = (sz + TARFS_BLOCKSIZE - 1) / TARFS_BLOCKSIZE

## データベース操作仕様

本機能はファイルシステムベースであり、RDBMS操作は行わない。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マウント | tarfs_mount/tarfs_node | CREATE | アーカイブ解析・ノードツリー構築 |
| ファイル読み込み | tarfs_blk | READ | ブロックマップに基づくデータ読み込み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EINVAL | 不正パラメータ | UStarヘッダのマジック番号不一致 | 正しいtarアーカイブを指定 |
| EIO | I/Oエラー | アーカイブ読み込み失敗 | デバイス/ファイルの状態確認 |
| ERANGE | 範囲外 | チェックサム不一致 | アーカイブの整合性確認 |

### リトライ仕様

I/Oエラー時のリトライはGEOM/BIOレイヤに委譲。

## トランザクション仕様

読み取り専用ファイルシステムのため、トランザクション管理は不要。

## パフォーマンス要件

- zstd解凍バッファサイズ: TARFS_ZBUF_SIZE = 1MB
- I/Oサイズ: tarfs_ioshiftで制御（デフォルトPAGE_SHIFT）
- zstd圧縮フレームのインデックス（tarfs_idx）によりランダムアクセスを高速化

## セキュリティ考慮事項

- アーカイブ内のファイルパーミッションを忠実に再現
- PRIV_VFS_MOUNT権限によるマウント操作の制限

## 備考

- Juniper NetworksおよびKlara, Inc.による開発（2013年、2022-2024年）
- opt_tarfs.hによるコンパイル時オプション設定
- TARFS_ZIO_NAME = ".tar" で圧縮データ用の内部ノードを管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tarfs.h | `sys/fs/tarfs/tarfs.h` | tarfs_node（51-104行目）ファイルノード、tarfs_blk（109-113行目）スパースブロックマップ、tarfs_zbuf（118-123行目）解凍バッファ、tarfs_mount（128-144行目）マウント情報、tarfs_zio（146-161行目）圧縮I/O状態 |

**読解のコツ**: tarfs_nodeの共用体（84-103行目）でVDIR/VLNK/VBLK/VCHR/VREGの各タイプ固有データを管理。tarfs_blkのi（物理オフセット）、o（論理オフセット）、l（長さ）でスパースファイルを表現。

#### Step 2: VFS操作とアーカイブ解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tarfs_vfsops.c | `sys/fs/tarfs/tarfs_vfsops.c` | struct ustar_header（61-79行目）UStar形式ヘッダ定義、tarfs_mount/tarfs_unmount |

**主要処理フロー**:
- **61-79行目**: UStarヘッダ構造体 - name(100), mode(8), uid(8), gid(8), size(12), mtime(12), checksum(8), typeflag(1)等のフィールド

#### Step 3: I/O処理と圧縮対応を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tarfs_io.c | `sys/fs/tarfs/tarfs_io.c` | tarfs_io_init/tarfs_io_fini/tarfs_io_read実装、zstd解凍処理 |

#### Step 4: ノード管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tarfs_subr.c | `sys/fs/tarfs/tarfs_subr.c` | tarfs_alloc_node/tarfs_free_node/tarfs_lookup_node/tarfs_read_file |

#### Step 5: vnodeオペレーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | tarfs_vnops.c | `sys/fs/tarfs/tarfs_vnops.c` | lookup/readdir/read等の実装 |

### プログラム呼び出し階層図

```
mount(2) "tarfs"
    |
    +-- tarfs_mount() [tarfs_vfsops.c]
    |       +-- UStarヘッダ順次解析
    |       |       +-- tarfs_alloc_node() [tarfs_subr.c]
    |       |       +-- tarfs_load_blockmap() [tarfs_subr.c]
    |       +-- tarfs_io_init() [tarfs_io.c] (圧縮時)
    |
    +-- VFS操作
    |       +-- tarfs_lookup() [tarfs_vnops.c]
    |       |       +-- tarfs_lookup_node() [tarfs_subr.c]
    |       +-- tarfs_read() [tarfs_vnops.c]
    |               +-- tarfs_read_file() [tarfs_subr.c]
    |                       +-- tarfs_io_read() [tarfs_io.c] (圧縮時)
    |
    +-- tarfs_unmount() [tarfs_vfsops.c]
            +-- tarfs_io_fini()
            +-- tarfs_free_node() (全ノード)
```

### データフロー図

```
[入力]                          [処理]                           [出力]

tarアーカイブ       ───▶ UStarヘッダ解析          ───▶ tarfs_nodeツリー
(.tar / .tar.zst)        [tarfs_vfsops.c]               (メモリ上)
                                                           │
ファイルパス         ───▶ tarfs_lookup_node()      ───▶ tarfs_node
(VFS namei)              [tarfs_subr.c]                    │
                                                           ▼
read要求            ───▶ tarfs_read_file()        ───▶ ファイルデータ
                         [tarfs_subr.c]
                              │
                    (圧縮時)  ▼
                         tarfs_io_read()
                         [tarfs_io.c]
                              │
                              ▼
                         zstd解凍
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tarfs.h | `sys/fs/tarfs/tarfs.h` | ヘッダ | 主要データ構造・API・マクロ定義 |
| tarfs_vfsops.c | `sys/fs/tarfs/tarfs_vfsops.c` | ソース | VFS操作・UStarヘッダ解析 |
| tarfs_vnops.c | `sys/fs/tarfs/tarfs_vnops.c` | ソース | vnodeオペレーション |
| tarfs_subr.c | `sys/fs/tarfs/tarfs_subr.c` | ソース | ノード管理・ファイル読み込み |
| tarfs_io.c | `sys/fs/tarfs/tarfs_io.c` | ソース | I/O処理・zstd圧縮対応 |
| tarfs_dbg.h | `sys/fs/tarfs/tarfs_dbg.h` | ヘッダ | デバッグ用マクロ |
