# 機能設計書 25-UDF

## 概要

本ドキュメントは、FreeBSDにおけるUDF（Universal Disk Format）ファイルシステムサポートの機能設計を記述する。UDFはDVD、Blu-ray等の光学メディアで使用されるファイルシステム規格であり、ECMA-167/ISO 13346標準に基づく。

### 本機能の処理概要

**業務上の目的・背景**：DVD-ROM、DVD-R/RW、Blu-rayディスク等の光学メディアに記録されたデータをFreeBSD上で読み取るためにUDFファイルシステムのサポートが必要である。UDFは光学メディアの標準ファイルシステムとして広く採用されている。

**機能の利用シーン**：DVD-ROMやBlu-rayディスクのマウント、DVD-Rに書き込まれたデータの読み取り、UDFフォーマットされたUSBメモリの読み取り。

**主要な処理内容**：
1. UDFファイルシステムのマウント・アンマウント
2. Anchor Volume Descriptor Pointer（AVDP）の検索・解析
3. Main Volume Descriptor Sequence（MVDS）の解析
4. Partition DescriptorとLogical Volume Descriptorの解析
5. File Set Descriptorからのルートディレクトリ取得
6. File EntryとFile Identifier Descriptorの読み取り
7. Sparing Table対応（不良セクタの代替処理）
8. iconv文字コード変換対応

**関連システム・外部連携**：GEOMストレージフレームワーク、光学ドライブデバイスドライバ、iconvライブラリ

**権限による制御**：マウント操作にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ファイルシステム操作（光学メディア読み取り）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fspath | char* | Yes | マウントポイントパス | 有効なディレクトリ |
| from | char* | Yes | デバイスパス（例: /dev/cd0） | 有効なブロックデバイス |

### 入力データソース

- UDFフォーマットされた光学メディアまたはブロックデバイス
- mount_udf(8)コマンドオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| vnode | struct vnode* | ファイル/ディレクトリのvnode |
| ファイルデータ | void* | ファイルの内容 |
| statfs | struct statfs | ファイルシステム統計情報 |

### 出力先

- VFSレイヤ経由でユーザ空間に公開

## 処理フロー

### 処理シーケンス

```
1. udf_mount()
   └─ デバイスオープン
      ├─ Anchor Volume Descriptor Pointer検索（セクタ256, n, n-256, 512）
      ├─ Main Volume Descriptor Sequence解析
      │   ├─ Partition Descriptor → パーティション情報取得
      │   └─ Logical Volume Descriptor → 論理ボリューム情報取得
      ├─ Fileset Descriptor解析
      │   └─ ルートディレクトリのICB（Information Control Block）取得
      └─ ルートvnode取得（udf_vget）
2. ファイルアクセス時
   └─ udf_lookup → File Identifier Descriptor検索
      └─ udf_vget → File Entry読み込み → ファイルデータアクセス
3. udf_unmount()
   └─ リソース解放 → デバイスクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[mount udf] --> B[AVDP検索]
    B --> C{AVDP発見?}
    C -->|Yes| D[MVDS解析]
    C -->|No| E[エラー: 無効なUDF]
    D --> F[Partition Descriptor]
    D --> G[Logical Volume Descriptor]
    F --> H[Fileset Descriptor]
    G --> H
    H --> I[ルートディレクトリICB取得]
    I --> J[udf_vget: ルートvnode]
    J --> K[マウント完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | AVDP検索順序 | セクタ256 → セクタn → セクタn-256 → セクタ512の順で検索 | マウント時 |
| BR-25-02 | DescriptorTag検証 | 全記述子はudf_checktag()で整合性を検証 | 記述子読み込み時 |
| BR-25-03 | Sparing Table対応 | 不良セクタはSparing Tableで代替セクタにマッピング | セクタアクセス時 |
| BR-25-04 | fileno生成 | ファイル番号はICBのlb_numから生成: le32toh(icb->loc.lb_num) | ファイルアクセス時 |

### 計算ロジック

ファイル番号計算: udf_getid(icb) = le32toh(icb->loc.lb_num)
セクタ読み込み: RDSECTOR(devvp, sector, size, bp) = bread(devvp, sector << (bshift - DEV_BSHIFT), size, NOCRED, bp)

## データベース操作仕様

本機能はファイルシステムベースであり、RDBMS操作は行わない。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マウント | udf_mnt | CREATE | UDFメタデータ構造体の生成 |
| ファイル読み取り | udf_node | READ | File Entry / File Identifier Descriptor読み取り |
| ディレクトリ走査 | udf_dirstream | READ | ディレクトリストリーム順次読み取り |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EINVAL | 不正パラメータ | AVDP未発見またはDescriptorTag不一致 | 正しいUDFメディアを使用 |
| EIO | I/Oエラー | デバイス読み込み失敗 | メディア/デバイスの状態確認 |
| ERANGE | 範囲外 | 読み込みサイズがオーバーフロー | udf_readdevblksで事前チェック |

### リトライ仕様

光学メディアのI/Oエラー時のリトライはデバイスドライバレイヤに委譲。

## トランザクション仕様

読み取り専用ファイルシステムのため、トランザクション管理は不要。

## パフォーマンス要件

光学メディアのI/O速度に依存。UDF_HASHTBLSIZE（100エントリ）によるハッシュテーブルでノードの高速検索。

## セキュリティ考慮事項

- マウント操作はroot権限が必要
- ファイルパーミッションはUDF File Entryのpermissions/ownerフィールドに従う

## 備考

- 未クローズのCDメディアではセクタ256に書き込めないため、セクタ512にAVDPが存在する場合がある
- iconv文字コード変換による多言語ファイル名対応（udf_iconv.c）
- uma_zoneによるメモリ管理（udf_zone_trans, udf_zone_node, udf_zone_ds）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | udf.h | `sys/fs/udf/udf.h` | udf_node（31-37行目）、udf_mnt（39-60行目）、udf_dirstream（62-75行目）、ifid（77-82行目） |
| 1-2 | ecma167-udf.h | `sys/fs/udf/ecma167-udf.h` | ECMA-167標準のデータ構造（Descriptor Tag、AVDP、File Entry等） |

**読解のコツ**: udf_mntのpart_start/part_lenがパーティション物理位置を示し、root_icbがルートディレクトリのICBを保持する。RDSECTORマクロ（92-93行目）がセクタ読み込みの基本操作。

#### Step 2: VFS操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | udf_vfsops.c | `sys/fs/udf/udf_vfsops.c` | AVDP検索ロジック（コメント33-72行目にUDF構造の概要図）、udf_mount/udf_unmount |

**主要処理フロー**:
- **33-72行目（コメント）**: UDFメディア構造の概要図。AVDP → MVDS → Logical Volume Descriptor → Fileset Descriptor → Root Dir File Entry → File Dataの階層構造

#### Step 3: vnodeオペレーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | udf_vnops.c | `sys/fs/udf/udf_vnops.c` | lookup/readdir/read等の実装 |

### プログラム呼び出し階層図

```
mount(2) "udf"
    |
    +-- udf_mount() [udf_vfsops.c]
    |       +-- bread() : AVDP読み込み（セクタ256等）
    |       +-- udf_checktag() : Descriptor Tag検証
    |       +-- MVDS解析
    |       |       +-- Partition Descriptor処理
    |       |       +-- Logical Volume Descriptor処理
    |       +-- Fileset Descriptor解析
    |       +-- udf_vget() : ルートvnode取得
    |
    +-- VFS操作
    |       +-- udf_lookup() [udf_vnops.c]
    |       |       +-- File Identifier Descriptor検索
    |       +-- udf_read() [udf_vnops.c]
    |       |       +-- udf_readdevblks() [udf.h:98]
    |       +-- udf_readdir() [udf_vnops.c]
    |               +-- udf_dirstream走査
    |
    +-- udf_unmount() [udf_vfsops.c]
            +-- リソース解放
```

### データフロー図

```
[入力]                              [処理]                         [出力]

光学メディア
  セクタ256/n/n-256/512 ───▶ AVDP解析              ───▶ MVDS位置
                                                            │
  MVDS領域            ───▶ Volume Descriptor解析  ───▶ パーティション情報
                                                            │
  Fileset Descriptor  ───▶ Root ICB取得           ───▶ ルートvnode
                                                            │
  File Entry          ───▶ udf_vget()              ───▶ ファイルvnode
                                                            │
  File Data           ───▶ udf_read()              ───▶ ユーザデータ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| udf.h | `sys/fs/udf/udf.h` | ヘッダ | メモリ上データ構造・マクロ定義 |
| ecma167-udf.h | `sys/fs/udf/ecma167-udf.h` | ヘッダ | ECMA-167標準データ構造 |
| udf_mount.h | `sys/fs/udf/udf_mount.h` | ヘッダ | マウントオプション定義 |
| udf_vfsops.c | `sys/fs/udf/udf_vfsops.c` | ソース | VFS操作 |
| udf_vnops.c | `sys/fs/udf/udf_vnops.c` | ソース | vnodeオペレーション |
| udf_iconv.c | `sys/fs/udf/udf_iconv.c` | ソース | 文字コード変換 |
| osta.c | `sys/fs/udf/osta.c` | ソース | OSTA準拠ユーティリティ |
| osta.h | `sys/fs/udf/osta.h` | ヘッダ | OSTA定義 |
