# 機能設計書 28-GEOMミラー・ストライプ・RAID

## 概要

本ドキュメントは、FreeBSDのGEOMフレームワーク上で動作するソフトウェアRAID機構（ミラーリング、ストライピング、RAID3、RAID）の機能設計を記述する。これらのGEOMクラスはディスクの冗長化・高速化をソフトウェアレベルで実現する。

### 本機能の処理概要

**業務上の目的・背景**：ハードウェアRAIDコントローラなしにディスクの冗長性と性能を確保する必要がある。GEOMミラー（gmirror）はデータの完全複製、ストライプ（gstripe）はデータ分散による高速化、RAID3は専用パリティディスク方式、GEOMソフトウェアRAIDは各種RAID方式（RAID0/1/1E/5）を提供する。

**機能の利用シーン**：ブートディスクのミラーリング、データベースサーバのRAID構成、高速I/Oが必要なストレージのストライピング、ハードウェアRAIDメタデータの自動認識。

**主要な処理内容**：
1. **gmirror**: ディスクミラーリング（RAID1）- 複数ディスクへの同一データ書き込み、読み込み負荷分散
2. **gstripe**: ストライピング（RAID0）- データを複数ディスクに分散して書き込み
3. **graid3**: RAID3 - 専用パリティディスクによるデータ保護
4. **graid**: ソフトウェアRAID - 複数のメタデータ形式（DDF, Intel, JMicron, NVIDIA, Promise, SiI）サポート、RAID0/1/1E/5変換モジュール

**関連システム・外部連携**：GEOMストレージフレームワーク（親フレームワーク）

**権限による制御**：RAID操作にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ストレージ冗長化 / データ保護 / 性能最適化

## 入力仕様

### 入力パラメータ

#### gmirror

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | char* | Yes | ミラー名 | 一意性チェック |
| balance | int | No | 読み込み負荷分散アルゴリズム | NONE/ROUND_ROBIN/LOAD/SPLIT/PREFER |
| providers | char*[] | Yes | 構成ディスク | 最低1台 |

#### gstripe

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | char* | Yes | ストライプ名 | 一意性チェック |
| stripesize | int | Yes | ストライプサイズ | 2の累乗 |
| providers | char*[] | Yes | 構成ディスク | 最低2台 |

### 入力データソース

- ユーザ空間コマンド（gmirror/gstripe/graid3/graid）からのgctl制御リクエスト
- ディスク末尾のメタデータ（taste時の自動認識）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| provider | g_provider* | RAID/ミラー/ストライプデバイス |
| 変換済みI/O | bio* | 各構成ディスクへの分散I/O |

### 出力先

- GEOMプロバイダとして上位層に公開（例: /dev/mirror/gm0）

## 処理フロー

### 処理シーケンス（gmirror）

```
1. gmirror label（初期化）
   └─ メタデータ作成・各ディスク末尾に書き込み
2. gmirror taste（自動認識）
   └─ ディスク末尾のメタデータ読み込み
      └─ マッチ時: ミラーデバイス作成
3. 書き込みI/O
   └─ 全構成ディスクに同一データを書き込み
4. 読み込みI/O
   └─ balance algorithmに従い1台から読み込み
      ├─ NONE: 最初のディスク
      ├─ ROUND_ROBIN: 順番に分散
      ├─ LOAD: 負荷が最も低いディスク
      ├─ SPLIT: オフセットで分散
      └─ PREFER: 優先ディスク
5. ディスク障害時
   └─ DIRTY/BROKENフラグ設定 → 同期処理開始
```

### フローチャート

```mermaid
flowchart TD
    A[I/Oリクエスト] --> B{読み込み/書き込み?}
    B -->|Write| C[全ディスクに書き込み]
    B -->|Read| D{balance algorithm}
    D -->|NONE| E[最初のディスク]
    D -->|ROUND_ROBIN| F[順番に分散]
    D -->|LOAD| G[最低負荷ディスク]
    D -->|SPLIT| H[オフセット分散]
    D -->|PREFER| I[優先ディスク]
    C --> J[完了通知]
    E --> J
    F --> J
    G --> J
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | ミラーバランスアルゴリズム | 5種類のread balancingアルゴリズムを提供 | gmirror読み込み時 |
| BR-28-02 | ディスク同期 | DIRTY/SYNCHRONIZINGフラグで同期状態を管理 | ディスク追加/障害回復時 |
| BR-28-03 | NOAUTOSYNC | 自動同期を無効化するデバイスフラグ | G_MIRROR_DEVICE_FLAG_NOAUTOSYNC設定時 |
| BR-28-04 | NOFAILSYNC | 障害時同期を無効化 | G_MIRROR_DEVICE_FLAG_NOFAILSYNC設定時 |
| BR-28-05 | CANDELETE | TRIM/DISCARDサポート | ディスクがCANDELETEフラグを持つ場合 |
| BR-28-06 | RAIDメタデータ形式 | DDF/Intel/JMicron/NVIDIA/Promise/SiIの6形式サポート | graid taste時 |

### 計算ロジック

- ストライプオフセット: target_disk = (offset / stripesize) % num_disks
- パリティ計算（RAID3/5）: parity = XOR(data_blocks)

## データベース操作仕様

本機能はカーネル内ストレージ管理であり、RDBMS操作は行わない。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 初期化 | メタデータ | CREATE | ディスク末尾にRAIDメタデータ書き込み |
| I/O処理 | bio | READ/WRITE | I/Oの分散・集約処理 |
| 同期 | ディスクデータ | WRITE | 障害回復時のデータ同期 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EIO | I/Oエラー | 構成ディスクのI/O障害 | ミラー:フェイルオーバー、RAID:冗長性に依存 |
| ENXIO | デバイスなし | 構成ディスクの脱落 | ディスク交換・同期 |
| EINVAL | 不正パラメータ | メタデータ不整合 | メタデータ修復 |

### リトライ仕様

gmirror: 障害ディスクをBROKENとマークし、残存ディスクにフェイルオーバー。同期処理は自動的に再開。

## トランザクション仕様

メタデータ更新時はトランザクション的な書き込み。I/O処理は構成ディスク全体への書き込み完了で上位層に完了通知。

## パフォーマンス要件

- gmirror: balance algorithmの選択で読み込み性能を最適化
- gstripe: 構成ディスク数に比例した読み書き帯域
- 同期処理はバックグラウンドで実行（通常I/Oへの影響を最小化）

## セキュリティ考慮事項

- RAID操作にはroot権限が必要
- メタデータの整合性チェック（MD5ハッシュ）

## 備考

- gmirrorバージョン4が最新（md_genid, md_provsize, nofailsync対応）
- graidは複数のハードウェアRAIDコントローラのメタデータ形式を自動認識可能
- graid3は専用パリティディスク方式で、現在はgraidの使用が推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | g_mirror.h | `sys/geom/mirror/g_mirror.h` | G_MIRROR_VERSION=4（46行目）、バランスアルゴリズム定義（48-54行目）、ディスクフラグ（56-62行目）、デバイスフラグ（71-76行目） |
| 1-2 | g_stripe.h | `sys/geom/stripe/g_stripe.h` | ストライプ固有の構造体・パラメータ |
| 1-3 | g_raid.h | `sys/geom/raid/g_raid.h` | RAID共通構造体 |
| 1-4 | g_raid3.h | `sys/geom/raid3/g_raid3.h` | RAID3固有の構造体 |

**読解のコツ**: g_mirror.hのフラグ定義が動作理解の鍵。DISK_FLAG_DIRTY(同期必要)、DISK_FLAG_SYNCHRONIZING(同期中)、DISK_FLAG_BROKEN(障害)の状態遷移を理解する。

#### Step 2: ミラーリング実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | g_mirror.c | `sys/geom/mirror/g_mirror.c` | メイン実装（taste, start, ctl） |
| 2-2 | g_mirror_ctl.c | `sys/geom/mirror/g_mirror_ctl.c` | 制御操作（label, insert, remove等） |

#### Step 3: ストライピング実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | g_stripe.c | `sys/geom/stripe/g_stripe.c` | ストライプ全実装 |

#### Step 4: ソフトウェアRAID実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | g_raid.c | `sys/geom/raid/g_raid.c` | RAIDコア（taste, ctl） |
| 4-2 | g_raid_ctl.c | `sys/geom/raid/g_raid_ctl.c` | RAID制御操作 |
| 4-3 | tr_raid0.c | `sys/geom/raid/tr_raid0.c` | RAID0変換モジュール |
| 4-4 | tr_raid1.c | `sys/geom/raid/tr_raid1.c` | RAID1変換モジュール |
| 4-5 | tr_raid5.c | `sys/geom/raid/tr_raid5.c` | RAID5変換モジュール |
| 4-6 | md_intel.c | `sys/geom/raid/md_intel.c` | Intelメタデータドライバ |
| 4-7 | md_ddf.c | `sys/geom/raid/md_ddf.c` | DDFメタデータドライバ |

### プログラム呼び出し階層図

```
gmirror label/insert (ユーザ空間)
    └─ g_mirror_ctl.c: 制御操作
            +-- メタデータ作成
            +-- ディスク追加

gmirror taste (自動認識)
    └─ g_mirror.c: taste()
            +-- メタデータ読み込み・検証
            +-- ミラーデバイス作成

I/O処理 (gmirror)
    └─ g_mirror.c: start()
            +-- Write: 全ディスクへBIO複製
            +-- Read: balance algorithmでディスク選択
            └─ g_io_request() → 構成ディスク

同期処理
    └─ g_mirror.c: sync thread
            +-- ソースディスクから読み込み
            +-- ターゲットディスクへ書き込み
            +-- SYNCHRONIZINGフラグ管理
```

### データフロー図

```
[入力]                          [処理]                           [出力]

書き込みリクエスト   ───▶ gmirror: BIO複製          ───▶ Disk1, Disk2, ...
                          gstripe: オフセット分散         (各構成ディスク)
                          graid: RAID方式で分散

読み込みリクエスト   ───▶ gmirror: balance選択      ───▶ 選択されたディスク
                          gstripe: オフセット計算         (1台から読み込み)
                          graid: RAID方式で読み込み

障害検出            ───▶ フラグ更新                 ───▶ 同期処理開始
                          (DIRTY/BROKEN)                  (バックグラウンド)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| g_mirror.h | `sys/geom/mirror/g_mirror.h` | ヘッダ | ミラー構造体・フラグ |
| g_mirror.c | `sys/geom/mirror/g_mirror.c` | ソース | ミラーメイン実装 |
| g_mirror_ctl.c | `sys/geom/mirror/g_mirror_ctl.c` | ソース | ミラー制御操作 |
| g_stripe.h | `sys/geom/stripe/g_stripe.h` | ヘッダ | ストライプ構造体 |
| g_stripe.c | `sys/geom/stripe/g_stripe.c` | ソース | ストライプ実装 |
| g_raid3.h | `sys/geom/raid3/g_raid3.h` | ヘッダ | RAID3構造体 |
| g_raid3.c | `sys/geom/raid3/g_raid3.c` | ソース | RAID3メイン実装 |
| g_raid3_ctl.c | `sys/geom/raid3/g_raid3_ctl.c` | ソース | RAID3制御操作 |
| g_raid.h | `sys/geom/raid/g_raid.h` | ヘッダ | RAID共通構造体 |
| g_raid.c | `sys/geom/raid/g_raid.c` | ソース | RAIDコア実装 |
| g_raid_ctl.c | `sys/geom/raid/g_raid_ctl.c` | ソース | RAID制御操作 |
| tr_raid0.c | `sys/geom/raid/tr_raid0.c` | ソース | RAID0変換 |
| tr_raid1.c | `sys/geom/raid/tr_raid1.c` | ソース | RAID1変換 |
| tr_raid1e.c | `sys/geom/raid/tr_raid1e.c` | ソース | RAID1E変換 |
| tr_raid5.c | `sys/geom/raid/tr_raid5.c` | ソース | RAID5変換 |
| tr_concat.c | `sys/geom/raid/tr_concat.c` | ソース | CONCAT変換 |
| md_ddf.c | `sys/geom/raid/md_ddf.c` | ソース | DDFメタデータ |
| md_intel.c | `sys/geom/raid/md_intel.c` | ソース | Intelメタデータ |
| md_jmicron.c | `sys/geom/raid/md_jmicron.c` | ソース | JMicronメタデータ |
| md_nvidia.c | `sys/geom/raid/md_nvidia.c` | ソース | NVIDIAメタデータ |
| md_promise.c | `sys/geom/raid/md_promise.c` | ソース | Promiseメタデータ |
| md_sii.c | `sys/geom/raid/md_sii.c` | ソース | SiIメタデータ |
