# 機能設計書 35-ネットワークインタフェース管理

## 概要

本ドキュメントは、FreeBSDにおけるネットワークインタフェースの構成・管理（IPアドレス設定・フラグ制御等）を行うifconfigコマンドおよびカーネルネットワークインタフェース層の機能設計書である。

### 本機能の処理概要

ifconfigは、ネットワークインタフェースの作成・設定・表示・削除を行うユーザ空間コマンドである。IPアドレスの設定、MTUの変更、インタフェースのup/down、VLAN/ブリッジ/LAGGなどの仮想インタフェース管理等、ネットワーク構成の中核的な操作を提供する。

**業務上の目的・背景**：サーバやネットワーク機器のネットワーク設定は運用上最も基本的な管理作業であり、IPアドレスの割り当て、ネットワーク接続の有効化/無効化、仮想インタフェースの構成などが頻繁に必要となる。

**機能の利用シーン**：システム初期構成時のネットワーク設定、bsdinstallでのインストール時ネットワーク構成、運用中のインタフェース状態確認、トラブルシューティング、仮想インタフェース（VLAN, ブリッジ, LAGG等）の構成で利用される。

**主要な処理内容**：
1. ネットワークインタフェースの一覧表示・状態表示
2. IPv4/IPv6アドレスの設定・削除
3. インタフェースのup/down制御
4. MTU、メトリック、メディア設定の変更
5. 仮想インタフェース（clone）の作成・削除
6. VLAN, ブリッジ, LAGG, GRE, GIF, IPsec等の構成
7. 802.11無線LAN設定
8. MACアドレスの設定
9. FIB（Forwarding Information Base）の割り当て

**関連システム・外部連携**：カーネルネットワークインタフェース層（sys/net/）、libifconfig、Netlinkインタフェース（ifconfig_netlink.c）

**権限による制御**：インタフェース設定変更にはroot権限が必要。状態表示は一般ユーザでも可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ネットワークインターフェース選択画面 | 主機能 | ifconfigによるネットワークインターフェース一覧表示とAuto/Manual選択処理 |
| 7 | 無線LAN設定画面 | 主機能 | wpa_supplicantを使用した無線LANスキャン・SSID選択・認証設定処理 |
| 9 | IPv4スタティック設定画面 | 補助機能 | ifconfigによるインターフェースへのIPアドレス適用 |
| 11 | IPv6スタティック設定画面 | 補助機能 | ifconfigによるインターフェースへのIPv6アドレス適用 |
| 30 | 最終設定メニュー画面 | 遷移先機能 | Network選択時のnetconfig画面への遷移 |

## 機能種別

ネットワーク管理（CRUD操作 / 状態表示 / 構成変更）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| interface | string | No | インタフェース名（例: em0, wlan0） | 存在するインタフェース名 |
| inet/inet6 addr | string | No | 設定するIPアドレス | 有効なIPアドレス形式 |
| netmask | string | No | サブネットマスク | 有効なネットマスク形式 |
| up/down | flag | No | インタフェースの有効化/無効化 | - |
| mtu N | int | No | MTU値 | 正の整数 |
| create/destroy | flag | No | 仮想インタフェースの作成/削除 | - |
| -a | flag | No | 全インタフェース表示 | - |
| -l | flag | No | インタフェース名のみ表示 | - |

### 入力データソース

コマンドライン引数、ioctl/Netlinkによるカーネル通信

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| インタフェース情報 | text | 名前、フラグ、MTU、アドレス、メディア情報等 |
| インタフェース一覧 | text | -l時のインタフェース名リスト |

### 出力先

標準出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ インタフェース名、アドレスファミリー、コマンドワードの特定
2. ソケットオープン（AF_LOCAL, AF_INET, AF_INET6）
3. 操作モードの判定
   ├─ 表示モード: getifaddrs()またはNetlinkで情報取得
   └─ 設定モード: ioctlまたはNetlinkで設定変更
4. アドレスファミリー別の処理モジュール呼び出し
   ├─ af_inet.c: IPv4アドレス設定
   ├─ af_inet6.c: IPv6アドレス設定
   └─ af_link.c: MACアドレス設定
5. インタフェースタイプ別の処理モジュール呼び出し
   ├─ ifbridge.c: ブリッジ設定
   ├─ iflagg.c: LAGG設定
   └─ ifieee80211.c: 無線LAN設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{表示 or 設定?}
    C -->|表示| D[getifaddrs/Netlink]
    C -->|設定| E[ioctl/Netlink]
    D --> F[status出力]
    E --> G{操作タイプ}
    G -->|アドレス設定| H[af_inet/af_inet6]
    G -->|up/down| I[SIOCSIFFLAGS]
    G -->|create/destroy| J[ifclone]
    G -->|VLAN/Bridge等| K[専用モジュール]
    H --> L[完了]
    I --> L
    J --> L
    K --> L
    F --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | デフォルト表示 | インタフェース名のみ指定時は該当インタフェースの状態を表示 | 引数がインタフェース名のみ |
| BR-35-02 | エイリアスアドレス | aliasキーワードで同一インタフェースに複数アドレスを設定可能 | アドレス追加時 |
| BR-35-03 | Netlink優先 | WITHOUT_NETLINKマクロ未定義時はNetlinkインタフェースを使用 | コンパイル時設定 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EPERM | 権限不足 | 非root権限で設定変更 | root権限で実行 |
| ENXIO | デバイスなし | 存在しないインタフェース指定 | インタフェース名確認 |
| EEXIST | 既存 | 既に存在するcloneインタフェース作成 | 名前を変更 |
| EADDRNOTAVAIL | アドレス不正 | 無効なIPアドレス指定 | アドレス形式確認 |

### リトライ仕様

なし

## トランザクション仕様

各ioctl呼び出しはアトミック。複数のioctl呼び出しによる設定変更は個別に実行され、途中失敗時のロールバック機構はない。

## パフォーマンス要件

特になし（管理コマンドのため）

## セキュリティ考慮事項

- インタフェース設定変更にはroot権限（PRIV_NET_SETIFMTU等）が必要
- jail環境では設定可能なインタフェースが制限される
- MACフレームワークによるアクセス制御が適用可能

## 備考

ifconfigはNetlinkインタフェースとioctl インタフェースの両方をサポートしており、コンパイル時のWITHOUT_NETLINKマクロで切り替わる。libifconfigライブラリも使用される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ifconfig.h | `sbin/ifconfig/ifconfig.h` | if_ctx構造体、コマンドテーブル構造 |
| 1-2 | if.h | `sys/net/if.h` | struct ifreq、IFFフラグ定義 |

**読解のコツ**: ifconfigはモジュラー構造を採用しており、af_*.cがアドレスファミリー別処理、if*.cがインタフェースタイプ別処理を担当する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ifconfig.c | `sbin/ifconfig/ifconfig.c` | main()関数、コマンドライン解析、表示/設定モード分岐 |

**主要処理フロー**:
1. **76行目**: lifh（libifconfigハンドル）
2. **82-86行目**: グローバルフラグ（setaddr, setmask, doalias等）
3. **78-81行目**: WITHOUT_NETLINKによる条件コンパイル

#### Step 3: アドレスファミリー別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | af_inet.c | `sbin/ifconfig/af_inet.c` | IPv4アドレス設定 |
| 3-2 | af_inet6.c | `sbin/ifconfig/af_inet6.c` | IPv6アドレス設定 |
| 3-3 | af_link.c | `sbin/ifconfig/af_link.c` | MACアドレス設定 |

#### Step 4: インタフェースタイプ別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ifclone.c | `sbin/ifconfig/ifclone.c` | 仮想インタフェースの作成/削除 |
| 4-2 | ifbridge.c | `sbin/ifconfig/ifbridge.c` | ブリッジ設定 |
| 4-3 | iflagg.c | `sbin/ifconfig/iflagg.c` | LAGG設定 |

### プログラム呼び出し階層図

```
main() [ifconfig.c]
    |
    +-- ifconfig_open() [libifconfig]
    +-- 引数解析
    |
    +-- [表示モード]
    |   +-- list_interfaces_ioctl() / Netlink経由
    |   +-- status()
    |       +-- af_inet status / af_inet6 status / af_link status
    |
    +-- [設定モード]
        +-- af_inet setifaddr() / SIOCAIFADDR
        +-- af_inet6 setifaddr() / SIOCAIFADDR_IN6
        +-- SIOCSIFFLAGS (up/down)
        +-- SIOCSIFMTU (MTU)
        +-- ifclone_create() / ifclone_destroy()
```

### データフロー図

```
[入力]                     [処理]                        [出力]

コマンドライン引数 ──> main() 引数解析
                          |
                     ソケットオープン (AF_LOCAL)
                          |
                     ioctl / Netlink ──> カーネルネットワーク層
                          |
getifaddrs() ─────────> インタフェース情報取得 ──> 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ifconfig.c | `sbin/ifconfig/ifconfig.c` | ソース | メインエントリーポイント |
| ifconfig.h | `sbin/ifconfig/ifconfig.h` | ヘッダ | 共通構造体・定義 |
| af_inet.c | `sbin/ifconfig/af_inet.c` | ソース | IPv4アドレス管理 |
| af_inet6.c | `sbin/ifconfig/af_inet6.c` | ソース | IPv6アドレス管理 |
| af_link.c | `sbin/ifconfig/af_link.c` | ソース | リンクレベルアドレス |
| ifbridge.c | `sbin/ifconfig/ifbridge.c` | ソース | ブリッジ設定 |
| ifclone.c | `sbin/ifconfig/ifclone.c` | ソース | クローンインタフェース |
| iflagg.c | `sbin/ifconfig/iflagg.c` | ソース | LAGG設定 |
| ifieee80211.c | `sbin/ifconfig/ifieee80211.c` | ソース | 無線LAN設定 |
| ifconfig_netlink.c | `sbin/ifconfig/ifconfig_netlink.c` | ソース | Netlinkインタフェース |
| iffib.c | `sbin/ifconfig/iffib.c` | ソース | FIB設定 |
| ifconfig.8 | `sbin/ifconfig/ifconfig.8` | manページ | マニュアル |
