# 機能設計書 36-ルーティング

## 概要

本ドキュメントは、FreeBSDにおけるパケットルーティングテーブルの管理・経路制御を行うrouteコマンドおよびカーネルルーティングサブシステムの機能設計書である。

### 本機能の処理概要

routeコマンドは、カーネルのルーティングテーブルに対する経路の追加・削除・変更・表示を行うユーティリティである。また、routedデーモンは動的ルーティングプロトコル（RIPv1/v2）を実装し、隣接ルータとの経路情報の自動交換を行う。

**業務上の目的・背景**：ネットワークパケットの転送先（ネクストホップ）を決定するルーティングテーブルは、ネットワーク接続の根幹を成す。静的ルートの手動設定や動的ルーティングによる自動経路学習が必要である。

**機能の利用シーン**：デフォルトゲートウェイの設定、特定ネットワークへの静的ルート追加、ルーティングテーブルの確認・デバッグ、マルチパスルーティング、ポリシーベースルーティング（FIB）の構成で利用される。

**主要な処理内容**：
1. ルーティングエントリの追加（route add）
2. ルーティングエントリの削除（route delete）
3. ルーティングエントリの変更（route change）
4. ルーティングテーブルの表示（route get）
5. ルーティングテーブルのフラッシュ（route flush）
6. ルーティングメッセージの監視（route monitor）
7. FIB（複数ルーティングテーブル）の管理
8. Netlink経由のルーティング操作（route_netlink.c）

**関連システム・外部連携**：カーネルルーティングテーブル（sys/net/route.c）、Netlinkプロトコル、FIBサブシステム、routedデーモン

**権限による制御**：ルーティングテーブルの変更にはroot権限が必要。route getは一般ユーザでも実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツールのため画面機能マッピングに直接の関連なし |

## 機能種別

ネットワーク管理（ルーティングテーブルCRUD操作 / 経路監視）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| コマンド | string | Yes | add/delete/change/get/flush/monitor | 有効なコマンド名 |
| 宛先 | string | Yes | 宛先ネットワーク/ホスト | 有効なIPアドレスまたはネットワーク |
| ゲートウェイ | string | 条件付 | ネクストホップアドレス | 有効なIPアドレス |
| -net/-host | flag | No | ネットワーク/ホストルート指定 | - |
| -netmask | string | No | ネットマスク | 有効なネットマスク |
| -fib N | int | No | FIB番号 | 0からnet.fibs-1の範囲 |
| -ifp iface | string | No | 出力インタフェース指定 | 存在するインタフェース名 |

### 入力データソース

コマンドライン引数、ルーティングソケット（PF_ROUTE）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ルート情報 | text | 宛先、ゲートウェイ、フラグ、インタフェース等 |
| 監視メッセージ | text | ルーティングメッセージのリアルタイム表示 |
| 終了コード | int | 0=成功, 非0=エラー |

### 出力先

標準出力、標準エラー出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ keywordsテーブルでコマンドワードを識別
2. ルーティングソケット（PF_ROUTE）のオープン
3. コマンドに応じたルーティングメッセージの構築
   └─ struct rt_msghdr + sockaddr群
4. ルーティングソケットへの書き込み（write）
5. 応答メッセージの読み取り（read）
6. 結果の表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{コマンド判定}
    C -->|add| D[RTM_ADD メッセージ構築]
    C -->|delete| E[RTM_DELETE メッセージ構築]
    C -->|change| F[RTM_CHANGE メッセージ構築]
    C -->|get| G[RTM_GET メッセージ構築]
    C -->|flush| H[全エントリ削除ループ]
    C -->|monitor| I[ルーティングメッセージ監視ループ]
    D --> J[PF_ROUTEソケットへwrite]
    E --> J
    F --> J
    G --> J
    J --> K[応答read]
    K --> L[結果表示]
    H --> L
    I --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | FIBルーティング | -fibオプションで特定のFIBテーブルを操作可能 | FIB番号指定時 |
| BR-36-02 | Netlinkフォールバック | route_netlink.cによるNetlink経由の操作をサポート | Netlink有効時 |
| BR-36-03 | UID記録 | ルーティングメッセージにuid情報を含めて記録 | 全ルーティング操作時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（カーネルルーティングテーブルへの操作）

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ESRCH | エントリなし | 削除/変更対象のルートが存在しない | ルーティングテーブル確認 |
| EEXIST | 既存 | 既に存在するルートを追加 | changeコマンドを使用 |
| ENETUNREACH | 到達不能 | ゲートウェイに到達できない | ネットワーク構成確認 |
| EPERM | 権限不足 | 非root権限でルート変更 | root権限で実行 |

### リトライ仕様

なし

## トランザクション仕様

各ルーティングメッセージの処理はアトミック。flushコマンドは複数エントリを順次削除するため、途中で失敗しても既に削除されたエントリは元に戻らない。

## パフォーマンス要件

FIB参照はネットワークパケット転送のホットパスにあるため、カーネル側のルーティングテーブル参照は高速なアルゴリズム（DXR等）で実装されている。

## セキュリティ考慮事項

- ルーティングテーブル変更にはroot権限が必要
- jail環境ではルーティング操作が制限される（-jオプション対応）
- route monitorで他プロセスのルーティング変更を監視可能

## 備考

routeコマンドはNetlink対応版（route_netlink.c）も持ち、従来のPF_ROUTEソケットとNetlinkの両方をサポートする。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | route.h | `sys/net/route.h` | struct rt_msghdr（ルーティングメッセージヘッダ）、RTMメッセージタイプ、RTFフラグ |
| 1-2 | route.c (user) | `sbin/route/route.c` | struct fibl（FIBリスト）、keywordsテーブル、グローバル変数 |

**読解のコツ**: ルーティング操作はPF_ROUTEソケットを通じてカーネルと通信する。rt_msghdrにコマンドタイプとアドレスマスクを設定し、write()でカーネルに送信、read()で応答を受信するパターンを理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | route.c | `sbin/route/route.c` | main()関数、keywordsテーブルによるコマンド解析 |

**主要処理フロー**:
1. **68-74行目**: struct fibl（FIBリスト管理）
2. **76-82行目**: keywordsテーブル（keywords.hからinclude）
3. **84-100行目**: グローバル変数群（verbose, af, nflag等）

#### Step 3: Netlink対応を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | route_netlink.c | `sbin/route/route_netlink.c` | Netlink経由のルーティング操作 |

### プログラム呼び出し階層図

```
main() [route.c]
    |
    +-- keyword解析
    +-- socket(PF_ROUTE, SOCK_RAW) オープン
    |
    +-- [add/delete/change]
    |   +-- newroute() / rtmsg()
    |       +-- rt_msghdr構築
    |       +-- write(PF_ROUTE socket)
    |       +-- read() 応答
    |
    +-- [get]
    |   +-- rtmsg(RTM_GET)
    |
    +-- [flush]
    |   +-- flushroutes()
    |       +-- sysctl(NET_RT_DUMP)
    |       +-- 各エントリに対してrtmsg(RTM_DELETE)
    |
    +-- [monitor]
        +-- monitor() - read()ループ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──> keyword解析
                          |
                     rt_msghdr構築
                          |
                     PF_ROUTEソケット write ──> カーネルルーティングテーブル
                          |
                     PF_ROUTEソケット read  ──> 応答メッセージ
                          |
                     結果整形 ──> 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| route.c | `sbin/route/route.c` | ソース | routeコマンドメイン処理 |
| route_netlink.c | `sbin/route/route_netlink.c` | ソース | Netlink経由ルーティング操作 |
| keywords | `sbin/route/keywords` | 定義 | コマンドワード定義 |
| route.8 | `sbin/route/route.8` | manページ | routeマニュアル |
| route.h | `sys/net/route.h` | ヘッダ | ルーティングメッセージ定義 |
| route.c (kernel) | `sys/net/route.c` | ソース | カーネルルーティング処理 |
