# 機能設計書 45-audit（セキュリティ監査）

## 概要

本ドキュメントは、FreeBSDのBSM（Basic Security Module）ベースのセキュリティイベント監査機構について記述する。カーネル内のイベント生成、監査パイプ、ワーカースレッドによるトレイル書き込み、およびユーザ空間の監査管理ツール群を含む。

### 本機能の処理概要

audit機構はカーネル内のセキュリティ関連イベント（システムコール呼び出し、ファイルアクセス、認証操作等）を記録し、BSM（Basic Security Module）形式の監査トレイルとして保存する。

**業務上の目的・背景**：セキュリティ監査はコンプライアンス要件（SOX法、PCI DSS、HIPAA等）の充足、セキュリティインシデントの事後解析、不正アクセスの検知・追跡に不可欠な機能である。BSMはSun Microsystemsが開発した監査フレームワークであり、業界標準として広く認知されている。

**機能の利用シーン**：セキュリティ監査ポリシーの設定と管理、監査イベントのリアルタイム監視、監査トレイルの検索・フィルタリング、コンプライアンスレポートの生成素材としての監査ログ活用に使用される。

**主要な処理内容**：
1. カーネル内での監査イベント生成（audit_syscalls.c）
2. 監査レコードのBSMトークン形式へのエンコーディング（bsm_token.c）
3. 監査パイプ経由のリアルタイムイベント配信（audit_pipe.c）
4. 監査ワーカースレッドによるトレイルファイルへの書き込み（audit_worker.c）
5. auditdデーモンによる監査トレイルの管理（ローテーション、ディスク監視）
6. auditreduceによる監査トレイルの検索・フィルタリング
7. prauditによる監査トレイルの可読形式変換
8. audit_warn スクリプトによるディスク不足等の警告

**関連システム・外部連携**：MACフレームワークとの連携（mac_audit）、DTraceとの連携（audit_dtrace.c）、システムコールフレームワークとの統合。

**権限による制御**：監査設定の変更にはroot権限が必要。監査トレイルファイルのアクセスはauditグループに制限される。監査対象の選択はユーザ/グループ単位で設定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （CLIベースのためGUI画面なし） | - | auditd/auditreduce/prauditコマンドによる操作 |

## 機能種別

セキュリティ監査 / イベントログ記録 / 監査トレイル管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| audit_control | file | Yes | 監査制御設定（/etc/security/audit_control） | 有効なフラグ・ディレクトリ指定 |
| audit_user | file | No | ユーザ別監査設定（/etc/security/audit_user） | 有効なユーザ名とフラグ |
| audit_event | file | Yes | イベント番号-名前マッピング（/etc/security/audit_event） | 有効なイベント定義 |
| audit_class | file | Yes | 監査クラス定義（/etc/security/audit_class） | 有効なクラス定義 |

### 入力データソース

- /etc/security/配下の監査設定ファイル群
- カーネル内システムコールフレームワークからのイベント生成
- DTraceプローブからのイベント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| audit_trail | binary(BSM) | BSM形式の監査トレイルファイル |
| audit_pipe_events | binary(BSM) | リアルタイム監査イベントストリーム |
| praudit_output | text | 可読形式の監査レコード |
| auditreduce_output | binary(BSM) | フィルタリング済み監査トレイル |

### 出力先

- /var/audit/（監査トレイルファイル）
- /dev/auditpipe（リアルタイムイベント配信）
- 標準出力（praudit/auditreduce）

## 処理フロー

### 処理シーケンス

```
1. 監査初期化（audit.c）
   └─ 監査設定の読み込み、ワーカースレッドの起動
2. システムコール実行時のイベント生成
   └─ audit_syscalls.c内のaudit_syscall_enter/exit
3. 監査レコードの構築
   └─ audit_arg.c: 引数情報の収集、bsm_token.c: BSMトークン生成
4. 監査パイプへの配信
   └─ audit_pipe.c: リアルタイム監視クライアントへの配信
5. ワーカースレッドによるトレイル書き込み
   └─ audit_worker.c: バッファリングとファイル書き込み
6. auditdによるトレイル管理
   └─ トレイルローテーション、ディスク監視、ウォーニング通知
```

### フローチャート

```mermaid
flowchart TD
    A[システムコール実行] --> B{監査対象?}
    B -->|No| C[通常処理]
    B -->|Yes| D[監査レコード生成]
    D --> E[BSMトークンエンコード]
    E --> F[監査キューに追加]
    F --> G[監査パイプに配信]
    F --> H[ワーカースレッド]
    H --> I[トレイルファイル書き込み]
    I --> J{ファイルサイズ制限?}
    J -->|Yes| K[auditd通知・ローテーション]
    J -->|No| L[書き込み完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 監査クラス選択 | 監査対象イベントはクラス（lo,aa,ad,pc,ex等）単位で選択 | audit_control設定時 |
| BR-45-02 | 成功/失敗フィルタ | 各クラスについて成功時のみ、失敗時のみ、または両方を監査可能 | ユーザ/グローバル設定 |
| BR-45-03 | トレイルローテーション | 設定サイズを超えたトレイルファイルは自動的にローテーションされる | auditd運用時 |
| BR-45-04 | ディスク不足対応 | 監査ディスクが不足した場合、audit_warnスクリプトが通知し、設定によりシステム停止も可能 | ディスク容量閾値到達時 |

### 計算ロジック

- 監査フラグのマスク計算：ユーザ固有フラグとグローバルフラグの論理和/差分演算

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。BSM形式のバイナリ監査トレイルファイルを出力する。

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント生成 | audit_record | INSERT | BSM監査レコードの生成 |
| トレイル書き込み | audit trail file | APPEND | トレイルファイルへの追記 |
| auditreduce | audit trail file | SELECT | 条件に基づく監査レコード検索 |

### テーブル別操作詳細

#### audit_record（監査レコード）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | event, subject, object, return | システムコール実行情報 | BSMトークン形式 |
| SELECT | event class, date range, uid | auditreduceのフィルタ条件 | バイナリファイル検索 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOSPC | ディスク不足 | 監査トレイルのディスク容量不足 | audit_warn通知、ディスク拡張 |
| EPERM | 権限不足 | 非root権限での監査設定変更 | root権限で実行 |
| EINVAL | 設定エラー | 不正な監査クラス/フラグ指定 | 設定ファイルを修正 |

### リトライ仕様

トレイル書き込み失敗時はワーカースレッドがリトライする。ディスク不足時はauditdがaudit_warnスクリプトを実行し、設定によりシステム停止（halt）も選択可能。

## トランザクション仕様

監査レコードの書き込みは非同期で行われる。ワーカースレッドがバッファからトレイルファイルに書き込み、システムクラッシュ時に未書き込みのレコードが失われる可能性がある。

## パフォーマンス要件

- 監査イベント生成はシステムコールクリティカルパス上にあるため低オーバーヘッドが必須
- 監査対象外のイベントは早期にスキップ
- ワーカースレッドによる非同期書き込みでシステムコール遅延を最小化
- 監査パイプはカーネル-ユーザ空間間のゼロコピー転送を活用

## セキュリティ考慮事項

- 監査トレイルファイルの改ざん防止（パーミッション管理、リモートストレージ）
- 監査設定の不正変更防止
- 監査ディスク不足によるイベント喪失リスク
- 監査対象の設定漏れによるセキュリティイベントの見逃し

## 備考

- BSM監査フレームワークはSun Microsystemsが開発し、OpenBSMとしてオープンソース化
- macOS/iOS のセキュリティ監査にも同一のBSM形式が使用されている
- DTraceとの連携により監査イベントのリアルタイム分析が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BSM監査フレームワークのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | audit.h | `sys/security/audit/audit.h` | カーネル監査API定義。audit_record構造体、監査マクロ |
| 1-2 | audit_private.h | `sys/security/audit/audit_private.h` | 内部データ構造。kaudit_record構造体 |
| 1-3 | audit_kevents.h | `sys/bsm/audit_kevents.h` | 監査イベント番号の定義 |

**読解のコツ**: BSMのレコード構造はヘッダトークン、サブジェクトトークン、引数トークン、リターントークン等の連続で構成される。各トークンはTLV（Type-Length-Value）形式。

#### Step 2: カーネル監査中核を理解する

カーネル内監査フレームワークの初期化と制御を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | audit.c | `sys/security/audit/audit.c` | 監査サブシステムの初期化（38-79行目ヘッダinclude）。audit_init()、auditon()システムコール実装 |

**主要処理フロー**:
1. **38-79行目**: ヘッダインクルード。BSMヘッダ（bsm/audit.h, bsm/audit_internal.h, bsm/audit_kevents.h）とセキュリティモジュールヘッダ
2. audit_init(): 監査サブシステム初期化
3. auditon(): 監査パラメータの取得・設定システムコール

#### Step 3: イベント生成と引数収集を理解する

システムコール実行時の監査レコード生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | audit_syscalls.c | `sys/security/audit/audit_syscalls.c` | audit_syscall_enter/exit関数。システムコール前後での監査レコード生成 |
| 3-2 | audit_arg.c | `sys/security/audit/audit_arg.c` | 引数収集関数群。audit_arg_addr, audit_arg_fd, audit_arg_vnode等 |

#### Step 4: BSMエンコードとトレイル書き込みを理解する

BSMトークンへのエンコードとファイル書き込みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bsm_token.c | `sys/security/audit/bsm_token.c` | BSMトークンエンコード関数群 |
| 4-2 | audit_bsm.c | `sys/security/audit/audit_bsm.c` | BSM監査レコード生成 |
| 4-3 | audit_worker.c | `sys/security/audit/audit_worker.c` | ワーカースレッドによるトレイル書き込み |
| 4-4 | audit_pipe.c | `sys/security/audit/audit_pipe.c` | 監査パイプ（リアルタイム配信） |

### プログラム呼び出し階層図

```
カーネル（システムコール実行）
    │
    ├─ audit_syscalls.c: audit_syscall_enter()
    │      └─ 監査対象判定、レコード開始
    │
    ├─ audit_arg.c: audit_arg_*()
    │      └─ 引数情報の収集
    │
    ├─ audit_syscalls.c: audit_syscall_exit()
    │      ├─ audit_bsm.c: BSMレコード構築
    │      │      └─ bsm_token.c: BSMトークンエンコード
    │      ├─ audit_pipe.c: パイプ経由配信
    │      └─ audit_worker.c: トレイルファイル書き込み
    │
ユーザ空間:
    ├─ auditd: トレイル管理デーモン
    │      └─ audit_trigger.c: カーネルトリガー受信
    ├─ auditreduce: トレイルフィルタリング
    └─ praudit: BSM→テキスト変換
```

### データフロー図

```
[入力]                    [処理]                         [出力]

システムコール実行 ──▶ audit_syscall_enter/exit ──▶ BSM監査レコード
                      audit_arg_*()                    │
                      audit_bsm.c                      ├─▶ /var/audit/トレイル
                      bsm_token.c                      └─▶ /dev/auditpipe

audit_control ───▶ audit.c: audit_init() ───────▶ 監査パラメータ設定

auditreduce ────▶ トレイル読込・フィルタ ───▶ フィルタ済みトレイル
praudit ────────▶ BSMデコード ─────────────▶ テキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| audit.c | `sys/security/audit/audit.c` | ソース | 監査サブシステム中核 |
| audit_syscalls.c | `sys/security/audit/audit_syscalls.c` | ソース | システムコール監査フック |
| audit_arg.c | `sys/security/audit/audit_arg.c` | ソース | 引数収集関数群 |
| audit_bsm.c | `sys/security/audit/audit_bsm.c` | ソース | BSMレコード生成 |
| bsm_token.c | `sys/security/audit/bsm_token.c` | ソース | BSMトークンエンコード |
| audit_worker.c | `sys/security/audit/audit_worker.c` | ソース | トレイル書き込みワーカー |
| audit_pipe.c | `sys/security/audit/audit_pipe.c` | ソース | 監査パイプ（リアルタイム配信） |
| audit_trigger.c | `sys/security/audit/audit_trigger.c` | ソース | カーネルトリガー通知 |
| audit_dtrace.c | `sys/security/audit/audit_dtrace.c` | ソース | DTrace連携 |
| audit.h | `sys/security/audit/audit.h` | ヘッダ | カーネル監査API |
| audit_private.h | `sys/security/audit/audit_private.h` | ヘッダ | 内部データ構造 |
| audit_ioctl.h | `sys/security/audit/audit_ioctl.h` | ヘッダ | ioctl定義 |
| bsm_errno.c | `sys/security/audit/bsm_errno.c` | ソース | BSMエラー番号変換 |
| bsm_domain.c | `sys/security/audit/bsm_domain.c` | ソース | BSMドメイン変換 |
| bsm_fcntl.c | `sys/security/audit/bsm_fcntl.c` | ソース | BSM fcntl変換 |
| bsm_socket_type.c | `sys/security/audit/bsm_socket_type.c` | ソース | BSMソケットタイプ変換 |
